/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core.openapi;

import io.avaje.http.generator.core.ConsumesPrism;
import io.avaje.http.generator.core.ElementReader;
import io.avaje.http.generator.core.ParamType;
import io.avaje.http.generator.core.javadoc.Javadoc;
import io.avaje.http.generator.core.openapi.DocContext;
import io.avaje.http.generator.core.openapi.MethodDocBuilder;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.Optional;
import javax.lang.model.element.Element;

public class MethodParamDocBuilder {
    private static final String APP_FORM = "application/x-www-form-urlencoded";
    private static final String APP_JSON = "application/json";
    private static final String APP_TXT = "application/text";
    private final DocContext ctx;
    private final Javadoc javadoc;
    private final Operation operation;
    private final String paramName;
    private final String varName;
    private final String rawType;
    private final ParamType paramType;
    private final Element element;
    private final Optional<ConsumesPrism> consumeOp;

    public MethodParamDocBuilder(MethodDocBuilder methodDoc, ElementReader param) {
        this.ctx = methodDoc.getContext();
        this.javadoc = methodDoc.getJavadoc();
        this.operation = methodDoc.getOperation();
        this.consumeOp = methodDoc.consumeOp();
        this.paramType = param.paramType();
        this.paramName = param.paramName();
        this.varName = param.varName();
        this.rawType = param.type().full();
        this.element = param.element();
    }

    public void build() {
        if (this.paramType == ParamType.FORM || this.paramType == ParamType.BODY) {
            this.addMetaRequestBody(this.ctx, this.javadoc, this.operation);
        } else {
            Parameter param = new Parameter();
            param.setName(this.varName);
            param.setDescription(this.javadoc.getParams().get(this.paramName));
            Schema schema = this.ctx.toSchema(this.rawType, this.element);
            if (this.paramType == ParamType.FORMPARAM) {
                this.ctx.addFormParam(this.operation, this.varName, schema);
            } else {
                param.setSchema(schema);
                param.setIn(this.paramType.type());
                this.operation.addParametersItem(param);
            }
        }
    }

    private void addMetaRequestBody(DocContext ctx, Javadoc javadoc, Operation operation) {
        Schema schema = ctx.toSchema(this.rawType, this.element);
        String description = javadoc.getParams().get(this.paramName);
        String mediaType = this.consumeOp.map(ConsumesPrism::value).orElseGet(() -> this.requestMedia(schema));
        ctx.addRequestBody(operation, schema, mediaType, description);
    }

    private String requestMedia(Schema<?> schema) {
        if (schema instanceof StringSchema) {
            return APP_TXT;
        }
        boolean asForm = this.paramType == ParamType.FORM;
        return asForm ? APP_FORM : APP_JSON;
    }
}

