/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core.openapi;

import io.avaje.http.generator.core.HiddenPrism;
import io.avaje.http.generator.core.Util;
import io.avaje.http.generator.core.javadoc.Javadoc;
import io.avaje.http.generator.core.openapi.EmailPrism;
import io.avaje.http.generator.core.openapi.JavaxEmailPrism;
import io.avaje.http.generator.core.openapi.JavaxSizePrism;
import io.avaje.http.generator.core.openapi.KnownTypes;
import io.avaje.http.generator.core.openapi.SizePrism;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

class SchemaDocBuilder {
    private static final String APP_FORM = "application/x-www-form-urlencoded";
    private static final String APP_JSON = "application/json";
    private final Elements elements;
    private final Types types;
    private final KnownTypes knownTypes;
    private final TypeMirror iterableType;
    private final TypeMirror mapType;
    private final TypeMirror completableFutureType;
    private final Map<String, Schema> schemas = new TreeMap<String, Schema>();

    SchemaDocBuilder(Types types, Elements elements) {
        this.types = types;
        this.elements = elements;
        this.knownTypes = new KnownTypes();
        this.iterableType = types.erasure(elements.getTypeElement("java.lang.Iterable").asType());
        this.mapType = types.erasure(elements.getTypeElement("java.util.Map").asType());
        this.completableFutureType = types.erasure(elements.getTypeElement("java.util.concurrent.CompletableFuture").asType());
    }

    Map<String, Schema> getSchemas() {
        return this.schemas;
    }

    Content createContent(TypeMirror returnType, String mediaType) {
        MediaType mt = new MediaType();
        mt.setSchema(this.toSchema(returnType));
        Content content = new Content();
        content.addMediaType(mediaType, mt);
        return content;
    }

    void addFormParam(Operation operation, String varName, Schema schema) {
        RequestBody body = this.requestBody(operation);
        Schema formSchema = this.requestFormParamSchema(body);
        formSchema.addProperties(varName, schema);
    }

    private Schema requestFormParamSchema(RequestBody body) {
        Schema schema;
        Content content = body.getContent();
        MediaType mediaType = (MediaType)content.get(APP_FORM);
        if (mediaType != null) {
            schema = mediaType.getSchema();
        } else {
            schema = new Schema();
            schema.setType("object");
            mediaType = new MediaType();
            mediaType.schema(schema);
            content.addMediaType(APP_FORM, mediaType);
        }
        return schema;
    }

    void addRequestBody(Operation operation, Schema schema, String mediaType, String description) {
        RequestBody body = this.requestBody(operation);
        body.setDescription(description);
        MediaType mt = new MediaType();
        mt.schema(schema);
        body.getContent().addMediaType(mediaType, mt);
    }

    private RequestBody requestBody(Operation operation) {
        RequestBody body = operation.getRequestBody();
        if (body == null) {
            body = new RequestBody();
            body.setRequired(true);
            Content content = new Content();
            body.setContent(content);
            operation.setRequestBody(body);
        }
        return body;
    }

    private static TypeMirror typeArgument(TypeMirror type) {
        List<? extends TypeMirror> typeArguments = ((DeclaredType)type).getTypeArguments();
        return typeArguments.get(0);
    }

    Schema<?> toSchema(Element element) {
        Schema<?> schema = this.toSchema(element.asType());
        this.setLengthMinMax(element, schema);
        this.setFormatFromValidation(element, schema);
        if (this.isNotNullable(element)) {
            schema.setNullable(Boolean.FALSE);
        }
        return schema;
    }

    Schema<?> toSchema(TypeMirror type) {
        Schema<?> schema;
        if (this.types.isAssignable(type, this.completableFutureType)) {
            type = SchemaDocBuilder.typeArgument(type);
        }
        if ((schema = this.knownTypes.createSchema(Util.typeDef(type))) != null) {
            return schema;
        }
        if (this.types.isAssignable(type, this.mapType)) {
            return this.buildMapSchema(type);
        }
        if (type.getKind() == TypeKind.ARRAY) {
            return this.buildArraySchema(type);
        }
        if (this.types.isAssignable(type, this.iterableType)) {
            return this.buildIterableSchema(type);
        }
        Element e = this.types.asElement(type);
        if (e != null && e.getKind() == ElementKind.ENUM) {
            return this.buildEnumSchema(e);
        }
        return this.buildObjectSchema(type);
    }

    private Schema<?> buildEnumSchema(Element e) {
        StringSchema schema = new StringSchema();
        e.getEnclosedElements().stream().filter(ec -> ElementKind.ENUM_CONSTANT.equals((Object)ec.getKind())).forEach(ec -> schema.addEnumItem(ec.getSimpleName().toString()));
        Javadoc doc = Javadoc.parse(this.elements.getDocComment(e));
        String desc = doc.getDescription();
        if (desc != null && !desc.isEmpty()) {
            schema.setDescription(desc);
        }
        return schema;
    }

    private Schema<?> buildObjectSchema(TypeMirror type) {
        String objectSchemaKey = this.getObjectSchemaName(type);
        Schema objectSchema = this.schemas.get(objectSchemaKey);
        if (objectSchema == null) {
            objectSchema = new ObjectSchema();
            this.schemas.put(objectSchemaKey, objectSchema);
            this.populateObjectSchema(type, objectSchema);
        }
        Schema ref = new Schema();
        ref.$ref("#/components/schemas/" + objectSchemaKey);
        return ref;
    }

    private Schema<?> buildIterableSchema(TypeMirror type) {
        List<? extends TypeMirror> typeArguments;
        Schema<?> itemSchema = new ObjectSchema().format("unknownIterableType");
        if (type.getKind() == TypeKind.DECLARED && (typeArguments = ((DeclaredType)type).getTypeArguments()).size() == 1) {
            itemSchema = this.toSchema(typeArguments.get(0));
        }
        ArraySchema arraySchema = new ArraySchema();
        arraySchema.setItems(itemSchema);
        return arraySchema;
    }

    private Schema<?> buildArraySchema(TypeMirror type) {
        ArrayType arrayType = (ArrayType)type;
        Schema<?> itemSchema = this.toSchema(arrayType.getComponentType());
        ArraySchema arraySchema = new ArraySchema();
        arraySchema.setItems(itemSchema);
        return arraySchema;
    }

    private Schema<?> buildMapSchema(TypeMirror type) {
        DeclaredType declaredType;
        List<? extends TypeMirror> typeArguments;
        Schema<?> valueSchema = new ObjectSchema().format("unknownMapValueType");
        if (type.getKind() == TypeKind.DECLARED && (typeArguments = (declaredType = (DeclaredType)type).getTypeArguments()).size() == 2) {
            valueSchema = this.toSchema(typeArguments.get(1));
        }
        MapSchema mapSchema = new MapSchema();
        mapSchema.setAdditionalProperties(valueSchema);
        return mapSchema;
    }

    private String getObjectSchemaName(TypeMirror type) {
        String canonicalName = Util.trimAnnotations(type.toString());
        int pos = canonicalName.lastIndexOf(46);
        if (pos > -1) {
            canonicalName = canonicalName.substring(pos + 1);
        }
        return canonicalName;
    }

    private <T> void populateObjectSchema(TypeMirror objectType, Schema<T> objectSchema) {
        Element element = this.types.asElement(objectType);
        for (VariableElement field : this.allFields(element)) {
            Schema<?> propSchema = this.toSchema(field.asType());
            if (this.isNotNullable(field)) {
                propSchema.setNullable(Boolean.FALSE);
                objectSchema.addRequiredItem(field.getSimpleName().toString());
            }
            this.setDescription(field, propSchema);
            this.setLengthMinMax(field, propSchema);
            this.setFormatFromValidation(field, propSchema);
            objectSchema.addProperties(field.getSimpleName().toString(), propSchema);
        }
    }

    private void setFormatFromValidation(Element element, Schema<?> propSchema) {
        if (EmailPrism.isPresent(element) || JavaxEmailPrism.isPresent(element)) {
            propSchema.setFormat("email");
        }
    }

    private void setDescription(Element element, Schema<?> propSchema) {
        Javadoc doc = Javadoc.parse(this.elements.getDocComment(element));
        if (!doc.getSummary().isEmpty()) {
            propSchema.setDescription(doc.getSummary());
            return;
        }
        try {
            Element enclosingElement = element.getEnclosingElement();
            if (enclosingElement.getKind() == ElementKind.valueOf("RECORD")) {
                Optional.of(Javadoc.parse(this.elements.getDocComment(enclosingElement))).map(d -> d.getParams().get(element.getSimpleName().toString())).ifPresent(propSchema::setDescription);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void setLengthMinMax(Element element, Schema<?> propSchema) {
        SizePrism.getOptionalOn(element).ifPresent(size -> {
            if (size.min() > 0) {
                propSchema.setMinLength(size.min());
            }
            if (size.max() > 0) {
                propSchema.setMaxLength(size.max());
            }
        });
        JavaxSizePrism.getOptionalOn(element).ifPresent(size -> {
            if (size.min() > 0) {
                propSchema.setMinLength(size.min());
            }
            if (size.max() > 0) {
                propSchema.setMaxLength(size.max());
            }
        });
    }

    private boolean isNotNullable(Element element) {
        return element.getAnnotationMirrors().stream().anyMatch(m -> m.toString().contains("@") && Stream.of("NotNull", "NotEmpty", "NotBlank").anyMatch(annotation -> m.toString().contains((CharSequence)annotation)));
    }

    private List<VariableElement> allFields(Element element) {
        ArrayList<VariableElement> list = new ArrayList<VariableElement>();
        this.gatherProperties(list, element);
        return list;
    }

    private void gatherProperties(List<VariableElement> fields, Element element) {
        if (element == null) {
            return;
        }
        if (element instanceof TypeElement) {
            Element mappedSuper = this.types.asElement(((TypeElement)element).getSuperclass());
            if (mappedSuper != null && !"java.lang.Object".equals(mappedSuper.toString()) && !"java.lang.Record".equals(mappedSuper.toString())) {
                this.gatherProperties(fields, mappedSuper);
            }
            for (VariableElement field : ElementFilter.fieldsIn(element.getEnclosedElements())) {
                if (this.ignoreField(field)) continue;
                fields.add(field);
            }
        }
    }

    private boolean ignoreField(VariableElement field) {
        return this.isStaticOrTransient(field) || this.isHiddenField(field);
    }

    private boolean isHiddenField(VariableElement field) {
        if (HiddenPrism.isPresent(field)) {
            return true;
        }
        for (AnnotationMirror annotationMirror : field.getAnnotationMirrors()) {
            String simpleName = annotationMirror.getAnnotationType().asElement().getSimpleName().toString();
            if (!"JsonIgnore".equals(simpleName)) continue;
            return true;
        }
        return false;
    }

    private boolean isStaticOrTransient(VariableElement field) {
        Set<Modifier> modifiers = field.getModifiers();
        return modifiers.contains((Object)Modifier.STATIC) || modifiers.contains((Object)Modifier.TRANSIENT);
    }
}

