/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.core.openapi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

final class SizePrism {
    private final String _message;
    private final List<TypeMirror> _groups;
    private final List<TypeMirror> _payload;
    private final Integer _min;
    private final Integer _max;
    public static final String PRISM_TYPE = "jakarta.validation.constraints.Size";
    final Values values;
    final boolean isValid;
    final AnnotationMirror mirror;
    private final Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
    private final Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
    private boolean valid = true;

    static boolean isInstance(AnnotationMirror mirror) {
        return SizePrism.getInstance(mirror) != null;
    }

    static boolean isPresent(Element element) {
        return SizePrism.getInstanceOn(element) != null;
    }

    static SizePrism getInstanceOn(Element element) {
        AnnotationMirror mirror = SizePrism.getMirror(element);
        if (mirror == null) {
            return null;
        }
        return SizePrism.getInstance(mirror);
    }

    static Optional<SizePrism> getOptionalOn(Element element) {
        AnnotationMirror mirror = SizePrism.getMirror(element);
        if (mirror == null) {
            return Optional.empty();
        }
        return SizePrism.getOptional(mirror);
    }

    static List<SizePrism> getAllInstancesOn(Element element) {
        return SizePrism.getMirrors(element).map(SizePrism::getInstance).collect(Collectors.toList());
    }

    static List<SizePrism> getAllOnMetaAnnotations(Element element) {
        if (element == null || element.getAnnotationMirrors().isEmpty()) {
            return List.of();
        }
        return SizePrism.getAllOnMetaAnnotations(element, new HashSet<String>()).collect(Collectors.toList());
    }

    private static Stream<SizePrism> getAllOnMetaAnnotations(Element element, Set<String> seen) {
        if (element == null || element.getAnnotationMirrors().isEmpty()) {
            return Stream.of(new SizePrism[0]);
        }
        return element.getAnnotationMirrors().stream().map(AnnotationMirror::getAnnotationType).filter(t -> seen.add(t.toString())).map(DeclaredType::asElement).flatMap(e -> Stream.concat(SizePrism.getAllOnMetaAnnotations(e, seen), SizePrism.getMirrors(element).map(SizePrism::getInstance)));
    }

    static SizePrism getInstance(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return null;
        }
        return new SizePrism(mirror);
    }

    static Optional<SizePrism> getOptional(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return Optional.empty();
        }
        return Optional.of(new SizePrism(mirror));
    }

    private SizePrism(AnnotationMirror mirror) {
        for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
            this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
            this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
        }
        this._message = this.getValue("message", String.class);
        this._groups = this.getArrayValues("groups", TypeMirror.class);
        this._payload = this.getArrayValues("payload", TypeMirror.class);
        this._min = this.getValue("min", Integer.class);
        this._max = this.getValue("max", Integer.class);
        this.values = new Values(this.memberValues);
        this.mirror = mirror;
        this.isValid = this.valid;
    }

    public String message() {
        return this._message;
    }

    public List<TypeMirror> groups() {
        return this._groups;
    }

    public List<TypeMirror> payload() {
        return this._payload;
    }

    public Integer min() {
        return this._min;
    }

    public Integer max() {
        return this._max;
    }

    private <T> T getValue(String name, Class<T> clazz) {
        T result = SizePrism.getValue(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private <T> List<T> getArrayValues(String name, Class<T> clazz) {
        List<T> result = SizePrism.getArrayValues(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private static AnnotationMirror getMirror(Element target) {
        for (AnnotationMirror annotationMirror : target.getAnnotationMirrors()) {
            Name mfqn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!PRISM_TYPE.contentEquals(mfqn)) continue;
            return annotationMirror;
        }
        return null;
    }

    private static Stream<? extends AnnotationMirror> getMirrors(Element target) {
        return target.getAnnotationMirrors().stream().filter(m -> PRISM_TYPE.contentEquals(((TypeElement)m.getAnnotationType().asElement()).getQualifiedName()));
    }

    private static <T> T getValue(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return null;
        }
        if (clazz.isInstance(av.getValue())) {
            return clazz.cast(av.getValue());
        }
        return null;
    }

    private static <T> List<T> getArrayValues(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return List.of();
        }
        if (av.getValue() instanceof List) {
            ArrayList<T> result = new ArrayList<T>();
            for (AnnotationValue v : SizePrism.getValueAsList(av)) {
                if (clazz.isInstance(v.getValue())) {
                    result.add(clazz.cast(v.getValue()));
                    continue;
                }
                return List.of();
            }
            return result;
        }
        return List.of();
    }

    private static List<AnnotationValue> getValueAsList(AnnotationValue av) {
        return (List)av.getValue();
    }

    static final class Values {
        private final Map<String, AnnotationValue> values;

        private Values(Map<String, AnnotationValue> values) {
            this.values = values;
        }

        AnnotationValue message() {
            return this.values.get("message");
        }

        AnnotationValue groups() {
            return this.values.get("groups");
        }

        AnnotationValue payload() {
            return this.values.get("payload");
        }

        AnnotationValue min() {
            return this.values.get("min");
        }

        AnnotationValue max() {
            return this.values.get("max");
        }
    }
}

