/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.http.generator.javalin;

import io.avaje.http.generator.core.Append;
import io.avaje.http.generator.core.CoreWebMethod;
import io.avaje.http.generator.core.JsonBUtil;
import io.avaje.http.generator.core.MethodParam;
import io.avaje.http.generator.core.MethodReader;
import io.avaje.http.generator.core.PathSegments;
import io.avaje.http.generator.core.ProcessingContext;
import io.avaje.http.generator.core.UType;
import io.avaje.http.generator.core.Util;
import io.avaje.http.generator.core.WebMethod;
import io.avaje.http.generator.core.openapi.MediaType;
import io.avaje.http.generator.javalin.JavalinWebMethod;
import java.util.List;

class ControllerMethodWriter {
    private final MethodReader method;
    private final Append writer;
    private final WebMethod webMethod;
    private final boolean useJsonB;
    private final boolean instrumentContext;
    private final boolean customMethod;

    ControllerMethodWriter(MethodReader method, Append writer, boolean useJsonB) {
        this.method = method;
        this.writer = writer;
        WebMethod webM = method.webMethod();
        this.webMethod = webM == CoreWebMethod.FILTER ? JavalinWebMethod.BEFORE : webM;
        this.useJsonB = useJsonB && !ProcessingContext.disabledDirectWrites();
        this.instrumentContext = method.instrumentContext();
        this.customMethod = !(this.webMethod instanceof CoreWebMethod);
    }

    void write(boolean requestScoped) {
        PathSegments segments = this.method.pathSegments();
        String fullPath = segments.fullPath();
        this.writeMethod(fullPath);
        List<MethodParam> params = this.writeParams(segments);
        this.writer.append("      ");
        if (!this.method.isVoid() && !this.customMethod) {
            this.writer.append("var result = ");
        }
        if (this.instrumentContext) {
            this.method.writeContext(this.writer, "ctx", "ctx");
        }
        if (requestScoped) {
            this.writer.append("factory.create(ctx).");
        } else {
            this.writer.append("controller.");
        }
        this.writer.append(this.method.simpleName()).append("(");
        for (int i = 0; i < params.size(); ++i) {
            MethodParam param;
            if (i > 0) {
                this.writer.append(", ");
            }
            if (ProcessingContext.isAssignable2Interface((param = params.get(i)).utype().mainType(), "java.lang.Exception")) {
                this.writer.append("ex");
                continue;
            }
            param.buildParamName(this.writer);
        }
        if (this.instrumentContext) {
            this.writer.append(")");
        }
        this.writer.append(");").eol();
        if (!this.method.isVoid() && !this.customMethod) {
            this.writeContextReturn();
            this.writer.eol();
        }
        this.writer.append("    }");
        List<String> roles = this.method.roles();
        if (!roles.isEmpty() && !this.customMethod) {
            this.writer.append(", ");
            for (int i = 0; i < roles.size(); ++i) {
                if (i > 0) {
                    this.writer.append(", ");
                }
                this.writer.append(Util.shortName(roles.get(i), true));
            }
        }
        this.writer.append(");").eol().eol();
    }

    private void writeMethod(String fullPath) {
        int statusCode;
        if (this.method.isErrorMethod()) {
            this.writer.append("    app.exception(%s.class, (ex, ctx) -> {", this.method.exceptionShortName()).eol();
        } else {
            String methodName = this.webMethod.name().toLowerCase().replace("_m", "M");
            this.writer.append("    app.%s(\"%s\", ctx -> {", methodName, fullPath).eol();
        }
        if (!this.customMethod && (statusCode = this.method.statusCode()) > 0) {
            this.writer.append("      ctx.status(%d);", statusCode).eol();
        }
    }

    private List<MethodParam> writeParams(PathSegments segments) {
        List<PathSegments.Segment> matrixSegments = segments.matrixSegments();
        for (PathSegments.Segment matrixSegment : matrixSegments) {
            matrixSegment.writeCreateSegment(this.writer, ProcessingContext.platform());
        }
        List<MethodParam> params = this.method.params();
        for (MethodParam param : params) {
            if (ProcessingContext.isAssignable2Interface(param.utype().mainType(), "java.lang.Exception")) continue;
            param.writeCtxGet(this.writer, segments);
        }
        if (this.method.includeValidate()) {
            for (MethodParam param : params) {
                param.writeValidate(this.writer);
            }
        }
        return params;
    }

    private void writeContextReturn() {
        UType type;
        if (this.instrumentContext) {
            this.writer.append("      if (ctx.resultInputStream() != null || ctx.res().isCommitted()) return;").eol();
        }
        if ("java.util.concurrent.CompletableFuture".equals((type = UType.parse(this.method.returnType())).mainType())) {
            if (!type.isGeneric()) {
                ProcessingContext.logError(this.method.element(), "CompletableFuture must be generic type (e.g. CompletableFuture<String>, CompletableFuture<Void>).", new Object[0]);
            }
            String futureResultVariableName = "futureResult";
            this.writer.append("      ctx.future(() -> {").eol();
            this.writer.append("        return result.thenAccept(%s -> {", "futureResult").eol();
            this.writer.append("    ");
            this.writeContextReturn("futureResult");
            this.writer.eol().append("        });").eol();
            this.writer.append("      });");
            return;
        }
        this.writeContextReturn("result");
    }

    private void writeContextReturn(String resultVariableName) {
        boolean applicationJson;
        String produces = this.method.produces();
        boolean bl = applicationJson = produces == null || MediaType.APPLICATION_JSON.getValue().equalsIgnoreCase(produces);
        if (applicationJson || JsonBUtil.isJsonMimeType(produces)) {
            if (this.useJsonB) {
                UType uType = UType.parse(this.method.returnType());
                boolean isfuture = "java.util.concurrent.CompletableFuture".equals(uType.mainType());
                if (isfuture || this.method.isErrorMethod()) {
                    if (isfuture) {
                        uType = uType.paramRaw();
                    }
                    this.writer.append("      try {");
                }
                if (produces == null) {
                    produces = MediaType.APPLICATION_JSON.getValue();
                }
                this.writer.append("      %sJsonType.toJson(%s, ctx.contentType(\"%s\").res().getOutputStream());", uType.shortName(), resultVariableName, produces);
                if (isfuture || this.method.isErrorMethod()) {
                    this.writer.append("      } catch (java.io.IOException e) { throw new java.io.UncheckedIOException(e); }");
                }
            } else if (applicationJson) {
                this.writer.append("      ctx.json(%s);", resultVariableName);
            } else {
                this.writer.append("      ctx.contentType(\"%s\").json(%s);", produces, resultVariableName);
            }
        } else if (MediaType.TEXT_HTML.getValue().equalsIgnoreCase(produces)) {
            this.writer.append("      ctx.html(%s);", resultVariableName);
        } else if (MediaType.TEXT_PLAIN.getValue().equalsIgnoreCase(produces)) {
            this.writer.append("      ctx.contentType(\"text/plain\").result(%s);", resultVariableName);
        } else {
            this.writer.append("      ctx.contentType(\"%s\").result(%s);", produces, resultVariableName);
        }
    }
}

