/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.aop;

import io.avaje.inject.aop.InvocationException;
import io.avaje.inject.aop.MethodInterceptor;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import java.util.function.Function;

public interface Invocation {
    public Object invoke() throws Throwable;

    default public Object invokeUnchecked() {
        try {
            return this.invoke();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InvocationException(e);
        }
    }

    public void result(Object var1);

    public Object[] arguments();

    public Method method();

    public Object instance();

    public boolean hasRecoveryMethod();

    public Object invokeRecoveryMethod(Throwable var1);

    @FunctionalInterface
    public static interface CheckedSupplier<T> {
        public T invoke() throws Throwable;
    }

    @FunctionalInterface
    public static interface CheckedRunnable {
        public void invoke() throws Throwable;
    }

    public static final class Call<T>
    extends Base<T> {
        private final CheckedSupplier<T> delegate;
        private Function<Throwable, T> fallback;

        public Call(CheckedSupplier<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object invoke() throws Throwable {
            this.result = this.delegate.invoke();
            return this.result;
        }

        @Override
        public T finalResult() {
            return (T)this.result;
        }

        @Override
        public Call<T> with(Object instance, Method method, Object ... args) {
            super.with(instance, method, args);
            return this;
        }

        public Call<T> fallback(Function<Throwable, T> fallback) {
            this.fallback = fallback;
            return this;
        }

        @Override
        public Base<T> wrap(MethodInterceptor methodInterceptor) {
            return new Call<Object>(() -> {
                Call delegate = this;
                methodInterceptor.invoke(delegate);
                return delegate.finalResult();
            }).with(this.instance, this.method, this.args);
        }

        @Override
        public boolean hasRecoveryMethod() {
            return this.fallback != null;
        }

        @Override
        public Object invokeRecoveryMethod(Throwable t) {
            this.noRecovery(this.fallback);
            T result = this.fallback.apply(t);
            super.result(result);
            return result;
        }
    }

    public static final class Run
    extends Base<Void> {
        private final CheckedRunnable delegate;
        private Consumer<Throwable> fallback;

        public Run(CheckedRunnable delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object invoke() throws Throwable {
            this.delegate.invoke();
            return null;
        }

        public Run fallback(Consumer<Throwable> fallback) {
            this.fallback = fallback;
            return this;
        }

        @Override
        public Base<Void> wrap(MethodInterceptor methodInterceptor) {
            return new Run(() -> methodInterceptor.invoke(this)).with(this.instance, this.method, this.args);
        }

        @Override
        public boolean hasRecoveryMethod() {
            return this.fallback != null;
        }

        @Override
        public Object invokeRecoveryMethod(Throwable t) {
            this.noRecovery(this.fallback);
            this.fallback.accept(t);
            return null;
        }

        public Run with(Object instance, Method method, Object ... args) {
            super.with(instance, method, args);
            return this;
        }
    }

    public static abstract class Base<T>
    implements Invocation {
        protected Method method;
        protected Object[] args;
        protected Object instance;
        protected T result;

        public Base<T> with(Object instance, Method method, Object ... args) {
            this.instance = instance;
            this.method = method;
            this.args = args;
            return this;
        }

        @Override
        public void result(Object result) {
            this.result = result;
        }

        public T finalResult() {
            return this.result;
        }

        @Override
        public Object[] arguments() {
            return this.args;
        }

        @Override
        public Method method() {
            return this.method;
        }

        @Override
        public Object instance() {
            return this.instance;
        }

        public abstract Base<T> wrap(MethodInterceptor var1);

        protected void noRecovery(Object recover) {
            if (recover == null) {
                throw new IllegalStateException("No recovery method available for this invocation");
            }
        }
    }
}

