/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.events;

import io.avaje.inject.events.Observer;
import io.avaje.inject.events.ObserverManager;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;

public abstract class Event<T> {
    private static final Comparator<Observer<?>> PRIORITY = Comparator.comparing(Observer::priority);
    protected final List<Observer<T>> observers;
    protected final String defaultQualifier;

    protected Event(ObserverManager manager, Type type) {
        this(manager, type, "");
    }

    protected Event(ObserverManager manager, Type type, String qualifier) {
        this.observers = manager.observersByType(type);
        this.defaultQualifier = qualifier;
    }

    public void fire(T event, String qualifier) {
        this.observers.stream().sorted(PRIORITY).forEach(observer -> observer.observe(event, qualifier, false));
    }

    public CompletionStage<T> fireAsync(T event, String qualifier) {
        CollectingExceptionHandler exceptionHandler = new CollectingExceptionHandler();
        return this.observers.stream().sorted(PRIORITY).reduce(CompletableFuture.completedFuture(null), (future, observer) -> future.thenRun(() -> {
            try {
                observer.observe(event, qualifier, true);
            }
            catch (Exception e) {
                exceptionHandler.handle(e);
            }
        }), (future1, future2) -> future1).thenApply(v -> {
            this.handleExceptions(exceptionHandler);
            return event;
        });
    }

    public void fire(T event) {
        this.fire(event, this.defaultQualifier);
    }

    public CompletionStage<T> fireAsync(T event) {
        return this.fireAsync(event, this.defaultQualifier);
    }

    private void handleExceptions(CollectingExceptionHandler handler) {
        List<Exception> handledExceptions = handler.handledExceptions();
        if (!handledExceptions.isEmpty()) {
            CompletionException exception = handledExceptions.size() == 1 ? new CompletionException(handledExceptions.get(0)) : new CompletionException(null);
            for (Throwable throwable : handledExceptions) {
                exception.addSuppressed(throwable);
            }
            throw exception;
        }
    }

    private static final class CollectingExceptionHandler {
        private final List<Exception> throwables;

        CollectingExceptionHandler() {
            this(new ArrayList<Exception>());
        }

        CollectingExceptionHandler(List<Exception> throwables) {
            this.throwables = throwables;
        }

        void handle(Exception throwable) {
            this.throwables.add(throwable);
        }

        List<Exception> handledExceptions() {
            return this.throwables;
        }
    }
}

