/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.APContext;
import io.avaje.inject.generator.Append;
import io.avaje.inject.generator.Util;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

final class AnnotationCopier {
    private AnnotationCopier() {
    }

    static void copyAnnotations(Append writer, Element element, boolean newLines) {
        AnnotationCopier.copyAnnotations(writer, element, "", newLines);
    }

    static void copyAnnotations(Append writer, Element element, String indent, boolean newLines) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            String type = annotationMirror.getAnnotationType().asElement().asType().toString();
            if (type.startsWith("io.avaje.inject.Assist")) continue;
            String annotationString = AnnotationCopier.toAnnotationString(indent, annotationMirror, false);
            writer.append(annotationString);
            if (newLines) {
                writer.eol();
                continue;
            }
            writer.append(" ");
        }
    }

    static String toSimpleAnnotationString(AnnotationMirror annotationMirror) {
        return Util.trimAnnotationString(AnnotationCopier.toAnnotationString("", annotationMirror, true)).substring(1);
    }

    static String toAnnotationString(String indent, AnnotationMirror annotationMirror, boolean simpleEnums) {
        String annotationName = annotationMirror.getAnnotationType().toString();
        StringBuilder sb = new StringBuilder(indent).append("@").append(annotationName).append("(");
        boolean first = true;
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : AnnotationCopier.sortedValues(annotationMirror)) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(entry.getKey().getSimpleName()).append("=");
            AnnotationCopier.writeVal(sb, entry.getValue(), simpleEnums);
            first = false;
        }
        return sb.append(")").toString().replace("()", "");
    }

    private static List<Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>> sortedValues(AnnotationMirror annotationMirror) {
        return APContext.elements().getElementValuesWithDefaults(annotationMirror).entrySet().stream().sorted(AnnotationCopier::compareBySimpleName).collect(Collectors.toList());
    }

    private static int compareBySimpleName(Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry1, Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry2) {
        return entry1.getKey().getSimpleName().toString().compareTo(entry2.getKey().getSimpleName().toString());
    }

    private static void writeVal(StringBuilder sb, AnnotationValue annotationValue, boolean simpleEnums) {
        Object value = annotationValue.getValue();
        if (value instanceof List) {
            sb.append("{");
            boolean first = true;
            for (AnnotationValue listValue : (List)value) {
                if (!first) {
                    sb.append(", ");
                }
                AnnotationCopier.writeVal(sb, listValue, simpleEnums);
                first = false;
            }
            sb.append("}");
        } else if (value instanceof VariableElement) {
            VariableElement element = (VariableElement)value;
            TypeMirror type = element.asType();
            VariableElement str = simpleEnums ? element : type.toString() + "." + String.valueOf(element);
            sb.append(str);
        } else if (value instanceof AnnotationMirror) {
            AnnotationMirror mirror = (AnnotationMirror)value;
            String annotationName = mirror.getAnnotationType().toString();
            sb.append("@").append(annotationName).append("(");
            boolean first = true;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : AnnotationCopier.sortedValues(mirror)) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(entry.getKey().getSimpleName()).append("=");
                AnnotationCopier.writeVal(sb, entry.getValue(), simpleEnums);
                first = false;
            }
            sb.append(")");
        } else {
            sb.append(annotationValue);
        }
    }
}

