/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.Append;
import io.avaje.inject.generator.ImportTypeMap;
import io.avaje.inject.generator.RequestScope;
import io.avaje.inject.generator.Util;

final class BeanRequestParams {
    private final String parentType;
    private RequestScope.Handler reqScopeHandler;

    BeanRequestParams(String parentType) {
        this.parentType = parentType;
    }

    boolean check(String paramType) {
        if (paramType != null && RequestScope.check(paramType)) {
            if (this.reqScopeHandler == null) {
                this.reqScopeHandler = RequestScope.handler(paramType);
            }
            return true;
        }
        return false;
    }

    boolean isRequestScopedController() {
        return this.reqScopeHandler != null;
    }

    void factoryInterface(Append writer) {
        this.reqScopeHandler.factoryInterface(writer, this.nm(this.parentType));
    }

    void addImports(ImportTypeMap importTypes) {
        if (this.reqScopeHandler != null) {
            importTypes.add("javax.inject.Singleton");
            importTypes.add("javax.inject.Inject");
            this.reqScopeHandler.addImports(importTypes);
        }
    }

    void writeRequestCreate(Append writer) {
        writer.append("  @Override").eol();
        this.reqScopeHandler.writeCreateMethod(writer, this.nm(this.parentType));
    }

    String argumentName(String paramType) {
        return this.reqScopeHandler.argumentName(paramType);
    }

    private String nm(String raw) {
        return Util.shortName(raw);
    }
}

