/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.APContext;
import io.avaje.inject.generator.Append;
import io.avaje.inject.generator.BeanReader;
import io.avaje.inject.generator.FieldReader;
import io.avaje.inject.generator.MethodReader;
import io.avaje.inject.generator.ObservesPrism;
import io.avaje.inject.generator.UType;
import io.avaje.inject.generator.Util;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeKind;
import javax.tools.JavaFileObject;

final class SimpleBeanWriter {
    private static final String CODE_COMMENT = "/**\n * Generated source - dependency injection builder for %s.\n */";
    private static final String CODE_COMMENT_FACTORY = "/**\n * Generated source - dependency injection factory for request scoped %s.\n */";
    private static final String CODE_COMMENT_BUILD = "  /**\n   * Create and register %s.\n   */";
    private static final String CODE_COMMENT_BUILD_PROVIDER = "  /**\n   * Register %s provider.\n   */";
    private final BeanReader beanReader;
    private final String originName;
    private final String shortName;
    private final String packageName;
    private final String suffix;
    private final boolean proxied;
    private Append writer;
    private String indent = "     ";

    SimpleBeanWriter(BeanReader beanReader) {
        this.beanReader = beanReader;
        this.packageName = beanReader.packageName();
        this.shortName = beanReader.shortName();
        this.suffix = beanReader.suffix();
        this.proxied = beanReader.isGenerateProxy();
        this.originName = this.packageName + "." + this.shortName;
    }

    private Writer createFileWriter() throws IOException {
        String originName = this.originName;
        if (this.beanReader.beanType().getNestingKind().isNested()) {
            originName = originName.replace(this.shortName, this.shortName.replace(".", "$"));
        }
        JavaFileObject jfo = APContext.createSourceFile(originName + this.suffix, new Element[0]);
        return jfo.openWriter();
    }

    void write() throws IOException {
        this.writer = new Append(this.createFileWriter());
        this.writePackage();
        this.writeImports();
        this.writeClassStart();
        if (this.isRequestScopedController()) {
            this.writeRequestCreate();
        } else {
            this.writeGenericTypeFields();
            this.writeStaticFactoryMethod();
            this.writeStaticFactoryBeanMethods();
        }
        this.writeClassEnd();
        this.writer.close();
    }

    private void writeGenericTypeFields() {
        Set genericTypes = this.beanReader.allGenericTypes().stream().map(Util::unwrapProvider).filter(UType::isGeneric).collect(Collectors.toSet());
        if (!genericTypes.isEmpty()) {
            HashMap<String, String> seenShortNames = new HashMap<String, String>();
            HashSet<String> writtenFields = new HashSet<String>();
            for (UType utype : genericTypes) {
                UType type = Util.unwrapProvider(utype);
                String fieldName = Util.shortName(type).replace(".", "_");
                List<UType> components = type.componentTypes();
                if (components.size() == 1 && components.get(0).kind() == TypeKind.WILDCARD || components.stream().anyMatch(u -> u.kind() == TypeKind.TYPEVAR) || !writtenFields.add(fieldName)) continue;
                this.writer.append("  public static final Type TYPE_%s =", fieldName).eol().append("      new GenericType<");
                this.writeGenericType(type, seenShortNames, this.writer);
                this.writer.append(">(){}.type();").eol();
            }
            this.writer.eol();
        }
    }

    private void writeGenericType(UType type, Map<String, String> seenShortNames, Append writer) {
        String typeShortName = Util.shortName(type.mainType());
        String mainType = seenShortNames.computeIfAbsent(typeShortName, k -> type.mainType());
        if (type.isGeneric()) {
            String shortName = Objects.equals(type.mainType(), mainType) ? typeShortName : type.mainType();
            writer.append(shortName);
            writer.append("<");
            boolean first = true;
            for (UType param : type.componentTypes()) {
                if (first) {
                    first = false;
                    this.writeGenericType(param, seenShortNames, writer);
                    continue;
                }
                writer.append(", ");
                this.writeGenericType(param, seenShortNames, writer);
            }
            writer.append(">");
        } else {
            String shortName = Objects.equals(type.mainType(), mainType) ? typeShortName : type.mainType();
            writer.append(shortName);
        }
    }

    private void writeRequestCreate() {
        this.beanReader.writeRequestCreate(this.writer);
    }

    private boolean isRequestScopedController() {
        return this.beanReader.isRequestScopedController();
    }

    private void writeStaticFactoryBeanMethods() {
        for (MethodReader factoryMethod : this.beanReader.factoryMethods()) {
            this.writeFactoryBeanMethod(factoryMethod);
        }
    }

    private void writeFactoryBeanMethod(MethodReader method) {
        method.commentBuildMethod(this.writer);
        this.writer.append("  public static void build_%s(%s builder) {", method.name(), this.beanReader.builderType()).eol();
        method.buildConditional(this.writer);
        method.buildAddFor(this.writer);
        method.builderGetFactory(this.writer, this.beanReader.hasConditions());
        if (method.isLazy() || method.isProtoType() || method.isUseProviderForSecondary()) {
            method.builderAddBeanProvider(this.writer);
        } else {
            method.startTry(this.writer);
            method.builderBuildBean(this.writer);
            method.builderBuildAddBean(this.writer);
            method.endTry(this.writer);
            this.writer.append("    }").eol();
        }
        this.writer.append("  }").eol().eol();
    }

    private void writeStaticFactoryMethod() {
        MethodReader constructor = this.beanReader.constructor();
        if (constructor == null) {
            APContext.logError(this.beanReader.beanType(), "Unable to determine constructor to use for %s? Add explicit @Inject to one of the constructors.", this.beanReader.beanType());
            return;
        }
        this.writeBuildMethodStart();
        if (this.proxied) {
            this.writer.append("    // this bean is proxied, see %s$Proxy$DI instead", this.shortName).eol();
        } else {
            this.writeAddFor(constructor);
        }
        this.writer.append("  }").eol().eol();
    }

    private void writeAddFor(MethodReader constructor) {
        this.beanReader.buildConditional(this.writer);
        this.beanReader.buildAddFor(this.writer);
        if (this.beanReader.registerProvider()) {
            this.indent = this.indent + "  ";
            this.writer.append("      builder.%s(() -> {", this.beanReader.lazy() ? "registerProvider" : "asPrototype().registerProvider").eol();
        }
        constructor.startTry(this.writer);
        this.writeCreateBean(constructor);
        this.beanReader.buildRegister(this.writer);
        this.beanReader.addLifecycleCallbacks(this.writer, this.indent);
        if (this.beanReader.isExtraInjectionRequired()) {
            this.writeExtraInjection();
        }
        if (this.beanReader.registerProvider()) {
            this.beanReader.prototypePostConstruct(this.writer, this.indent);
            this.writer.indent("        return bean;").eol();
            this.writer.indent("      });").eol();
        }
        this.writeObserveMethods();
        constructor.endTry(this.writer);
        this.writer.append("    }").eol();
    }

    private void writeBuildMethodStart() {
        if (this.beanReader.registerProvider()) {
            this.writer.append(CODE_COMMENT_BUILD_PROVIDER, this.shortName).eol();
        } else {
            this.writer.append(CODE_COMMENT_BUILD, this.shortName).eol();
        }
        this.writer.append("  public static void build(%s builder) {", this.beanReader.builderType()).eol();
    }

    private void writeCreateBean(MethodReader constructor) {
        this.writer.indent(this.indent).append(" var bean = new %s(", this.shortName);
        this.writeMethodParams("builder", constructor);
    }

    private void writeExtraInjection() {
        if (!this.beanReader.registerProvider()) {
            this.writer.indent("      ").append("builder.addInjector(b -> {").eol();
            this.writer.indent("      ").append("  // field and method injection").eol();
        }
        this.injectFields();
        this.injectMethods();
        if (!this.beanReader.registerProvider()) {
            this.writer.indent("      });").eol();
        }
    }

    private void writeObserveMethods() {
        String bean = "bean";
        String builder = "builder";
        String indent = "      ";
        for (MethodReader methodReader : this.beanReader.observerMethods()) {
            String observeTypeString;
            MethodReader.MethodParam observeEvent = methodReader.observeParam();
            UType observeUtype = observeEvent.getFullUType();
            String shortWithoutAnnotations = observeUtype.shortWithoutAnnotations();
            List injectParams = methodReader.params().stream().skip(1L).collect(Collectors.toList());
            for (MethodReader.MethodParam param : injectParams) {
                this.writer.indent("      ").append("var %s = ", methodReader.name() + "$" + param.simpleName());
                param.builderGetDependency(this.writer, "builder");
                this.writer.append(";").eol();
            }
            this.writer.indent("      ").append("Consumer<%s> %s = ", shortWithoutAnnotations, methodReader.name());
            String string = observeTypeString = !observeUtype.isGeneric() || observeUtype.param0().kind() == TypeKind.WILDCARD ? Util.shortName(observeUtype.mainType()) + ".class" : "TYPE_" + Util.shortName(observeUtype).replace(".", "_");
            if (methodReader.params().size() == 1) {
                this.writer.append("%s::%s;", "bean", methodReader.name());
            } else {
                String injectParamNames = injectParams.stream().map(p -> methodReader.name() + "$" + p.simpleName()).collect(Collectors.joining(", "));
                this.writer.append("e -> bean.%s(e, %s);", methodReader.name(), injectParamNames);
            }
            ObservesPrism observesPrism = ObservesPrism.getInstanceOn(observeEvent.element());
            this.writer.eol().indent("      ").append("builder").eol().indent("      ").append("    .get(ObserverManager.class)").eol().indent("      ").append("    .<%s>registerObserver(", shortWithoutAnnotations).eol().indent("      ").append("        %s, new Observer<>(%s, %s, %s, \"%s\"));", observeTypeString, observesPrism.priority(), observesPrism.async(), methodReader.name(), observeEvent.qualifier()).eol();
        }
    }

    private void injectFields() {
        String bean = this.beanReader.registerProvider() ? "bean" : "$bean";
        String builder = this.beanReader.registerProvider() ? "builder" : "b";
        for (FieldReader fieldReader : this.beanReader.injectFields()) {
            String fieldName = fieldReader.fieldName();
            String getDependency = fieldReader.builderGetDependency(builder);
            this.writer.indent("        ").append("%s.%s = %s;", bean, fieldName, getDependency).eol();
        }
    }

    private void injectMethods() {
        String builder;
        boolean needsTry = this.beanReader.needsTryForMethodInjection();
        String bean = this.beanReader.registerProvider() ? "bean" : "$bean";
        String string = builder = this.beanReader.registerProvider() ? "builder" : "b";
        if (needsTry) {
            this.writer.indent("        try {").eol();
        }
        String indent = needsTry ? "          " : "        ";
        for (MethodReader methodReader : this.beanReader.injectMethods()) {
            this.writer.indent(indent).append("%s.%s(", bean, methodReader.name());
            this.writeMethodParams(builder, methodReader);
        }
        if (needsTry) {
            this.writer.indent("        } catch (Throwable e) {").eol();
            this.writer.indent("          throw new RuntimeException(\"Error wiring method\", e);").eol();
            this.writer.indent("        }").eol();
        }
    }

    private void writeMethodParams(String builderRef, MethodReader methodReader) {
        List<MethodReader.MethodParam> methodParams = methodReader.params();
        for (int i = 0; i < methodParams.size(); ++i) {
            if (i > 0) {
                this.writer.append(", ");
            }
            methodParams.get(i).builderGetDependency(this.writer, builderRef);
        }
        this.writer.append(");").eol();
    }

    private void writeImports() {
        this.beanReader.writeImports(this.writer, this.packageName);
    }

    private void writeClassEnd() {
        this.writer.append("}").eol();
    }

    private void writeClassStart() {
        boolean requestScopedController = this.beanReader.isRequestScopedController();
        if (requestScopedController) {
            this.writer.append(CODE_COMMENT_FACTORY, this.shortName).eol();
        } else {
            this.writer.append(CODE_COMMENT, this.shortName).eol();
        }
        this.writer.append(this.beanReader.generatedType()).append("(\"io.avaje.inject.generator\")").eol();
        if (requestScopedController) {
            this.writer.append("@Singleton").eol();
        }
        String shortName = this.shortName;
        if (this.beanReader.beanType().getNestingKind().isNested()) {
            shortName = shortName.replace(".", "$");
        }
        this.writer.append("public final %sclass ", requestScopedController ? "" : Util.valhalla()).append(shortName).append(this.suffix).append(" ");
        if (requestScopedController) {
            this.writer.append("implements ");
            this.beanReader.factoryInterface(this.writer);
        }
        this.writer.append(" {").eol().eol();
    }

    private void writePackage() {
        if (this.packageName != null) {
            this.writer.append("package %s;", this.packageName).eol().eol();
        }
    }
}

