/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.AnnotationUtil;
import io.avaje.inject.generator.AspectMethod;
import io.avaje.inject.generator.AspectPair;
import io.avaje.inject.generator.AspectPrism;
import io.avaje.inject.generator.AssistedPrism;
import io.avaje.inject.generator.BeanAspects;
import io.avaje.inject.generator.BeanPrism;
import io.avaje.inject.generator.FieldReader;
import io.avaje.inject.generator.ImportTypeMap;
import io.avaje.inject.generator.InjectPrism;
import io.avaje.inject.generator.MethodReader;
import io.avaje.inject.generator.ObservesPrism;
import io.avaje.inject.generator.PreDestroyPrism;
import io.avaje.inject.generator.ProcessingContext;
import io.avaje.inject.generator.UType;
import io.avaje.inject.generator.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

final class TypeExtendsInjection {
    private MethodReader injectConstructor;
    private final List<MethodReader> otherConstructors = new ArrayList<MethodReader>();
    private final List<MethodReader> factoryMethods = new ArrayList<MethodReader>();
    private final List<FieldReader> injectFields = new ArrayList<FieldReader>();
    private final Map<String, MethodReader> injectMethods = new LinkedHashMap<String, MethodReader>();
    private final Set<String> notInjectMethods = new HashSet<String>();
    private final List<AspectMethod> aspectMethods = new ArrayList<AspectMethod>();
    private final List<MethodReader> observerMethods = new ArrayList<MethodReader>();
    private final Map<String, Integer> nameIndex = new HashMap<String, Integer>();
    private final ImportTypeMap importTypes;
    private final TypeElement baseType;
    private final boolean factory;
    private final List<AspectPair> typeAspects;
    private Element postConstructMethod;
    private Element preDestroyMethod;
    private Integer preDestroyPriority;

    TypeExtendsInjection(TypeElement baseType, boolean factory, ImportTypeMap importTypes) {
        this.importTypes = importTypes;
        this.baseType = baseType;
        this.factory = factory;
        this.typeAspects = this.readAspects(baseType);
    }

    void read(TypeElement type) {
        for (Element element : type.getEnclosedElements()) {
            switch (element.getKind()) {
                case CONSTRUCTOR: {
                    this.readConstructor(element, type);
                    break;
                }
                case FIELD: {
                    this.readField(element);
                    break;
                }
                case METHOD: {
                    this.readMethod(element, type);
                    break;
                }
            }
        }
    }

    List<AspectPair> readAspects(Element element) {
        ArrayList<AspectPair> aspects = new ArrayList<AspectPair>();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            Element anElement = annotationMirror.getAnnotationType().asElement();
            AspectPrism aspect = AspectPrism.getInstanceOn(anElement);
            if (aspect != null) {
                aspects.add(new AspectPair(anElement, aspect.ordering()));
                continue;
            }
            ProcessingContext.getImportedAspect(anElement.asType().toString()).ifPresent(p -> aspects.add(new AspectPair(anElement, p.ordering())));
        }
        return aspects;
    }

    private void readField(Element element) {
        if (InjectPrism.isPresent(element) || AssistedPrism.isPresent(element)) {
            this.injectFields.add(new FieldReader(element));
        }
    }

    private void readConstructor(Element element, TypeElement type) {
        if (type != this.baseType) {
            return;
        }
        ExecutableElement ex = (ExecutableElement)element;
        MethodReader methodReader = new MethodReader(ex, this.baseType, this.importTypes).read();
        if (InjectPrism.isPresent(element)) {
            this.injectConstructor = methodReader;
        } else if (methodReader.isNotPrivate()) {
            this.otherConstructors.add(methodReader);
        }
    }

    private void readMethod(Element element, TypeElement type) {
        BeanPrism bean;
        boolean checkAspect = true;
        ExecutableElement methodElement = (ExecutableElement)element;
        if (this.factory && (bean = BeanPrism.getInstanceOn(element)) != null) {
            this.addFactoryMethod(methodElement, bean);
            checkAspect = false;
        }
        boolean inject = InjectPrism.isPresent(element);
        String methodKey = methodElement.getSimpleName().toString();
        if (methodElement.getParameters().stream().anyMatch(ObservesPrism::isPresent)) {
            MethodReader methodReader = new MethodReader(methodElement, type, this.importTypes).read();
            if (methodReader.isNotPrivate()) {
                this.observerMethods.add(methodReader);
            }
        } else if (inject && !this.notInjectMethods.contains(methodKey)) {
            MethodReader methodReader = new MethodReader(methodElement, type, this.importTypes).read();
            if (!this.injectMethods.containsKey(methodKey) && methodReader.isNotPrivate()) {
                this.injectMethods.put(methodKey, methodReader);
                checkAspect = false;
            }
        } else {
            this.notInjectMethods.add(methodKey);
        }
        if (AnnotationUtil.hasAnnotationWithName(element, "PostConstruct")) {
            this.postConstructMethod = element;
            checkAspect = false;
        }
        if (AnnotationUtil.hasAnnotationWithName(element, "PreDestroy")) {
            this.preDestroyMethod = element;
            checkAspect = false;
            PreDestroyPrism.getOptionalOn(element).ifPresent(preDestroy -> {
                this.preDestroyPriority = preDestroy.priority();
            });
        }
        if (checkAspect) {
            this.checkForAspect(methodElement);
        }
    }

    private int methodNameIndex(String name) {
        Integer counter = this.nameIndex.get(name);
        if (counter == null) {
            this.nameIndex.put(name, 1);
            return 0;
        }
        this.nameIndex.put(name, counter + 1);
        return counter;
    }

    private void checkForAspect(ExecutableElement methodElement) {
        Set<Modifier> modifiers = methodElement.getModifiers();
        if (modifiers.contains((Object)Modifier.PRIVATE) || modifiers.contains((Object)Modifier.STATIC) || modifiers.contains((Object)Modifier.ABSTRACT)) {
            return;
        }
        int methodNameIndex = this.methodNameIndex(methodElement.getSimpleName().toString());
        List<AspectPair> aspectPairs = this.readAspects(methodElement);
        aspectPairs.addAll(this.typeAspects);
        if (!aspectPairs.isEmpty()) {
            this.aspectMethods.add(new AspectMethod(methodNameIndex, aspectPairs, methodElement));
        }
    }

    private void addFactoryMethod(ExecutableElement methodElement, BeanPrism bean) {
        String qualifierName = Util.named(methodElement);
        this.factoryMethods.add(new MethodReader(methodElement, this.baseType, bean, qualifierName, this.importTypes).read());
    }

    BeanAspects hasAspects() {
        return this.aspectMethods.isEmpty() ? BeanAspects.EMPTY : new BeanAspects(this.aspectMethods);
    }

    void removeFromProvides(List<UType> provides) {
        MethodReader constructor = this.constructor();
        if (constructor != null) {
            constructor.removeFromProvides(provides);
        }
        for (FieldReader injectField : this.injectFields) {
            injectField.removeFromProvides(provides);
        }
        for (MethodReader injectMethod : this.injectMethods.values()) {
            injectMethod.removeFromProvides(provides);
        }
    }

    List<FieldReader> injectFields() {
        ArrayList<FieldReader> list = new ArrayList<FieldReader>(this.injectFields);
        Collections.reverse(list);
        return list;
    }

    List<MethodReader> injectMethods() {
        ArrayList<MethodReader> list = new ArrayList<MethodReader>(this.injectMethods.values());
        Collections.reverse(list);
        return list;
    }

    List<MethodReader> factoryMethods() {
        return this.factoryMethods;
    }

    List<MethodReader> observerMethods() {
        return this.observerMethods;
    }

    Element postConstructMethod() {
        return this.postConstructMethod;
    }

    Element preDestroyMethod() {
        return this.preDestroyMethod;
    }

    Integer preDestroyPriority() {
        return this.preDestroyPriority;
    }

    MethodReader constructor() {
        if (this.injectConstructor != null) {
            return this.injectConstructor;
        }
        if (this.otherConstructors.size() == 1) {
            return this.otherConstructors.get(0);
        }
        ArrayList<MethodReader> allPublic = new ArrayList<MethodReader>();
        for (MethodReader ctor : this.otherConstructors) {
            if (!ctor.isPublic()) continue;
            allPublic.add(ctor);
        }
        if (allPublic.size() == 1) {
            return (MethodReader)allPublic.get(0);
        }
        return null;
    }
}

