/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.APContext;
import io.avaje.inject.generator.AnnotationCopier;
import io.avaje.inject.generator.NamedPrism;
import io.avaje.inject.generator.ProcessorUtils;
import io.avaje.inject.generator.QualifierPrism;
import io.avaje.inject.generator.UType;
import io.avaje.inject.generator.UtilType;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

final class Util {
    static final String ASPECT_PROVIDER_PREFIX = "io.avaje.inject.aop.AspectProvider<";
    static final String PROVIDER_PREFIX = "javax.inject.Provider";
    private static final String OPTIONAL_PREFIX = "java.util.Optional<";
    private static final String NULLABLE = "Nullable";
    private static final int PROVIDER_LENGTH = "javax.inject.Provider".length() + 1;
    private static final int ASPECT_PROVIDER_LENGTH = "io.avaje.inject.aop.AspectProvider<".length();
    private static final Pattern ANNOTATION_TYPE_PATTERN = Pattern.compile("@([\\w.]+)\\.");

    Util() {
    }

    static boolean notJavaLang(String type) {
        return !type.startsWith("java.lang.") || Character.isLowerCase(type.charAt(10));
    }

    static boolean isVoid(String type) {
        return "void".equalsIgnoreCase(type);
    }

    static boolean validImportType(String type, String packageName) {
        return type.indexOf(46) > -1 && !type.startsWith("java.lang.") && Util.importDifferentPackage(type, packageName) || Util.importJavaLangSubpackage(type);
    }

    private static boolean importDifferentPackage(String type, String packageName) {
        return type.replace(packageName + ".", "").indexOf(46) > -1;
    }

    private static boolean importJavaLangSubpackage(String type) {
        return type.startsWith("java.lang.") && Util.importDifferentPackage(type, "java.lang");
    }

    static String classOfMethod(String method) {
        int pos = method.lastIndexOf(46);
        return pos == -1 ? "" : method.substring(0, pos);
    }

    static String shortMethod(String method) {
        int p = (method = Util.trimGenerics(method)).lastIndexOf(46);
        if (p > -1 && (p = method.lastIndexOf(46, p - 1)) > -1) {
            return method.substring(p + 1);
        }
        return method;
    }

    static String trimGenerics(String type) {
        int i = type.indexOf(60);
        if (i == -1) {
            return type;
        }
        return type.substring(0, i);
    }

    public static String sanitizeImports(String type) {
        int pos = type.indexOf("@");
        if (pos == -1) {
            return Util.trimArrayBrackets(type);
        }
        String start = pos == 0 ? type.substring(0, pos) : "";
        return start + Util.trimArrayBrackets(type.substring(type.lastIndexOf(32) + 1));
    }

    private static String trimArrayBrackets(String type) {
        return type.replaceAll("[^\\n\\r\\t $;\\w.]", "");
    }

    static String nestedPackageOf(String cls) {
        int pos = cls.lastIndexOf(46);
        if (pos < 0) {
            return "";
        }
        return (pos = cls.lastIndexOf(46, pos - 1)) == -1 ? "" : cls.substring(0, pos);
    }

    static String unwrapProvider(String maybeProvider) {
        if (Util.isProvider(maybeProvider)) {
            return Util.extractProviderType(maybeProvider);
        }
        return maybeProvider;
    }

    static UType unwrapProvider(TypeMirror maybeProvider) {
        if (Util.isProvider(maybeProvider.toString())) {
            return UType.parse(maybeProvider).param0();
        }
        return UType.parse(maybeProvider);
    }

    static UType unwrapProvider(UType maybeProvider) {
        if (Util.isProvider(maybeProvider.mainType())) {
            return maybeProvider.param0();
        }
        return maybeProvider;
    }

    static String initLower(String name) {
        StringBuilder sb = new StringBuilder(name.length());
        boolean upper = true;
        for (char ch : name.toCharArray()) {
            if (upper && Character.isUpperCase(ch)) {
                sb.append(Character.toLowerCase(ch));
                continue;
            }
            upper = false;
            sb.append(ch);
        }
        return sb.toString();
    }

    static String shortName(String fullType) {
        int p = fullType.lastIndexOf(46);
        if (p == -1) {
            return fullType;
        }
        if (fullType.startsWith("java")) {
            return fullType.substring(p + 1);
        }
        Object result = "";
        boolean foundClass = false;
        for (String part : fullType.split("\\.")) {
            char firstChar = part.charAt(0);
            if (!foundClass && !Character.isUpperCase(firstChar) && (Character.isAlphabetic(firstChar) || !Character.isJavaIdentifierStart(firstChar))) continue;
            foundClass = true;
            result = (String)result + (((String)result).isEmpty() ? "" : ".") + part;
        }
        if (((String)result).isBlank()) {
            return fullType.substring(p + 1);
        }
        return result;
    }

    static String shortName(UType uType) {
        StringBuilder sb = new StringBuilder();
        Util.shortName(uType, sb);
        return sb.toString();
    }

    static void shortName(UType uType, StringBuilder sb) {
        String type = Util.trimWildcard(uType.mainType());
        if (type != null && type.startsWith("? extends ")) {
            type = type.substring(10);
        } else if ("?".equals(type)) {
            type = "Wildcard";
        } else if (!type.contains(".")) {
            return;
        }
        sb.append(Util.shortName(type));
        List<UType> componentTypes = uType.componentTypes();
        if (componentTypes.size() != 1 || componentTypes.get(0).kind() != TypeKind.WILDCARD) {
            for (UType param : componentTypes) {
                Util.shortName(param, sb);
            }
        }
    }

    static String trimmedName(UType type) {
        return Util.shortName(type.mainType()).toLowerCase();
    }

    static boolean isOptional(String rawType) {
        return rawType.startsWith(OPTIONAL_PREFIX);
    }

    static String extractOptionalType(String rawType) {
        return rawType.substring(19, rawType.length() - 1);
    }

    static String extractList(String rawType) {
        String listType = rawType.substring(15, rawType.length() - 1);
        if (listType.startsWith("? extends")) {
            return listType.substring(10);
        }
        return listType;
    }

    static String extractSet(String rawType) {
        String setType = rawType.substring(14, rawType.length() - 1);
        if (setType.startsWith("? extends")) {
            return setType.substring(10);
        }
        return setType;
    }

    static String extractMap(String rawType) {
        String valType = rawType.substring(31, rawType.length() - 1);
        if (valType.startsWith("? extends")) {
            return valType.substring(10);
        }
        return valType;
    }

    static UtilType determineType(TypeMirror rawType, boolean beanMap) {
        return UtilType.of(rawType.toString(), beanMap, rawType);
    }

    static String trimWildcard(String rawType) {
        if (rawType.endsWith("<?>")) {
            return rawType.substring(0, rawType.length() - 3);
        }
        return Util.trimGenericParams(rawType);
    }

    static String trimGenericParams(String rawType) {
        int start = rawType.indexOf(60);
        if (start > 0 && rawType.indexOf(46, start) == -1 && rawType.lastIndexOf(62) > -1) {
            return rawType.substring(0, start);
        }
        return rawType;
    }

    static boolean isAspectProvider(String rawType) {
        return rawType.startsWith(ASPECT_PROVIDER_PREFIX);
    }

    static boolean isProvider(String rawType) {
        return rawType.startsWith(PROVIDER_PREFIX);
    }

    private static String extractProviderType(String rawType) {
        return rawType.substring(PROVIDER_LENGTH, rawType.length() - 1);
    }

    static String extractAspectType(String rawType) {
        return rawType.substring(ASPECT_PROVIDER_LENGTH, rawType.length() - 1);
    }

    static String wrapAspect(String aspect) {
        return ASPECT_PROVIDER_PREFIX + aspect + ">";
    }

    static String commonParent(String currentTop, String aPackage) {
        int next;
        if (aPackage == null) {
            return currentTop;
        }
        if (currentTop == null) {
            return aPackage;
        }
        if (aPackage.startsWith(currentTop)) {
            return currentTop;
        }
        do {
            if ((next = currentTop.lastIndexOf(46)) <= -1 || !aPackage.startsWith(currentTop = currentTop.substring(0, next))) continue;
            return currentTop;
        } while (next > -1);
        return currentTop;
    }

    static String named(Element p) {
        NamedPrism named = NamedPrism.getInstanceOn(p);
        if (named != null) {
            return named.value().replace("\"", "\\\"");
        }
        for (AnnotationMirror annotationMirror : p.getAnnotationMirrors()) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            boolean hasQualifier = QualifierPrism.isPresent(annotationType.asElement());
            if (!hasQualifier) continue;
            String shortName = Util.shortName(annotationType.toString());
            return AnnotationCopier.toSimpleAnnotationString(annotationMirror).replaceFirst(annotationType.toString(), shortName).replace("\"", "\\\"");
        }
        return null;
    }

    static boolean isNullable(Element element) {
        if (ProcessorUtils.hasAnnotationWithName(element, NULLABLE)) {
            return true;
        }
        for (AnnotationMirror mirror : UType.parse(element.asType()).annotations()) {
            if (!NULLABLE.equals(Util.shortName(mirror.getAnnotationType().toString()))) continue;
            return true;
        }
        return false;
    }

    static Optional<DeclaredType> nullableAnnotation(Element element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!NULLABLE.equals(Util.shortName(annotationMirror.getAnnotationType().toString()))) continue;
            return Optional.of(annotationMirror.getAnnotationType());
        }
        return Optional.empty();
    }

    static String addForInterface(String interfaceType) {
        if (interfaceType.contains("<")) {
            return null;
        }
        return Util.shortName(interfaceType);
    }

    static String trimMethod(String method) {
        return Util.shortMethod(method).replace('.', '_').replace("$DI", "");
    }

    static String trimAnnotationString(String input) {
        return ANNOTATION_TYPE_PATTERN.matcher(input).replaceAll("@");
    }

    static String addQualifierSuffixTrim(String named, String type) {
        return Util.addQualifierSuffix(named, type).replace(", ", ",");
    }

    static String addQualifierSuffix(String named, String type) {
        return type + Optional.ofNullable(named).filter(Predicate.not(String::isBlank)).map(s -> ":" + s).orElse("");
    }

    static List<String> addQualifierSuffix(List<String> provides, String name) {
        return Stream.concat(provides.stream().map(s -> Util.addQualifierSuffix(name, s)), provides.stream()).distinct().collect(Collectors.toList());
    }

    static String valhalla() {
        try {
            if (Modifier.valueOf("VALUE") != null && APContext.previewEnabled()) {
                return "value ";
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return "";
    }
}

