package io.avaje.inject.generator;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Map;
import javax.annotation.processing.Generated;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.type.TypeMirror;
import java.util.HashMap;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

/** A Prism representing a {@link io.avaje.inject.InjectModule @InjectModule} annotation. */ 
@Generated("avaje-prism-generator")
final class InjectModulePrism {
  /** store prism value of strictWiring */
  private final Boolean _strictWiring;

  /** store prism value of name */
  private final String _name;

  /** store prism value of ignoreSingleton */
  private final Boolean _ignoreSingleton;

  /** store prism value of provides */
  private final List<TypeMirror> _provides;

  /** store prism value of requires */
  private final List<TypeMirror> _requires;

  /** store prism value of requiresPackages */
  private final List<TypeMirror> _requiresPackages;

  /** store prism value of customScopeType */
  private final String _customScopeType;

  public static final String PRISM_TYPE = "io.avaje.inject.InjectModule";

  /**
   * An instance of the Values inner class whose
   * methods return the AnnotationValues used to build this prism. 
   * Primarily intended to support using Messager.
   */
  final Values values;

  /** Returns true if the mirror is an instance of {@link io.avaje.inject.InjectModule @InjectModule} is present on the element, else false.
   *
   * @param mirror mirror. 
   * @return true if prism is present. 
   */
  static boolean isInstance(AnnotationMirror mirror) {
    return getInstance(mirror) != null;
  }

  /** Returns true if {@link io.avaje.inject.InjectModule @InjectModule} is present on the element, else false.
   *
   * @param element element. 
   * @return true if annotation is present on the element. 
   */
  static boolean isPresent(Element element) {
    return getInstanceOn(element) != null;
  }

  /** Return a prism representing the {@link io.avaje.inject.InjectModule @InjectModule} annotation present on the given element. 
   * similar to {@code element.getAnnotation(InjectModule.class)} except that 
   * an instance of this class rather than an instance of {@link io.avaje.inject.InjectModule @InjectModule}
   * is returned.
   *
   * @param element element. 
   * @return prism on element or null if no annotation is found. 
   */
  static InjectModulePrism getInstanceOn(Element element) {
    final var mirror = getMirror(element);
    if (mirror == null) return null;
    return getInstance(mirror);
  }

  /** Return a Optional representing a nullable {@link io.avaje.inject.InjectModule @InjectModule} annotation on the given element. 
   * similar to {@code element.getAnnotation(io.avaje.inject.InjectModule.class)} except that 
   * an Optional of this class rather than an instance of {@link io.avaje.inject.InjectModule}
   * is returned.
   *
   * @param element element. 
   * @return prism optional for element. 
   */
  static Optional<InjectModulePrism> getOptionalOn(Element element) {
    final var mirror = getMirror(element);
    if (mirror == null) return Optional.empty();
    return getOptional(mirror);
  }

  /** Return a prism of the {@link io.avaje.inject.InjectModule @InjectModule} annotation from an annotation mirror. 
   *
   * @param mirror mirror. 
   * @return prism for mirror or null if mirror is an incorrect type. 
   */
  static InjectModulePrism getInstance(AnnotationMirror mirror) {
    if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) return null;

    return new InjectModulePrism(mirror);
  }

  /** Return an Optional representing a nullable {@link InjectModulePrism @InjectModulePrism} from an annotation mirror. 
   * similar to {@code e.getAnnotation(io.avaje.inject.InjectModule.class)} except that 
   * an Optional of this class rather than an instance of {@link io.avaje.inject.InjectModule @InjectModule}
   * is returned.
   *
   * @param mirror mirror. 
   * @return prism optional for mirror. 
   */
  static Optional<InjectModulePrism> getOptional(AnnotationMirror mirror) {
    if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) return Optional.empty();

    return Optional.of(new InjectModulePrism(mirror));
  }

  private InjectModulePrism(AnnotationMirror mirror) {
    for (final ExecutableElement key : mirror.getElementValues().keySet()) {
      memberValues.put(key.getSimpleName().toString(), mirror.getElementValues().get(key));
    }
    for (final ExecutableElement member : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
      defaults.put(member.getSimpleName().toString(), member.getDefaultValue());
    }
    _strictWiring = getValue("strictWiring", Boolean.class);
    _name = getValue("name", String.class);
    _ignoreSingleton = getValue("ignoreSingleton", Boolean.class);
    _provides = getArrayValues("provides", TypeMirror.class);
    _requires = getArrayValues("requires", TypeMirror.class);
    _requiresPackages = getArrayValues("requiresPackages", TypeMirror.class);
    _customScopeType = getValue("customScopeType", String.class);
    this.values = new Values(memberValues);
    this.mirror = mirror;
    this.isValid = valid;
  }

  /** 
   * Returns a Boolean representing the value of the {@code boolean strictWiring()} member of the Annotation.
   * @see io.avaje.inject.InjectModule#strictWiring()
   */ 
  public Boolean strictWiring() { return _strictWiring; }

  /** 
   * Returns a String representing the value of the {@code java.lang.String name()} member of the Annotation.
   * @see io.avaje.inject.InjectModule#name()
   */ 
  public String name() { return _name; }

  /** 
   * Returns a Boolean representing the value of the {@code boolean ignoreSingleton()} member of the Annotation.
   * @see io.avaje.inject.InjectModule#ignoreSingleton()
   */ 
  public Boolean ignoreSingleton() { return _ignoreSingleton; }

  /** 
   * Returns a List&lt;TypeMirror&gt; representing the value of the {@code provides()} member of the Annotation.
   * @see io.avaje.inject.InjectModule#provides()
   */ 
  public List<TypeMirror> provides() { return _provides; }

  /** 
   * Returns a List&lt;TypeMirror&gt; representing the value of the {@code requires()} member of the Annotation.
   * @see io.avaje.inject.InjectModule#requires()
   */ 
  public List<TypeMirror> requires() { return _requires; }

  /** 
   * Returns a List&lt;TypeMirror&gt; representing the value of the {@code requiresPackages()} member of the Annotation.
   * @see io.avaje.inject.InjectModule#requiresPackages()
   */ 
  public List<TypeMirror> requiresPackages() { return _requiresPackages; }

  /** 
   * Returns a String representing the value of the {@code java.lang.String customScopeType()} member of the Annotation.
   * @see io.avaje.inject.InjectModule#customScopeType()
   */ 
  public String customScopeType() { return _customScopeType; }

  /**
   * Determine whether the underlying AnnotationMirror has no errors.
   * True if the underlying AnnotationMirror has no errors.
   * When true is returned, none of the methods will return null.
   * When false is returned, a least one member will either return null, or another
   * prism that is not valid.
   */
   final boolean isValid;
    
  /**
   * The underlying AnnotationMirror of the annotation
   * represented by this Prism. 
   * Primarily intended to support using Messager.
   */
   final AnnotationMirror mirror;
  /**
   * A class whose members correspond to those of {@link io.avaje.inject.InjectModule @InjectModule} 
   * but which each return the AnnotationValue corresponding to
   * that member in the model of the annotations. Returns null for
   * defaulted members. Used for Messager, so default values are not useful.
   */
  static final class Values {
    private final Map<String, AnnotationValue> values;

    private Values(Map<String, AnnotationValue> values) {
      this.values = values;
    }    
    /** Return the AnnotationValue corresponding to the strictWiring() 
     * member of the annotation, or null when the default value is implied.
     */
    AnnotationValue strictWiring(){ return values.get("strictWiring");}
    /** Return the AnnotationValue corresponding to the name() 
     * member of the annotation, or null when the default value is implied.
     */
    AnnotationValue name(){ return values.get("name");}
    /** Return the AnnotationValue corresponding to the ignoreSingleton() 
     * member of the annotation, or null when the default value is implied.
     */
    AnnotationValue ignoreSingleton(){ return values.get("ignoreSingleton");}
    /** Return the AnnotationValue corresponding to the provides() 
     * member of the annotation, or null when the default value is implied.
     */
    AnnotationValue provides(){ return values.get("provides");}
    /** Return the AnnotationValue corresponding to the requires() 
     * member of the annotation, or null when the default value is implied.
     */
    AnnotationValue requires(){ return values.get("requires");}
    /** Return the AnnotationValue corresponding to the requiresPackages() 
     * member of the annotation, or null when the default value is implied.
     */
    AnnotationValue requiresPackages(){ return values.get("requiresPackages");}
    /** Return the AnnotationValue corresponding to the customScopeType() 
     * member of the annotation, or null when the default value is implied.
     */
    AnnotationValue customScopeType(){ return values.get("customScopeType");}
  }

  private final Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
  private final Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
  private boolean valid = true;

  private <T> T getValue(String name, Class<T> clazz) {
    final T result = InjectModulePrism.getValue(memberValues, defaults, name, clazz);
    if (result == null) valid = false;
    return result;
  }

  private <T> List<T> getArrayValues(String name, final Class<T> clazz) {
    final List<T> result = InjectModulePrism.getArrayValues(memberValues, defaults, name, clazz);
    if (result == null) valid = false;
    return result;
  }
  private static AnnotationMirror getMirror(Element target) {
    for (final var m : target.getAnnotationMirrors()) {
      final CharSequence mfqn = ((TypeElement) m.getAnnotationType().asElement()).getQualifiedName();
      if (PRISM_TYPE.contentEquals(mfqn)) return m;
    }
    return null;
  }

  private static <T> T getValue(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
    AnnotationValue av = memberValues.get(name);
    if (av == null) av = defaults.get(name);
    if (av == null) {
      return null;
    }
    if (clazz.isInstance(av.getValue())) return clazz.cast(av.getValue());
    return null;
  }

  private static <T> List<T> getArrayValues(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, final Class<T> clazz) {
    AnnotationValue av = memberValues.get(name);
    if (av == null) av = defaults.get(name);
    if (av == null) {
      return List.of();
    }
    if (av.getValue() instanceof List) {
      final List<T> result = new ArrayList<>();
      for (final var v : getValueAsList(av)) {
        if (clazz.isInstance(v.getValue())) {
          result.add(clazz.cast(v.getValue()));
        } else {
          return List.of();
        }
      }
      return result;
    } else {
      return List.of();
    }
  }

  @SuppressWarnings("unchecked")
  private static List<AnnotationValue> getValueAsList(AnnotationValue av) {
    return (List<AnnotationValue>) av.getValue();
  }
}
