/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.APContext;
import io.avaje.inject.generator.Append;
import io.avaje.inject.generator.AssistFactoryPrism;
import io.avaje.inject.generator.BeanRequestParams;
import io.avaje.inject.generator.FieldReader;
import io.avaje.inject.generator.ImportTypeMap;
import io.avaje.inject.generator.MethodReader;
import io.avaje.inject.generator.ProcessorUtils;
import io.avaje.inject.generator.TypeReader;
import io.avaje.inject.generator.UType;
import io.avaje.inject.generator.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;

final class AssistBeanReader {
    private final TypeElement beanType;
    private final String type;
    private final MethodReader constructor;
    private final List<FieldReader> injectFields;
    private final List<MethodReader> injectMethods;
    private final List<Element> assistedElements = new ArrayList<Element>();
    private final ImportTypeMap importTypes = new ImportTypeMap();
    private final BeanRequestParams requestParams;
    private final TypeReader typeReader;
    private final TypeElement targetType;
    private final String qualifierName;
    private final ExecutableElement factoryMethod;

    AssistBeanReader(TypeElement beanType) {
        this.beanType = beanType;
        this.type = beanType.getQualifiedName().toString();
        this.typeReader = new TypeReader(Optional.empty(), UType.parse(beanType.asType()), beanType, this.importTypes, false);
        this.typeReader.process();
        this.qualifierName = this.typeReader.name();
        this.requestParams = new BeanRequestParams(this.type);
        this.injectMethods = this.typeReader.injectMethods();
        this.injectFields = this.typeReader.injectFields();
        this.constructor = this.typeReader.constructor();
        AssistFactoryPrism instanceOn = AssistFactoryPrism.getInstanceOn(beanType);
        TypeElement factoryType = APContext.asTypeElement(instanceOn.value());
        this.constructor.params().stream().filter(MethodReader.MethodParam::assisted).map(MethodReader.MethodParam::element).forEach(this.assistedElements::add);
        this.injectFields.stream().filter(FieldReader::assisted).map(FieldReader::element).forEach(this.assistedElements::add);
        this.injectMethods.stream().map(MethodReader::params).flatMap(Collection::stream).filter(MethodReader.MethodParam::assisted).map(MethodReader.MethodParam::element).forEach(this.assistedElements::add);
        this.factoryMethod = ElementFilter.methodsIn(factoryType.getEnclosedElements()).stream().filter(e -> e.getModifiers().contains((Object)Modifier.ABSTRACT)).findFirst().orElse(null);
        this.validateTarget(factoryType);
        this.targetType = factoryType;
    }

    private void validateTarget(TypeElement t) {
        List<ExecutableElement> methods = ElementFilter.methodsIn(t.getEnclosedElements());
        if (!APContext.elements().isFunctionalInterface(t)) {
            if (!t.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                APContext.logError(this.type, "@AssistFactory targets must be abstract");
            } else if (AssistBeanReader.checkAbstractMethodCount(methods)) {
                APContext.logError(this.type, "@AssistFactory targets must have only one abstract method");
            }
        }
        StringBuilder sb = new StringBuilder(String.format("@AssistFactory targets for type %s must have an abstract method with form '%s <methodName>(", this.shortName(), this.shortName()));
        ArrayList<String> assistNames = new ArrayList<String>();
        Iterator<Element> iterator = this.assistedElements.iterator();
        while (iterator.hasNext()) {
            Element element = iterator.next();
            UType typeName = UType.parse(element.asType());
            sb.append(String.format("%s %s", typeName.shortWithoutAnnotations(), element.getSimpleName()));
            if (iterator.hasNext()) {
                sb.append(", ");
            }
            assistNames.add(String.format("%s %s", typeName.shortWithoutAnnotations(), element.getSimpleName()));
        }
        String errorMsg = sb.append(")' method.").toString();
        Optional.ofNullable(this.factoryMethod).stream().map(ExecutableElement::getParameters).findAny().ifPresentOrElse(params -> {
            boolean mismatched;
            boolean bl = mismatched = params.size() != this.assistedElements.size();
            if (mismatched) {
                APContext.logError(t, errorMsg, new Object[0]);
                return;
            }
            Set paramTypes = params.stream().map(v -> String.format("%s %s", UType.parse(v.asType()).shortWithoutAnnotations(), v.getSimpleName())).collect(Collectors.toSet());
            String missingParams = assistNames.stream().filter(Predicate.not(paramTypes::contains)).collect(Collectors.joining(", "));
            if (!missingParams.isBlank()) {
                APContext.logError(this.factoryMethod, "factory method missing required parameters: %s", missingParams);
            }
        }, () -> APContext.logError(t, errorMsg, new Object[0]));
    }

    private static boolean checkAbstractMethodCount(List<ExecutableElement> methods) {
        return methods.stream().filter(e -> e.getModifiers().contains((Object)Modifier.ABSTRACT)).count() != 1L;
    }

    public String toString() {
        return this.beanType.toString();
    }

    TypeElement beanType() {
        return this.beanType;
    }

    boolean isExtraInjectionRequired() {
        return !this.injectFields.isEmpty() || !this.injectMethods.isEmpty();
    }

    void buildRegister(Append writer) {
        if (!this.isExtraInjectionRequired()) {
            writer.indent("    return bean;");
        }
    }

    private Set<String> importTypes() {
        Optional.ofNullable(this.targetType).ifPresent(t -> this.importTypes.add(t.getQualifiedName().toString()));
        if (this.qualifierName != null) {
            this.importTypes.add("jakarta.inject.Named");
        }
        this.typeReader.extraImports(this.importTypes);
        this.requestParams.addImports(this.importTypes);
        this.importTypes.add("io.avaje.inject.spi.Generated");
        this.constructor.addImports(this.importTypes);
        this.injectFields.forEach(r -> r.addImports(this.importTypes));
        this.injectMethods.forEach(r -> r.addImports(this.importTypes));
        return this.importTypes.forImport();
    }

    void writeImports(Append writer, String pkgName) {
        this.importTypes.add("io.avaje.inject.Component");
        if (!this.injectFields().isEmpty()) {
            this.importTypes.add("java.lang.reflect.Type");
        }
        for (String importType : this.importTypes()) {
            if (!Util.validImportType(importType, pkgName)) continue;
            writer.append("import %s;", Util.sanitizeImports(importType)).eol();
        }
        writer.eol();
    }

    MethodReader constructor() {
        return this.constructor;
    }

    List<FieldReader> injectFields() {
        return this.typeReader.injectFields();
    }

    List<MethodReader> injectMethods() {
        return this.typeReader.injectMethods();
    }

    String shortName() {
        return Util.shortName(this.beanQualifiedName());
    }

    String packageName() {
        return this.beanPackageName();
    }

    private String beanPackageName() {
        if (this.beanType.getNestingKind().isNested()) {
            return Util.nestedPackageOf(this.beanQualifiedName());
        }
        return ProcessorUtils.packageOf(this.beanQualifiedName());
    }

    private String beanQualifiedName() {
        return this.beanType.getQualifiedName().toString();
    }

    boolean needsTryForMethodInjection() {
        for (MethodReader injectMethod : this.injectMethods) {
            if (!injectMethod.methodThrows()) continue;
            return true;
        }
        return false;
    }

    List<Element> assistElements() {
        return this.assistedElements;
    }

    TypeElement targetInterface() {
        return this.targetType;
    }

    String qualifierName() {
        return this.qualifierName;
    }

    String factoryMethodName() {
        return this.factoryMethod != null ? this.factoryMethod.getSimpleName().toString() : "create";
    }

    boolean hasTargetFactory() {
        return this.factoryMethod != null;
    }

    List<? extends VariableElement> factoryMethodParams() {
        return this.factoryMethod.getParameters();
    }
}

