/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.APContext;
import io.avaje.inject.generator.DependencyMetaPrism;
import io.avaje.inject.generator.LoadServices;
import io.avaje.inject.generator.MetaData;
import io.avaje.inject.generator.ModuleData;
import io.avaje.inject.generator.ProcessingContext;
import io.avaje.inject.generator.ScopeInfo;
import io.avaje.inject.generator.Util;
import io.avaje.inject.spi.AvajeModule;
import io.avaje.inject.spi.InjectPlugin;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

final class ExternalProvider {
    private static final ClassLoader CLASS_LOADER = ExternalProvider.class.getClassLoader();
    private static final boolean INJECT_AVAILABLE = ExternalProvider.moduleCP();
    private static final Map<String, List<String>> avajePlugins = Map.ofEntries(Map.entry("io.avaje.inject.events.spi.ObserverManagerPlugin", List.of("io.avaje.inject.events.ObserverManager")), Map.entry("io.avaje.jsonb.inject.DefaultJsonbProvider", List.of("io.avaje.jsonb.Jsonb")), Map.entry("io.avaje.http.inject.DefaultResolverProvider", List.of("io.avaje.http.api.context.RequestContextResolver")), Map.entry("io.avaje.htmx.nima.jstache.DefaultTemplateProvider", List.of("io.avaje.htmx.nima.TemplateContentCache", "io.avaje.htmx.nima.TemplateRender")), Map.entry("io.avaje.nima.provider.DefaultConfigProvider", List.of("io.helidon.webserver.WebServerConfig.Builder", "io.helidon.webserver.http.HttpRouting.Builder")), Map.entry("io.avaje.validation.inject.spi.DefaultValidatorProvider", List.of("io.avaje.validation.Validator", "io.avaje.inject.aop.AspectProvider<io.avaje.validation.ValidMethod>")), Map.entry("io.avaje.validation.http.HttpValidatorProvider", List.of("io.avaje.http.api.Validator")));
    private static final List<MetaData> externalMeta = new ArrayList<MetaData>();

    private ExternalProvider() {
    }

    private static boolean moduleCP() {
        try {
            Class.forName("io.avaje.inject.spi.AvajeModule");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static void registerModuleProvidedTypes(Set<String> providedTypes) {
        if (!INJECT_AVAILABLE) {
            if (!ExternalProvider.pluginExists("avaje-module-dependencies.csv")) {
                APContext.logNote("Unable to detect Avaje Inject in Annotation Processor ClassPath, use the Avaje Inject Maven/Gradle plugin for detecting Inject Modules from dependencies", new Object[0]);
            }
            return;
        }
        List<AvajeModule> modules = LoadServices.loadModules(CLASS_LOADER);
        if (modules.isEmpty()) {
            APContext.logNote("No external modules detected", new Object[0]);
            return;
        }
        for (AvajeModule module : modules) {
            String name = module.getClass().getTypeName();
            APContext.logNote("Detected Module: " + name, new Object[0]);
            TreeSet<String> provides = new TreeSet<String>();
            for (Type type : module.provides()) {
                provides.add(type.getTypeName());
            }
            for (Type type : module.autoProvides()) {
                provides.add(type.getTypeName());
            }
            for (Type type : module.autoProvidesAspects()) {
                String aspectType = Util.wrapAspect(((Class)type).getTypeName());
                provides.add(aspectType);
            }
            ExternalProvider.registerExternalMetaData(name);
            ExternalProvider.readMetaDataProvides(provides);
            providedTypes.addAll(provides);
            List<String> requires = Arrays.stream(module.requires()).map(Type::getTypeName).collect(Collectors.toList());
            Arrays.stream(module.autoRequires()).map(Type::getTypeName).forEach(requires::add);
            Arrays.stream(module.requiresPackages()).map(Type::getTypeName).forEach(requires::add);
            Arrays.stream(module.autoRequiresAspects()).map(Type::getTypeName).map(Util::wrapAspect).forEach(requires::add);
            ProcessingContext.addModule(new ModuleData(name, new ArrayList<String>(provides), requires));
        }
    }

    static void registerPluginProvidedTypes(ScopeInfo defaultScope) {
        avajePlugins.forEach((k, v) -> {
            if (APContext.typeElement(k) != null) {
                APContext.logNote("Loaded Plugin: " + k, new Object[0]);
                v.forEach(defaultScope::pluginProvided);
            }
        });
        defaultScope.pluginProvided("io.avaje.inject.event.ObserverManager");
        if (!INJECT_AVAILABLE) {
            return;
        }
        List<InjectPlugin> plugins = LoadServices.loadPlugins(CLASS_LOADER);
        for (InjectPlugin plugin : plugins) {
            String name = plugin.getClass().getTypeName();
            if (avajePlugins.containsKey(name)) continue;
            APContext.logNote("Loaded Plugin: " + plugin.getClass().getTypeName(), new Object[0]);
            for (Type type : plugin.provides()) {
                defaultScope.pluginProvided(type.getTypeName());
            }
            for (Type type : plugin.providesAspects()) {
                defaultScope.pluginProvided(Util.wrapAspect(((Class)type).getTypeName()));
            }
        }
    }

    private static boolean pluginExists(String relativeName) {
        try {
            return APContext.getBuildResource(relativeName).toFile().exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    static void registerExternalMetaData(String name) {
        Optional.ofNullable(APContext.typeElement(name)).map(TypeElement::getEnclosedElements).map(ElementFilter::methodsIn).stream().flatMap(Collection::stream).map(DependencyMetaPrism::getInstanceOn).filter(Objects::nonNull).map(MetaData::new).forEach(externalMeta::add);
    }

    static void readMetaDataProvides(Collection<String> providedTypes) {
        externalMeta.forEach(meta -> {
            providedTypes.add(meta.key());
            providedTypes.add(meta.type());
            providedTypes.addAll(Util.addQualifierSuffix(meta.provides(), meta.name()));
            providedTypes.addAll(Util.addQualifierSuffix(meta.autoProvides(), meta.name()));
        });
    }
}

