/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.spi.AvajeModule;
import io.avaje.inject.spi.InjectExtension;
import io.avaje.inject.spi.InjectPlugin;
import io.avaje.inject.spi.Module;
import io.avaje.inject.spi.Plugin;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

final class LoadServices {
    private LoadServices() {
    }

    static List<AvajeModule> loadModules(ClassLoader classLoader) {
        ArrayList<AvajeModule> modules = new ArrayList<AvajeModule>();
        ServiceLoader.load(Module.class, classLoader).forEach(modules::add);
        Iterator<InjectExtension> iterator = ServiceLoader.load(InjectExtension.class, classLoader).iterator();
        while (iterator.hasNext()) {
            try {
                InjectExtension spi = iterator.next();
                if (!(spi instanceof AvajeModule)) continue;
                modules.add((AvajeModule)spi);
            }
            catch (ServiceConfigurationError serviceConfigurationError) {}
        }
        return modules;
    }

    static List<InjectPlugin> loadPlugins(ClassLoader classLoader) {
        ArrayList<InjectPlugin> plugins = new ArrayList<InjectPlugin>();
        ServiceLoader.load(Plugin.class, classLoader).forEach(plugins::add);
        Iterator<InjectExtension> iterator = ServiceLoader.load(InjectExtension.class, classLoader).iterator();
        while (iterator.hasNext()) {
            try {
                InjectExtension spi = iterator.next();
                if (!(spi instanceof InjectPlugin)) continue;
                plugins.add((InjectPlugin)spi);
            }
            catch (ServiceConfigurationError serviceConfigurationError) {}
        }
        return plugins;
    }
}

