/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

final class ModuleData {
    private final String fqn;
    private final List<String> provides;
    private final List<String> requires;

    ModuleData(String name, List<String> provides, List<String> requires) {
        this.fqn = name;
        this.provides = provides;
        this.requires = requires;
    }

    static Optional<ModuleData> of(String[] moduleCsv) {
        try {
            return Optional.of(new ModuleData(moduleCsv[0], Arrays.stream(moduleCsv[1].split(",")).filter(Predicate.not(String::isBlank)).collect(Collectors.toList()), Arrays.stream(moduleCsv[2].split(",")).filter(Predicate.not(String::isBlank)).collect(Collectors.toList())));
        }
        catch (Exception e) {
            System.err.println("Failed to parse" + Arrays.toString(moduleCsv));
            return Optional.empty();
        }
    }

    List<String> provides() {
        return this.provides;
    }

    List<String> requires() {
        return this.requires;
    }

    String name() {
        return this.fqn;
    }

    public String toString() {
        return "ModuleData [fqn=" + this.fqn + ", provides=" + String.valueOf(this.provides) + ", requires=" + String.valueOf(this.requires) + "]";
    }
}

