/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.APContext;
import io.avaje.inject.generator.Append;
import io.avaje.inject.generator.AspectImportPrism;
import io.avaje.inject.generator.ExternalProvider;
import io.avaje.inject.generator.ModuleData;
import io.avaje.inject.generator.PrimitiveUtil;
import io.avaje.inject.generator.ProcessorUtils;
import io.avaje.inject.generator.Util;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.processing.FilerException;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

final class ProcessingContext {
    private static final ThreadLocal<Ctx> CTX = new ThreadLocal();
    private static boolean processingOver;

    private ProcessingContext() {
    }

    static void init(Set<String> moduleFileProvided, boolean performModuleValidation) {
        CTX.set(new Ctx());
        CTX.get().registerProvidedTypes(moduleFileProvided);
    }

    static String loadMetaInfServices() {
        return ProcessingContext.loadMetaInf("META-INF/services/io.avaje.inject.spi.InjectExtension").stream().filter(ProcessingContext::isInjectModule).findFirst().orElse(null);
    }

    private static boolean isInjectModule(String spi) {
        TypeElement moduleType = APContext.typeElement(spi);
        return moduleType != null && moduleType.getInterfaces().stream().map(TypeMirror::toString).anyMatch(s -> s.contains("AvajeModule"));
    }

    static List<String> loadMetaInfCustom() {
        return ProcessingContext.loadMetaInf("META-INF/services/io.avaje.inject.spi.AvajeModule.Custom");
    }

    private static List<String> loadMetaInf(String fullName) {
        try {
            FileObject fileObject = APContext.filer().getResource(StandardLocation.CLASS_OUTPUT, "", fullName);
            if (fileObject != null) {
                String line;
                ArrayList<String> lines = new ArrayList<String>();
                Reader reader = fileObject.openReader(true);
                LineNumberReader lineReader = new LineNumberReader(reader);
                while ((line = lineReader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty()) continue;
                    lines.add(line);
                }
                return lines;
            }
        }
        catch (FileNotFoundException | NoSuchFileException fileObject) {
        }
        catch (FilerException e) {
            APContext.logNote("FilerException reading services file", new Object[0]);
        }
        catch (Exception e) {
            APContext.logWarn("Error reading services file: " + e.getMessage(), new Object[0]);
        }
        return Collections.emptyList();
    }

    static void addInjectSPI(String type) {
        ProcessingContext.CTX.get().spiServices.add(type);
    }

    static FileObject createMetaInfWriterFor(String interfaceType) throws IOException {
        return APContext.filer().createResource(StandardLocation.CLASS_OUTPUT, "", interfaceType, new Element[0]);
    }

    static TypeElement elementMaybe(String rawType) {
        if (rawType == null) {
            return null;
        }
        return APContext.elements().getTypeElement(rawType);
    }

    static TypeElement asElement(TypeMirror returnType) {
        String wrapper = PrimitiveUtil.wrap(returnType.toString());
        return wrapper == null ? APContext.asTypeElement(returnType) : APContext.typeElement(wrapper);
    }

    static boolean isUncheckedException(TypeMirror returnType) {
        TypeMirror runtime = APContext.typeElement("java.lang.RuntimeException").asType();
        return APContext.types().isSubtype(returnType, runtime);
    }

    static void addModule(String moduleFullName) {
        if (moduleFullName != null) {
            ProcessingContext.CTX.get().uniqueModuleNames.add(moduleFullName);
        }
    }

    static boolean isDuplicateModule(String moduleFullName) {
        return ProcessingContext.CTX.get().uniqueModuleNames.contains(moduleFullName);
    }

    static boolean externallyProvided(String type) {
        return ProcessingContext.CTX.get().providedTypes.contains(type) || ProcessingContext.CTX.get().optionalTypes.contains(type);
    }

    static void addOptionalType(String paramType, String name) {
        if (!ProcessingContext.CTX.get().providedTypes.contains(paramType)) {
            ProcessingContext.CTX.get().optionalTypes.add(ProcessorUtils.trimAnnotations(Util.addQualifierSuffixTrim(name, paramType)));
        }
    }

    static void addImportedAspects(Map<String, AspectImportPrism> importedMap) {
        ProcessingContext.CTX.get().aspectImportPrisms.putAll(importedMap);
    }

    static void validateModule() {
        APContext.moduleInfoReader().ifPresent(reader -> reader.validateServices("io.avaje.inject.spi.InjectExtension", ProcessingContext.CTX.get().spiServices));
    }

    static Optional<AspectImportPrism> getImportedAspect(String type) {
        return Optional.ofNullable(ProcessingContext.CTX.get().aspectImportPrisms.get(type));
    }

    static Set<TypeElement> delayedElements() {
        Set<TypeElement> set = ProcessingContext.CTX.get().delayQueue.stream().map(t -> t.getQualifiedName().toString()).map(APContext::typeElement).collect(Collectors.toSet());
        ProcessingContext.CTX.get().delayQueue.clear();
        return set;
    }

    static boolean delayUntilNextRound(TypeElement element) {
        if (!processingOver) {
            ProcessingContext.CTX.get().delayQueue.add(element);
        }
        return !processingOver;
    }

    static void clear() {
        CTX.remove();
        APContext.clear();
    }

    static void addModule(ModuleData module) {
        ProcessingContext.CTX.get().modules.add(module);
    }

    static List<ModuleData> modules() {
        return ProcessingContext.CTX.get().modules;
    }

    static void strictWiring(boolean strictWiring) {
        ProcessingContext.CTX.get().strictWiring = strictWiring;
    }

    static boolean strictWiring() {
        return ProcessingContext.CTX.get().strictWiring;
    }

    static void processingOver(boolean over) {
        processingOver = over;
    }

    static void writeSPIServicesFile() {
        ProcessingContext.readExistingMetaInfServices();
        try {
            FileObject jfo = ProcessingContext.createMetaInfWriterFor("META-INF/services/io.avaje.inject.spi.InjectExtension");
            if (jfo != null) {
                Append writer = new Append(jfo.openWriter());
                for (String service : ProcessingContext.CTX.get().spiServices) {
                    writer.append(service).eol();
                }
                writer.close();
            }
        }
        catch (IOException e) {
            APContext.logError("Failed to write services file " + e.getMessage(), new Object[0]);
        }
    }

    private static void readExistingMetaInfServices() {
        try (InputStream file = APContext.filer().getResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/io.avaje.inject.spi.InjectExtension").toUri().toURL().openStream();
             BufferedReader buffer = new BufferedReader(new InputStreamReader(file));){
            String line;
            while ((line = buffer.readLine()) != null) {
                line.replaceAll("\\s", "").replace(",", "\n").lines().forEach(ProcessingContext::addInjectSPI);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static final class Ctx {
        private final Set<String> uniqueModuleNames = new HashSet<String>();
        private final Set<String> providedTypes = new HashSet<String>();
        private final Set<String> optionalTypes = new LinkedHashSet<String>();
        private final Map<String, AspectImportPrism> aspectImportPrisms = new HashMap<String, AspectImportPrism>();
        private final List<ModuleData> modules = new ArrayList<ModuleData>();
        private final List<TypeElement> delayQueue = new ArrayList<TypeElement>();
        private final Set<String> spiServices = new TreeSet<String>();
        private boolean strictWiring;

        Ctx() {
        }

        void registerProvidedTypes(Set<String> moduleFileProvided) {
            ExternalProvider.registerModuleProvidedTypes(this.providedTypes);
            this.providedTypes.addAll(moduleFileProvided);
        }
    }
}

