/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.APContext;
import io.avaje.inject.generator.AnnotationCopier;
import io.avaje.inject.generator.Append;
import io.avaje.inject.generator.AssistBeanReader;
import io.avaje.inject.generator.FieldReader;
import io.avaje.inject.generator.MethodReader;
import io.avaje.inject.generator.UType;
import io.avaje.inject.generator.Util;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.JavaFileObject;

final class SimpleAssistWriter {
    private static final String CODE_COMMENT = "/**\n * Generated source - Factory for %s.\n */";
    private static final String CODE_COMMENT_BUILD = "  /**\n   * Fabricates a new %s.\n   */";
    private final AssistBeanReader beanReader;
    private final String originName;
    private final String shortName;
    private final String packageName;
    private final String suffix;
    private Append writer;
    private final List<Element> assistedElements;
    private final boolean hasNoConstructorParams;

    SimpleAssistWriter(AssistBeanReader beanReader) {
        this.beanReader = beanReader;
        this.packageName = beanReader.packageName();
        this.shortName = beanReader.shortName();
        this.suffix = "$AssistFactory";
        this.assistedElements = beanReader.assistElements();
        this.originName = this.packageName + "." + this.shortName;
        this.hasNoConstructorParams = beanReader.constructor().params().stream().filter(Predicate.not(MethodReader.MethodParam::assisted)).findAny().isEmpty();
    }

    private Writer createFileWriter() throws IOException {
        String origin = this.originName;
        if (this.beanReader.beanType().getNestingKind().isNested()) {
            origin = origin.replace(this.shortName, this.shortName.replace(".", "$"));
        }
        JavaFileObject jfo = APContext.createSourceFile(origin + this.suffix, new Element[0]);
        return jfo.openWriter();
    }

    void write() throws IOException {
        this.writer = new Append(this.createFileWriter());
        this.writePackage();
        this.writeImports();
        this.writeClassStart();
        this.writeInjectFields();
        this.writeMethodFields();
        this.writeConstructor();
        this.writeFactoryMethod();
        this.beanReader.injectMethods().forEach(this::writeInjectionMethods);
        this.writeClassEnd();
        this.writer.close();
    }

    private void writePackage() {
        if (this.packageName != null) {
            this.writer.append("package %s;", this.packageName).eol().eol();
        }
    }

    private void writeImports() {
        this.beanReader.writeImports(this.writer, this.packageName);
    }

    private void writeClassStart() {
        String valhallaStr;
        String qualifierName;
        this.writer.append(CODE_COMMENT, this.shortName).eol();
        this.writer.append("@Generated(\"io.avaje.inject.generator\")").eol();
        String name = this.shortName;
        if (this.beanReader.beanType().getNestingKind().isNested()) {
            name = name.replace(".", "$");
        }
        if ((qualifierName = this.beanReader.qualifierName()) != null) {
            this.writer.append("@Named(\"%s\")", qualifierName).eol();
        }
        this.writer.append("@Component").eol();
        if (!this.beanReader.hasTargetFactory()) {
            this.writer.append("public ");
        }
        if (!(valhallaStr = Util.valhalla()).isBlank() && this.hasAssistedFieldsOrParams()) {
            valhallaStr = "";
        }
        this.writer.append("final %sclass ", valhallaStr).append(name).append(this.suffix);
        this.writeImplementsOrExtends();
        this.writer.append(" {").eol().eol();
    }

    private boolean hasAssistedFieldsOrParams() {
        return this.beanReader.injectFields().stream().anyMatch(FieldReader::assisted) || this.beanReader.injectMethods().stream().flatMap(m -> m.params().stream()).anyMatch(MethodReader.MethodParam::assisted);
    }

    private void writeImplementsOrExtends() {
        TypeElement targetInterface = this.beanReader.targetInterface();
        this.writer.append(targetInterface.getKind() == ElementKind.INTERFACE ? " implements " : " extends ").append(Util.shortName(targetInterface.getQualifiedName().toString()));
    }

    private void writeInjectFields() {
        if (this.beanReader.injectFields().isEmpty()) {
            return;
        }
        for (FieldReader field : this.beanReader.injectFields()) {
            if (field.assisted()) continue;
            Element element = field.element();
            AnnotationCopier.copyAnnotations(this.writer, element, "  ", true);
            UType type = UType.parse(element.asType());
            this.writer.append("  %s %s$field;", type.shortType(), field.fieldName()).eol().eol();
        }
        if (this.beanReader.injectMethods().isEmpty() && this.hasNoConstructorParams) {
            this.writer.eol();
        }
    }

    private void writeMethodFields() {
        if (this.beanReader.injectMethods().isEmpty()) {
            return;
        }
        this.beanReader.injectMethods().stream().flatMap(m -> m.params().stream()).filter(Predicate.not(MethodReader.MethodParam::assisted)).forEach(p -> {
            Element element = p.element();
            this.writer.append("  private %s %s$method;", UType.parse(element.asType()).shortType(), p.simpleName()).eol();
        });
        if (this.hasNoConstructorParams) {
            this.writer.eol();
        }
    }

    private void writeConstructor() {
        List<MethodReader.MethodParam> injectParams = this.beanReader.constructor().params().stream().filter(Predicate.not(MethodReader.MethodParam::assisted)).collect(Collectors.toList());
        if (injectParams.isEmpty()) {
            return;
        }
        this.writeFieldsForInjected(injectParams);
        String shortName = this.shortName;
        if (this.beanReader.beanType().getNestingKind().isNested()) {
            shortName = shortName.replace(".", "$");
        }
        this.writer.eol().append("  ").append(shortName).append(this.suffix).append("(");
        Iterator<MethodReader.MethodParam> iterator = injectParams.iterator();
        while (iterator.hasNext()) {
            MethodReader.MethodParam p = iterator.next();
            Element element = p.element();
            AnnotationCopier.copyAnnotations(this.writer, element, false);
            UType type = UType.parse(element.asType());
            this.writer.append("%s %s", type.shortType(), p.simpleName());
            if (!iterator.hasNext()) continue;
            this.writer.append(", ");
        }
        this.writer.append(") {").eol();
        for (MethodReader.MethodParam p : injectParams) {
            this.writer.append("    ").append("this.%s = %s;", p.simpleName(), p.simpleName()).eol();
        }
        this.writer.append("  }").eol().eol();
    }

    private void writeFieldsForInjected(List<MethodReader.MethodParam> injectParams) {
        for (MethodReader.MethodParam p : injectParams) {
            Element element = p.element();
            String type = UType.parse(element.asType()).shortType();
            this.writer.append("  private final %s %s;", type, p.simpleName()).eol();
        }
    }

    private void writeFactoryMethod() {
        this.writer.append(CODE_COMMENT_BUILD, this.shortName).eol();
        if (this.beanReader.hasTargetFactory()) {
            this.writer.append("  @Override").eol();
        }
        this.writer.append("  public %s %s(", this.shortName, this.beanReader.factoryMethodName());
        List<? extends VariableElement> params = this.beanReader.factoryMethodParams();
        Iterator<? extends VariableElement> iterator = params.iterator();
        while (iterator.hasNext()) {
            VariableElement element = iterator.next();
            UType type = UType.parse(element.asType());
            this.writer.append("%s %s", type.shortWithoutAnnotations(), element.getSimpleName());
            if (!iterator.hasNext()) continue;
            this.writer.append(", ");
        }
        this.writer.append(") {").eol();
        MethodReader constructor = this.beanReader.constructor();
        constructor.startTry(this.writer);
        this.writeCreateBean(constructor);
        this.beanReader.buildRegister(this.writer);
        if (this.beanReader.isExtraInjectionRequired()) {
            this.writeExtraInjection();
        }
        constructor.endTry(this.writer);
        this.writer.eol().append("  }").eol();
    }

    private void writeCreateBean(MethodReader constructor) {
        String indent = "   ";
        this.writer.indent(indent).append(" var bean = new %s(", this.shortName);
        this.writeMethodParams(constructor, true);
    }

    private void writeExtraInjection() {
        this.injectFields();
        this.injectMethods();
        this.writer.indent("    return bean;");
    }

    private void injectFields() {
        if (this.beanReader.injectFields().isEmpty()) {
            return;
        }
        for (FieldReader fieldReader : this.beanReader.injectFields()) {
            if (fieldReader.assisted()) continue;
            String fieldName = fieldReader.fieldName();
            String getDependency = fieldName + "$field";
            this.writer.indent("    ").append("bean.%s = %s;", fieldName, getDependency).eol();
        }
        this.assistedElements.stream().filter(e -> e.getKind() == ElementKind.FIELD).forEach(field -> this.writer.indent("    ").append("bean.%s = %s;", field.getSimpleName(), field.getSimpleName()).eol());
    }

    private void injectMethods() {
        boolean needsTry = this.beanReader.needsTryForMethodInjection();
        if (needsTry) {
            this.writer.indent("    try {").eol();
        }
        String indent = needsTry ? "      " : "    ";
        for (MethodReader methodReader : this.beanReader.injectMethods()) {
            this.writer.indent(indent).append("bean.%s(", methodReader.name());
            this.writeMethodParams(methodReader, false);
        }
        if (needsTry) {
            this.writer.indent("    } catch (Throwable e) {").eol();
            this.writer.indent("      throw new RuntimeException(\"Error wiring method\", e);").eol();
            this.writer.indent("    }").eol();
        }
    }

    private void writeMethodParams(MethodReader methodReader, boolean constructor) {
        List<MethodReader.MethodParam> methodParams = methodReader.params();
        for (int i = 0; i < methodParams.size(); ++i) {
            MethodReader.MethodParam methodParam;
            if (i > 0) {
                this.writer.append(", ");
            }
            if (!(methodParam = methodParams.get(i)).assisted()) {
                this.writer.append(methodParam.simpleName()).append(constructor ? "" : "$method");
                continue;
            }
            this.writer.append("%s", methodParam.simpleName());
        }
        this.writer.append(");").eol();
    }

    private void writeClassEnd() {
        this.writer.append("}").eol();
    }

    private void writeInjectionMethods(MethodReader reader) {
        this.writer.eol();
        ExecutableElement methodElement = reader.element();
        AnnotationCopier.copyAnnotations(this.writer, methodElement, "  ", true);
        String simpleName = reader.name();
        String returnType = UType.parse(methodElement.getReturnType()).shortType();
        this.writer.append("  ").append(returnType).append(" ").append(simpleName).append("(");
        Iterator<MethodReader.MethodParam> iterator = reader.params().iterator();
        while (iterator.hasNext()) {
            MethodReader.MethodParam p = iterator.next();
            if (p.assisted()) continue;
            Element element = p.element();
            AnnotationCopier.copyAnnotations(this.writer, element, false);
            UType type = UType.parse(element.asType());
            this.writer.append("%s %s", type.shortType(), p.simpleName());
            if (!iterator.hasNext()) continue;
            this.writer.append(", ");
        }
        this.writer.append(") {").eol();
        for (MethodReader.MethodParam p : reader.params()) {
            if (p.assisted()) continue;
            this.writer.append("    this.%s$method = %s;", p.simpleName(), p.simpleName()).eol();
        }
        this.writer.append("  }").eol();
    }
}

