/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.AspectMethod;
import io.avaje.inject.generator.ImportTypeMap;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

final class BeanAspects {
    static final BeanAspects EMPTY = new BeanAspects();
    private final List<AspectMethod> aspectMethods;
    private final Set<String> aspectNames;

    private BeanAspects() {
        this.aspectMethods = Collections.emptyList();
        this.aspectNames = Collections.emptySet();
    }

    BeanAspects(List<AspectMethod> aspectMethods) {
        this.aspectMethods = aspectMethods;
        this.aspectNames = this.initAspectNames();
    }

    boolean hasAspects() {
        return !this.aspectMethods.isEmpty();
    }

    Set<String> aspectNames() {
        return this.aspectNames;
    }

    void extraImports(ImportTypeMap importTypes) {
        for (AspectMethod aspectMethod : this.aspectMethods) {
            aspectMethod.addImports(importTypes);
        }
    }

    Set<String> initAspectNames() {
        LinkedHashSet<String> targets = new LinkedHashSet<String>();
        for (AspectMethod aspectMethod : this.aspectMethods) {
            aspectMethod.addTargets(targets);
        }
        return targets;
    }

    List<AspectMethod> methods() {
        return this.aspectMethods;
    }
}

