/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.Append;
import io.avaje.inject.generator.BeanConditions;
import io.avaje.inject.generator.Util;
import java.util.Map;
import java.util.stream.Collectors;

final class ConditionalWriter {
    private final Append writer;
    private final BeanConditions conditions;
    private boolean first = true;

    public ConditionalWriter(Append writer, BeanConditions conditions) {
        this.writer = writer;
        this.conditions = conditions;
    }

    public void write() {
        if (this.conditions.isEmpty()) {
            return;
        }
        this.writer.append("    if (");
        if (!this.conditions.orProfiles.isEmpty()) {
            this.prefix();
            this.writer.append("!builder.containsProfiles(List.of(%s\"))", this.conditions.orProfiles.stream().map(s -> "\"" + s).collect(Collectors.joining("\",")));
        }
        if (!this.conditions.andProfiles.isEmpty()) {
            this.prefix();
            this.writer.append("!builder.containsAllProfiles(List.of(%s\"))", this.conditions.andProfiles.stream().map(s -> "\"" + s).collect(Collectors.joining("\",")));
        }
        if (!this.conditions.notProfiles.isEmpty()) {
            this.prefix();
            this.writer.append("builder.containsProfiles(List.of(%s\"))", this.conditions.notProfiles.stream().map(s -> "\"" + s).collect(Collectors.joining("\",")));
        }
        for (String string : this.conditions.requireTypes) {
            this.prefix();
            this.writer.append("!builder.contains(%s.class)", Util.shortName(string));
        }
        for (String string : this.conditions.missingTypes) {
            this.prefix();
            this.writer.append("builder.contains(%s.class)", Util.shortName(string));
        }
        for (String string : this.conditions.qualifierNames) {
            this.prefix();
            this.writer.append("!builder.containsQualifier(\"%s\")", string);
        }
        for (String string : this.conditions.containsProps) {
            this.prefix();
            this.writer.append("builder.property().missing(\"%s\")", string);
        }
        for (String string : this.conditions.missingProps) {
            this.prefix();
            this.writer.append("builder.property().contains(\"%s\")", string);
        }
        for (Map.Entry entry : this.conditions.propertyEquals.entrySet()) {
            this.prefix();
            this.writer.append("builder.property().notEqualTo(\"%s\", \"%s\")", entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : this.conditions.propertyNotEquals.entrySet()) {
            this.prefix();
            this.writer.append("builder.property().equalTo(\"%s\", \"%s\")", entry.getKey(), entry.getValue());
        }
        this.writer.append(") {").eol().append("      return;").eol().append("    }").eol().eol();
    }

    private void prefix() {
        if (this.first) {
            this.first = false;
        } else {
            this.writer.eol().append("      || ");
        }
    }
}

