/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.ProcessorUtils;
import io.avaje.inject.generator.Util;

final class Dependency {
    private final String name;
    private boolean softDependency;

    Dependency(String type) {
        String nameStr;
        if (type.startsWith("soft:")) {
            this.softDependency = true;
            nameStr = type.substring(5);
        } else if (type.startsWith("con:")) {
            this.softDependency = true;
            nameStr = type.substring(4);
        } else {
            this.softDependency = false;
            nameStr = type;
        }
        this.name = nameStr.replace(", ", ",");
    }

    Dependency(String type, String qualifier) {
        String nameStr;
        if (type.startsWith("soft:")) {
            this.softDependency = true;
            nameStr = ProcessorUtils.trimAnnotations(type.substring(5));
        } else if (type.startsWith("con:")) {
            this.softDependency = true;
            nameStr = ProcessorUtils.trimAnnotations(type.substring(4));
        } else {
            this.softDependency = false;
            nameStr = ProcessorUtils.trimAnnotations(type);
        }
        this.name = Util.addQualifierSuffixTrim(qualifier, nameStr);
    }

    Dependency(String name, String qualifier, boolean softDependency) {
        this.name = Util.addQualifierSuffixTrim(qualifier, ProcessorUtils.trimAnnotations(name));
        this.softDependency = softDependency;
    }

    public String toString() {
        return this.softDependency ? "soft:" + this.name : this.name;
    }

    String name() {
        return this.name;
    }

    boolean isSoftDependency() {
        return this.softDependency;
    }

    String dependsOn() {
        return this.toString();
    }

    void markExternal() {
        this.softDependency = true;
    }
}

