/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.PreDestroyPrism;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;

final class DestroyMethods {
    private final Map<String, DestroyMethod> methods = new HashMap<String, DestroyMethod>();
    private final Set<String> matchedTypes = new HashSet<String>();

    DestroyMethods() {
    }

    void add(ExecutableElement element) {
        Integer priority = PreDestroyPrism.getOptionalOn(element).map(PreDestroyPrism::priority).orElse(null);
        DestroyMethod destroyMethod = new DestroyMethod(element, priority);
        this.methods.put(destroyMethod.matchType, destroyMethod);
    }

    DestroyMethod match(String returnTypeRaw) {
        DestroyMethod match = this.methods.get(returnTypeRaw);
        if (match != null) {
            this.matchedTypes.add(returnTypeRaw);
        }
        return match;
    }

    List<DestroyMethod> unmatched() {
        return this.methods.values().stream().filter(entry -> !this.matchedTypes.contains(entry.matchType())).collect(Collectors.toList());
    }

    static final class DestroyMethod {
        private final String method;
        private final Integer priority;
        private final String matchType;
        private final ExecutableElement element;

        DestroyMethod(ExecutableElement element, Integer priority) {
            this.element = element;
            this.method = element.getSimpleName().toString();
            this.matchType = element.getParameters().get(0).asType().toString();
            this.priority = priority;
        }

        String method() {
            return this.method;
        }

        Integer priority() {
            return this.priority;
        }

        String matchType() {
            return this.matchType;
        }

        Element element() {
            return this.element;
        }
    }
}

