/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.APContext;
import io.avaje.inject.generator.Append;
import io.avaje.inject.generator.ImportTypeMap;
import io.avaje.inject.generator.ProcessingContext;
import io.avaje.inject.generator.UType;
import io.avaje.inject.generator.Util;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.JavaFileObject;

final class EventPublisherWriter {
    private static final Map<String, String> GENERATED_PUBLISHERS = new HashMap<String, String>();
    private static final String TEMPLATE = "package {0};\n\n{1}@Component\n{2}@Generated(\"avaje-inject-generator\")\npublic class {3} extends Event<{4}> '{'\n\n  private static final Type TYPE = {5};\n\n  public {3}(ObserverManager manager) '{'\n    super(manager, TYPE, \"{6}\");\n  '}'\n'}'\n";
    private final String originName;
    private final ImportTypeMap importTypes = new ImportTypeMap();
    private final UType utype;
    private final String packageName;
    private final String qualifier;

    static void write(Element element) {
        new EventPublisherWriter(element);
    }

    private EventPublisherWriter(Element element) {
        TypeMirror asType = element.asType();
        this.utype = UType.parse(asType).param0();
        this.packageName = Optional.ofNullable(APContext.typeElement(this.utype.mainType())).map(APContext.elements()::getPackageOf).map(PackageElement::getQualifiedName).map(Object::toString).orElse("error.notype").replaceFirst("java.", "") + ".events";
        this.qualifier = Optional.ofNullable(Util.named(element)).orElse("");
        String className = this.packageName + "." + (this.qualifier.isEmpty() ? "" : "Qualified") + Util.shortName(this.utype).replace(".", "_") + "$Publisher";
        this.originName = this.getUniqueClassName(className, 0);
        if (GENERATED_PUBLISHERS.containsKey(this.originName)) {
            ProcessingContext.addOptionalType(UType.parse(asType).fullWithoutAnnotations(), Util.named(element));
            return;
        }
        this.importTypes.addAll(this.utype.importTypes());
        this.write();
        GENERATED_PUBLISHERS.put(this.originName, this.qualifier);
    }

    private String getUniqueClassName(String className, Integer recursiveIndex) {
        Optional.ofNullable(APContext.typeElement((String)className)).ifPresent(e -> GENERATED_PUBLISHERS.put(e.getQualifiedName().toString(), Optional.ofNullable(Util.named(e)).orElse("")));
        if (Optional.ofNullable(GENERATED_PUBLISHERS.get(className)).filter(Predicate.not(this.qualifier::equals)).isPresent()) {
            int index = ((String)className).indexOf("$Publisher");
            recursiveIndex = recursiveIndex + 1;
            className = ((String)className).substring(0, index) + "$Publisher" + recursiveIndex;
            return this.getUniqueClassName((String)className, recursiveIndex);
        }
        return className;
    }

    private Writer createFileWriter() throws IOException {
        JavaFileObject jfo = APContext.createSourceFile(this.originName, new Element[0]);
        return jfo.openWriter();
    }

    void write() {
        try {
            Append writer = new Append(this.createFileWriter());
            String shortType = this.utype.shortWithoutAnnotations();
            Object typeString = this.utype.isGeneric() ? this.getGenericType() : shortType + ".class";
            String name = this.qualifier.isBlank() ? "" : "@Named(\"" + this.qualifier + "\")\n";
            String className = this.originName.replace(this.packageName + ".", "");
            writer.append(MessageFormat.format(TEMPLATE, this.packageName, this.imports(), name, className, shortType, typeString, this.qualifier));
            writer.close();
        }
        catch (Exception e) {
            APContext.logError("Failed to write EventPublisher class %s", e);
        }
    }

    String imports() {
        this.importTypes.add("io.avaje.inject.Component");
        this.importTypes.add("io.avaje.inject.events.Event");
        this.importTypes.add("io.avaje.inject.events.ObserverManager");
        this.importTypes.add("io.avaje.inject.spi.Generated");
        this.importTypes.add(Type.class.getCanonicalName());
        if (!this.qualifier.isBlank()) {
            this.importTypes.add("jakarta.inject.Named");
        }
        if (this.utype.isGeneric()) {
            this.importTypes.add("io.avaje.inject.spi.GenericType");
        }
        StringBuilder writer = new StringBuilder();
        for (String importType : this.importTypes.forImport()) {
            if (!Util.validImportType(importType, this.packageName)) continue;
            writer.append(String.format("import %s;\n", Util.sanitizeImports(importType)));
        }
        return writer.append("\n").toString();
    }

    String getGenericType() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n      new GenericType<");
        this.writeGenericType(this.utype, new HashMap<String, String>(), sb);
        sb.append(">(){}.type();");
        return sb.toString();
    }

    private void writeGenericType(UType type, Map<String, String> seenShortNames, StringBuilder writer) {
        String typeShortName = Util.shortName(type.mainType());
        String mainType = seenShortNames.computeIfAbsent(typeShortName, k -> type.mainType());
        if (type.isGeneric()) {
            String shortName = Objects.equals(type.mainType(), mainType) ? typeShortName : type.mainType();
            writer.append(shortName);
            writer.append("<");
            boolean first = true;
            for (UType param : type.componentTypes()) {
                if (first) {
                    first = false;
                    this.writeGenericType(param, seenShortNames, writer);
                    continue;
                }
                writer.append(", ");
                this.writeGenericType(param, seenShortNames, writer);
            }
            writer.append(">");
        } else {
            String shortName = Objects.equals(type.mainType(), mainType) ? typeShortName : type.mainType();
            writer.append(shortName);
        }
    }
}

