/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.APContext;
import io.avaje.inject.generator.Dependency;
import io.avaje.inject.generator.DependencyMetaPrism;
import io.avaje.inject.generator.LoadServices;
import io.avaje.inject.generator.MetaData;
import io.avaje.inject.generator.ModuleData;
import io.avaje.inject.generator.PluginProvidesPrism;
import io.avaje.inject.generator.ProcessingContext;
import io.avaje.inject.generator.ScopeInfo;
import io.avaje.inject.generator.Util;
import io.avaje.inject.spi.AvajeModule;
import io.avaje.inject.spi.InjectPlugin;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;

final class ExternalProvider {
    private static final ClassLoader CLASS_LOADER = ExternalProvider.class.getClassLoader();
    private static final boolean INJECT_AVAILABLE = ExternalProvider.moduleCP();
    private static final Map<String, List<String>> avajePlugins = Map.ofEntries(Map.entry("io.avaje.inject.events.spi.ObserverManagerPlugin", List.of("io.avaje.inject.events.ObserverManager")), Map.entry("io.avaje.jsonb.inject.DefaultJsonbProvider", List.of("io.avaje.jsonb.Jsonb")), Map.entry("io.avaje.http.inject.DefaultResolverProvider", List.of("io.avaje.http.api.context.RequestContextResolver")), Map.entry("io.avaje.htmx.nima.jstache.DefaultTemplateProvider", List.of("io.avaje.htmx.nima.TemplateContentCache", "io.avaje.htmx.nima.TemplateRender")), Map.entry("io.avaje.nima.provider.DefaultConfigProvider", List.of("io.helidon.webserver.WebServerConfig.Builder", "io.helidon.webserver.http.HttpRouting.Builder")), Map.entry("io.avaje.validation.inject.spi.DefaultValidatorProvider", List.of("io.avaje.validation.Validator", "io.avaje.inject.aop.AspectProvider<io.avaje.validation.ValidMethod>")), Map.entry("io.avaje.validation.http.HttpValidatorProvider", List.of("io.avaje.http.api.Validator")));
    private static final List<MetaData> externalMeta = new ArrayList<MetaData>();

    private ExternalProvider() {
    }

    private static boolean moduleCP() {
        try {
            Class.forName("io.avaje.inject.spi.AvajeModule");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static void registerModuleProvidedTypes(Set<String> providedTypes) {
        if (!INJECT_AVAILABLE) {
            return;
        }
        List<AvajeModule> modules = LoadServices.loadModules(CLASS_LOADER);
        if (modules.isEmpty()) {
            return;
        }
        for (AvajeModule module : modules) {
            String name = module.getClass().getTypeName();
            TreeSet<String> provides = new TreeSet<String>();
            for (Type type : module.provides()) {
                provides.add(type.getTypeName());
            }
            for (Type type : module.autoProvides()) {
                provides.add(type.getTypeName());
            }
            for (Type type : module.autoProvidesAspects()) {
                String aspectType = Util.wrapAspect(((Class)type).getTypeName());
                provides.add(aspectType);
            }
            ExternalProvider.registerExternalMetaData(name);
            ExternalProvider.readMetaDataProvides(provides);
            providedTypes.addAll(provides);
            List<String> requires = Arrays.stream(module.requires()).map(Type::getTypeName).collect(Collectors.toList());
            Arrays.stream(module.autoRequires()).map(Type::getTypeName).forEach(requires::add);
            Arrays.stream(module.requiresPackages()).map(Type::getTypeName).forEach(requires::add);
            Arrays.stream(module.autoRequiresAspects()).map(Type::getTypeName).map(Util::wrapAspect).forEach(requires::add);
            ProcessingContext.addModule(new ModuleData(name, List.copyOf(provides), requires));
        }
    }

    static void registerPluginProvidedTypes(ScopeInfo defaultScope) {
        if (!INJECT_AVAILABLE) {
            if (!ExternalProvider.pluginExists("avaje-module-dependencies.csv")) {
                APContext.logNote("Unable to detect Avaje Inject Maven/Gradle plugin, use the Avaje Inject Maven/Gradle plugin for auto detecting External Inject Plugins/Modules from dependencies", new Object[0]);
            }
            return;
        }
        List<InjectPlugin> plugins = LoadServices.loadPlugins(CLASS_LOADER);
        for (InjectPlugin plugin : plugins) {
            ProcessingContext.addExternalInjectSPI(plugin.getClass().getCanonicalName());
            String name = plugin.getClass().getTypeName();
            if (avajePlugins.containsKey(name)) continue;
            APContext.logNote("Loaded Plugin: %s", plugin.getClass().getTypeName());
            for (Type type : plugin.provides()) {
                defaultScope.pluginProvided(type.getTypeName());
            }
            for (Type type : plugin.providesAspects()) {
                defaultScope.pluginProvided(Util.wrapAspect(((Class)type).getTypeName()));
            }
        }
    }

    private static boolean pluginExists(String relativeName) {
        try {
            return APContext.getBuildResource(relativeName).toFile().exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    static void registerExternalMetaData(String name) {
        ProcessingContext.addExternalInjectSPI(name);
        Optional.ofNullable(APContext.typeElement(name)).map(TypeElement::getEnclosedElements).map(ElementFilter::methodsIn).stream().flatMap(Collection::stream).map(DependencyMetaPrism::getInstanceOn).filter(Objects::nonNull).map(MetaData::new).forEach(externalMeta::add);
    }

    static void readMetaDataProvides(Collection<String> providedTypes) {
        externalMeta.forEach(meta -> {
            providedTypes.add(meta.key());
            providedTypes.add(meta.type());
            providedTypes.addAll(Util.addQualifierSuffix(meta.provides(), meta.name()));
            providedTypes.addAll(Util.addQualifierSuffix(meta.autoProvides(), meta.name()));
        });
    }

    static void scanAllInjectPlugins(ScopeInfo defaultScope) {
        HashMap<String, List<String>> plugins = new HashMap<String, List<String>>();
        boolean hasPlugins = !defaultScope.pluginProvided().isEmpty();
        avajePlugins.forEach((k, v) -> {
            if (APContext.typeElement(k) != null) {
                plugins.put((String)k, (List<String>)v);
                APContext.logNote("Loaded Plugin: %s", k);
                ProcessingContext.addExternalInjectSPI(k);
                v.forEach(defaultScope::pluginProvided);
            }
        });
        defaultScope.pluginProvided("io.avaje.inject.event.ObserverManager");
        if (hasPlugins) {
            return;
        }
        ExternalProvider.injectExtensions().filter(PluginProvidesPrism::isPresent).distinct().forEach(pluginType -> ExternalProvider.addPluginToScope(defaultScope, pluginType, plugins));
        if (defaultScope.pluginProvided().isEmpty()) {
            APContext.logNote("No external plugins detected", new Object[0]);
        }
        ExternalProvider.writePluginProvides(plugins);
    }

    private static void writePluginProvides(Map<String, List<String>> plugins) {
        try (FileWriter pluginWriter = new FileWriter(APContext.getBuildResource("avaje-plugins.csv").toFile());){
            pluginWriter.write("External Plugin Type|Provides");
            for (Map.Entry<String, List<String>> plugin : plugins.entrySet()) {
                pluginWriter.write("\n");
                pluginWriter.write(plugin.getKey());
                pluginWriter.write("|");
                String provides = String.join((CharSequence)",", (Iterable<? extends CharSequence>)plugin.getValue());
                pluginWriter.write(provides.isEmpty() ? " " : provides);
            }
        }
        catch (IOException e) {
            APContext.logWarn("Failed to write avaje-plugins.csv due to %s", e.getMessage());
        }
    }

    private static void addPluginToScope(ScopeInfo defaultScope, TypeElement pluginType, Map<String, List<String>> plugins) {
        String name = pluginType.getQualifiedName().toString();
        ProcessingContext.addExternalInjectSPI(name);
        PluginProvidesPrism prism = PluginProvidesPrism.getInstanceOn(pluginType);
        ArrayList<String> provides = new ArrayList<String>();
        for (TypeMirror typeMirror : prism.value()) {
            defaultScope.pluginProvided(typeMirror.toString());
            provides.add(typeMirror.toString());
        }
        for (String string : prism.providesStrings()) {
            defaultScope.pluginProvided(string);
            provides.add(string);
        }
        for (TypeMirror typeMirror : prism.providesAspects()) {
            String wrapAspect = Util.wrapAspect(typeMirror.toString());
            defaultScope.pluginProvided(wrapAspect);
            provides.add(wrapAspect);
        }
        APContext.logNote("Loaded Plugin: %s", name);
        plugins.put(name, provides);
    }

    static void scanAllAvajeModules(Collection<String> providedTypes) {
        if (!externalMeta.isEmpty()) {
            return;
        }
        Types types = APContext.types();
        TypeMirror avajeModuleType = APContext.typeElement("io.avaje.inject.spi.AvajeModule").asType();
        ExternalProvider.injectExtensions().filter(t -> t.getInterfaces().stream().anyMatch(i -> types.isAssignable((TypeMirror)i, avajeModuleType))).distinct().forEach(otherModule -> ExternalProvider.addOtherModuleProvides(providedTypes, otherModule));
        if (externalMeta.isEmpty()) {
            APContext.logNote("No external modules detected", new Object[0]);
        }
        ExternalProvider.writeModuleDependencies();
    }

    private static void writeModuleDependencies() {
        try (FileWriter moduleWriter = new FileWriter(APContext.getBuildResource("avaje-module-dependencies.csv").toFile());){
            moduleWriter.write("External Module Type|Provides|Requires");
            for (ModuleData avajeModule : ProcessingContext.modules()) {
                moduleWriter.write("\n");
                moduleWriter.write(avajeModule.name());
                moduleWriter.write("|");
                String provides = String.join((CharSequence)",", avajeModule.provides());
                moduleWriter.write(provides.isEmpty() ? " " : provides);
                moduleWriter.write("|");
                String requires = String.join((CharSequence)",", avajeModule.requires());
                moduleWriter.write(requires.isEmpty() ? " " : requires);
            }
        }
        catch (IOException e) {
            APContext.logWarn("Failed to write avaje-module-dependencies.csv due to %s", e.getMessage());
        }
    }

    private static void addOtherModuleProvides(Collection<String> providedTypes, TypeElement otherModule) {
        HashSet provides = new HashSet();
        HashSet requires = new HashSet();
        ElementFilter.methodsIn(otherModule.getEnclosedElements()).stream().map(DependencyMetaPrism::getInstanceOn).filter(Objects::nonNull).map(MetaData::new).forEach(m -> {
            externalMeta.add((MetaData)m);
            provides.addAll(m.autoProvides());
            provides.addAll(m.provides());
            m.dependsOn().stream().filter(d -> !d.isSoftDependency()).map(Dependency::name).forEach(requires::add);
            providedTypes.add(m.key());
            providedTypes.add(m.type());
            providedTypes.addAll(Util.addQualifierSuffix(m.provides(), m.name()));
            providedTypes.addAll(Util.addQualifierSuffix(m.autoProvides(), m.name()));
        });
        String name = otherModule.getQualifiedName().toString();
        APContext.logNote("Detected Module: %s", name);
        ProcessingContext.addModule(new ModuleData(name, List.copyOf(provides), List.copyOf(requires)));
    }

    private static Stream<TypeElement> injectExtensions() {
        List allModules = APContext.elements().getAllModuleElements().stream().filter(m -> !m.getQualifiedName().toString().startsWith("java")).filter(m -> !m.getQualifiedName().toString().startsWith("jdk")).filter(m -> !m.equals(APContext.getProjectModuleElement())).collect(Collectors.toList());
        Types types = APContext.types();
        TypeMirror extensionType = APContext.typeElement("io.avaje.inject.spi.InjectExtension").asType();
        Stream<TypeElement> checkEnclosing = allModules.stream().flatMap(ExternalProvider::getEnclosed).flatMap(ExternalProvider::getEnclosed).map(TypeElement.class::cast).filter(t -> t.getKind() == ElementKind.CLASS).filter(t -> t.getModifiers().contains((Object)Modifier.PUBLIC)).filter(t -> types.isAssignable(t.asType(), extensionType));
        Stream checkDirectives = allModules.stream().flatMap(m -> ElementFilter.providesIn(m.getDirectives()).stream()).filter(ExternalProvider::isInjectExtension).flatMap(p -> p.getImplementations().stream());
        return Stream.concat(checkEnclosing, checkDirectives);
    }

    private static Stream<? extends Element> getEnclosed(Element e) {
        try {
            return e.getEnclosedElements().stream();
        }
        catch (Exception ex) {
            return Stream.of(new Element[0]);
        }
    }

    private static boolean isInjectExtension(ModuleElement.ProvidesDirective p) {
        return "io.avaje.inject.spi.InjectExtension".equals(p.getService().getQualifiedName().toString());
    }
}

