/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.APContext;
import io.avaje.inject.generator.ModuleData;
import io.avaje.inject.generator.ProcessingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class FactoryOrder {
    private final Set<String> moduleNames = new LinkedHashSet<String>();
    private final List<ModuleData> factories = new ArrayList<ModuleData>();
    private final List<FactoryState> queue = new ArrayList<FactoryState>();
    private final List<FactoryState> queueNoDependencies = new ArrayList<FactoryState>();
    private final Map<String, List<String>> unsatisfiedDependencies = new HashMap<String, List<String>>();
    private final Map<String, FactoryList> providesMap = new HashMap<String, FactoryList>();
    private final Set<String> pluginProvided;
    private final List<String> loadedModules = new ArrayList<String>();

    FactoryOrder(Collection<ModuleData> includeModules, Set<String> pluginProvided) {
        includeModules.forEach(m -> {
            this.add((ModuleData)m);
            this.loadedModules.add(m.name());
        });
        this.pluginProvided = pluginProvided;
    }

    void add(ModuleData module) {
        FactoryState factoryState = new FactoryState(module);
        this.providesMap.computeIfAbsent(module.name(), s -> new FactoryList()).add(factoryState);
        this.addFactoryProvides(factoryState, module.provides());
        if (factoryState.isRequiresEmpty()) {
            if (factoryState.explicitlyProvides()) {
                this.push(factoryState);
            } else {
                this.queueNoDependencies.add(factoryState);
            }
        } else {
            this.queue.add(factoryState);
        }
    }

    private void addFactoryProvides(FactoryState factoryState, List<String> list) {
        for (String feature : list) {
            this.providesMap.computeIfAbsent(feature, s -> new FactoryList()).add(factoryState);
        }
    }

    private void push(FactoryState factory) {
        factory.setPushed();
        this.factories.add(factory.factory());
        this.moduleNames.add(factory.factory().name());
    }

    Set<String> orderModules() {
        for (FactoryState factoryState : this.queueNoDependencies) {
            this.push(factoryState);
        }
        this.processQueue();
        return this.moduleNames;
    }

    private void processQueue() {
        int count;
        while ((count = this.processQueuedFactories()) > 0) {
        }
        if (!this.queue.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (FactoryState factory : this.queue) {
                sb.append("Module [").append(factory).append("] has unsatisfied");
                this.unsatisfiedRequires(sb, factory.factory);
            }
            sb.append(" - none of the loaded modules ").append(this.loadedModules).append(" explicitly provide the dependencies.");
            if (ProcessingContext.strictWiring()) {
                APContext.logError(sb.toString(), new Object[0]);
            } else {
                APContext.logNote(sb.toString(), new Object[0]);
            }
        }
    }

    private void unsatisfiedRequires(StringBuilder sb, ModuleData module) {
        for (String depModuleName : module.requires()) {
            if (!this.notProvided(depModuleName)) continue;
            this.unsatisfiedDependencies.computeIfAbsent(module.name(), k -> new ArrayList()).add(depModuleName);
            sb.append(String.format(" requires [%s]", depModuleName));
        }
    }

    private boolean notProvided(String dependency) {
        FactoryList factoryList = this.providesMap.get(dependency);
        return (factoryList == null || !factoryList.allPushed()) && !this.pluginProvided.contains(dependency) && !ProcessingContext.externallyProvided(dependency);
    }

    private int processQueuedFactories() {
        int count = 0;
        Iterator<FactoryState> it = this.queue.iterator();
        while (it.hasNext()) {
            FactoryState factory = it.next();
            if (!this.satisfiedDependencies(factory.requires())) continue;
            it.remove();
            this.push(factory);
            ++count;
        }
        return count;
    }

    private boolean satisfiedDependencies(List<String> requires) {
        for (String dependency : requires) {
            if (!this.notProvided(dependency)) continue;
            return false;
        }
        return true;
    }

    boolean isEmpty() {
        return this.factories.isEmpty();
    }

    Map<String, List<String>> unsatisfied() {
        return this.unsatisfiedDependencies;
    }

    static class FactoryState {
        private final ModuleData factory;
        private boolean pushed;

        FactoryState(ModuleData factory) {
            this.factory = factory;
        }

        void setPushed() {
            this.pushed = true;
        }

        boolean isPushed() {
            return this.pushed;
        }

        ModuleData factory() {
            return this.factory;
        }

        List<String> requires() {
            return this.factory.requires();
        }

        public String toString() {
            return this.factory.getClass().getTypeName();
        }

        boolean isRequiresEmpty() {
            return this.factory.requires().isEmpty();
        }

        boolean explicitlyProvides() {
            return !this.factory.provides().isEmpty();
        }
    }

    static class FactoryList {
        private final List<FactoryState> factories = new ArrayList<FactoryState>();

        FactoryList() {
        }

        void add(FactoryState factory) {
            this.factories.add(factory);
        }

        boolean allPushed() {
            for (FactoryState factory : this.factories) {
                if (factory.isPushed()) continue;
                return false;
            }
            return true;
        }
    }
}

