/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;

final class HttpGeneratedPrism {
    private final String _value;
    public static final String PRISM_TYPE = "io.avaje.http.api.Generated";
    final Values values;
    final boolean isValid;
    final AnnotationMirror mirror;
    private final Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
    private final Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
    private boolean valid = true;

    static boolean isInstance(AnnotationMirror mirror) {
        return HttpGeneratedPrism.getInstance(mirror) != null;
    }

    static boolean isPresent(Element element) {
        return HttpGeneratedPrism.getInstanceOn(element) != null;
    }

    static HttpGeneratedPrism getInstanceOn(Element element) {
        AnnotationMirror mirror = HttpGeneratedPrism.getMirror(element);
        if (mirror == null) {
            return null;
        }
        return HttpGeneratedPrism.getInstance(mirror);
    }

    static Optional<HttpGeneratedPrism> getOptionalOn(Element element) {
        AnnotationMirror mirror = HttpGeneratedPrism.getMirror(element);
        if (mirror == null) {
            return Optional.empty();
        }
        return HttpGeneratedPrism.getOptional(mirror);
    }

    static List<HttpGeneratedPrism> getAllOnMetaAnnotations(Element element) {
        if (element == null || element.getAnnotationMirrors().isEmpty()) {
            return List.of();
        }
        return HttpGeneratedPrism.getAllOnMetaAnnotations(element, new HashSet<String>()).collect(Collectors.toList());
    }

    private static Stream<HttpGeneratedPrism> getAllOnMetaAnnotations(Element element, Set<String> seen) {
        if (element == null || element.getAnnotationMirrors().isEmpty()) {
            return Stream.of(new HttpGeneratedPrism[0]);
        }
        return element.getAnnotationMirrors().stream().map(AnnotationMirror::getAnnotationType).filter(t -> seen.add(t.toString())).map(DeclaredType::asElement).flatMap(e -> Stream.concat(HttpGeneratedPrism.getAllOnMetaAnnotations(e, seen), HttpGeneratedPrism.getMirrors(element).map(HttpGeneratedPrism::getInstance)));
    }

    static HttpGeneratedPrism getInstance(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return null;
        }
        return new HttpGeneratedPrism(mirror);
    }

    static Optional<HttpGeneratedPrism> getOptional(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return Optional.empty();
        }
        return Optional.of(new HttpGeneratedPrism(mirror));
    }

    private HttpGeneratedPrism(AnnotationMirror mirror) {
        for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
            this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
            this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
        }
        this._value = this.getValue("value", String.class);
        this.values = new Values(this.memberValues);
        this.mirror = mirror;
        this.isValid = this.valid;
    }

    public String value() {
        return this._value;
    }

    private <T> T getValue(String name, Class<T> clazz) {
        T result = HttpGeneratedPrism.getValue(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private static AnnotationMirror getMirror(Element target) {
        for (AnnotationMirror annotationMirror : target.getAnnotationMirrors()) {
            Name mfqn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!PRISM_TYPE.contentEquals(mfqn)) continue;
            return annotationMirror;
        }
        return null;
    }

    private static Stream<? extends AnnotationMirror> getMirrors(Element target) {
        return target.getAnnotationMirrors().stream().filter(m -> PRISM_TYPE.contentEquals(((TypeElement)m.getAnnotationType().asElement()).getQualifiedName()));
    }

    private static <T> T getValue(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return null;
        }
        if (clazz.isInstance(av.getValue())) {
            return clazz.cast(av.getValue());
        }
        return null;
    }

    static final class Values {
        private final Map<String, AnnotationValue> values;

        private Values(Map<String, AnnotationValue> values) {
            this.values = values;
        }

        AnnotationValue value() {
            return this.values.get("value");
        }
    }
}

