/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.APContext;
import io.avaje.inject.generator.Append;
import io.avaje.inject.generator.AssistedPrism;
import io.avaje.inject.generator.BeanConditions;
import io.avaje.inject.generator.BeanPrism;
import io.avaje.inject.generator.BeanRequestParams;
import io.avaje.inject.generator.BeanTypesPrism;
import io.avaje.inject.generator.ConditionalWriter;
import io.avaje.inject.generator.Dependency;
import io.avaje.inject.generator.DestroyMethods;
import io.avaje.inject.generator.EventPublisherWriter;
import io.avaje.inject.generator.ImportTypeMap;
import io.avaje.inject.generator.LazyPrism;
import io.avaje.inject.generator.MetaData;
import io.avaje.inject.generator.MethodLifecycleReader;
import io.avaje.inject.generator.ObservesPrism;
import io.avaje.inject.generator.PrimaryPrism;
import io.avaje.inject.generator.ProcessingContext;
import io.avaje.inject.generator.PrototypePrism;
import io.avaje.inject.generator.QualifiedMapPrism;
import io.avaje.inject.generator.SecondaryPrism;
import io.avaje.inject.generator.TypeExtendsInjection;
import io.avaje.inject.generator.TypeReader;
import io.avaje.inject.generator.UType;
import io.avaje.inject.generator.Util;
import io.avaje.inject.generator.UtilType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

final class MethodReader {
    private static final String CODE_COMMENT_BUILD_FACTORYBEAN = "  /**\n   * Create and register %s via factory bean method %s#%s().\n   */";
    private final TypeExtendsInjection factory;
    private final ExecutableElement element;
    private final String factoryType;
    private final String methodName;
    private final boolean prototype;
    private final boolean primary;
    private final boolean secondary;
    private final boolean lazy;
    private final String returnTypeRaw;
    private final UType genericType;
    private final String shortName;
    private final boolean isVoid;
    private final List<MethodParam> params = new ArrayList<MethodParam>();
    private final String factoryShortName;
    private final String initMethod;
    private final String destroyMethod;
    private final Integer destroyPriority;
    private final boolean beanCloseable;
    private final String name;
    private final TypeReader typeReader;
    private final boolean optionalType;
    private final boolean multiRegister;
    private final BeanConditions conditions = new BeanConditions();
    private MethodParam observeParameter;

    MethodReader(ExecutableElement element, TypeElement beanType, ImportTypeMap importTypes) {
        this(null, element, beanType, null, null, importTypes);
    }

    MethodReader(TypeExtendsInjection factory, ExecutableElement element, TypeElement beanType, BeanPrism bean, String qualifierName, ImportTypeMap importTypes) {
        TypeElement returnElement;
        this.factory = factory;
        this.element = element;
        if (bean != null) {
            this.prototype = PrototypePrism.isPresent(element);
            this.primary = PrimaryPrism.isPresent(element);
            this.secondary = SecondaryPrism.isPresent(element);
            this.lazy = LazyPrism.isPresent(element) || LazyPrism.isPresent(element.getEnclosingElement());
            this.conditions.readAll(element);
        } else {
            this.prototype = false;
            this.primary = false;
            this.secondary = false;
            this.lazy = false;
        }
        this.methodName = element.getSimpleName().toString();
        TypeMirror returnMirror = element.getReturnType();
        UType uType = UType.parse(returnMirror);
        String raw = returnMirror.toString();
        if (Util.isOptional(raw)) {
            this.optionalType = true;
            uType = uType.param0();
            this.returnTypeRaw = Util.trimWildcard(uType.full());
            this.multiRegister = false;
        } else if (raw.startsWith("java.util.List")) {
            this.optionalType = false;
            uType = uType.param0();
            this.returnTypeRaw = Util.trimWildcard(uType.full());
            this.multiRegister = true;
        } else {
            this.optionalType = false;
            this.returnTypeRaw = Util.trimWildcard(raw);
            this.multiRegister = false;
        }
        this.genericType = uType;
        String mainType = this.genericType.mainType();
        this.shortName = Util.shortName(mainType);
        this.factoryType = beanType.getQualifiedName().toString();
        this.factoryShortName = Util.shortName(this.factoryType);
        this.isVoid = Util.isVoid(mainType);
        String initMethod = bean == null ? null : bean.initMethod();
        String destroyMethod = bean == null ? null : bean.destroyMethod();
        this.destroyPriority = bean == null ? null : bean.destroyPriority();
        this.beanCloseable = bean != null && bean.autoCloseable() != false;
        this.name = this.multiRegister && qualifierName == null ? "multi" : qualifierName;
        TypeElement typeElement = returnElement = this.multiRegister ? APContext.typeElement(uType.mainType()) : ProcessingContext.asElement(returnMirror);
        if (returnElement == null) {
            this.typeReader = null;
            this.initMethod = initMethod;
            this.destroyMethod = destroyMethod;
        } else {
            Optional<BeanTypesPrism> beantypes = BeanTypesPrism.getOptionalOn(element);
            beantypes.ifPresent(p -> Util.validateBeanTypes(element, p.value()));
            this.typeReader = new TypeReader(beantypes, this.genericType, returnElement, importTypes);
            this.typeReader.process();
            MethodLifecycleReader lifecycleReader = new MethodLifecycleReader(returnElement, initMethod, destroyMethod);
            this.initMethod = lifecycleReader.initMethod();
            this.destroyMethod = lifecycleReader.destroyMethod();
        }
        if (this.lazy && this.prototype) {
            APContext.logError("Cannot use both @Lazy and @Prototype", new Object[0]);
        }
    }

    public String toString() {
        return "MethodReader{element=" + String.valueOf(this.element) + ", params=" + String.valueOf(this.params) + "}";
    }

    void addDependsOnGeneric(Set<UType> set) {
        for (MethodParam param : this.params) {
            param.addDependsOnGeneric(set);
        }
        if (this.genericType.isGeneric()) {
            set.add(this.genericType);
        }
        if (this.typeReader != null) {
            set.addAll(this.typeReader.genericTypes());
        }
    }

    MethodReader read() {
        List<? extends VariableElement> ps = this.element.getParameters();
        for (VariableElement variableElement : ps) {
            this.params.add(new MethodParam(variableElement));
        }
        this.observeParameter = this.params.stream().filter(MethodParam::observeEvent).findFirst().orElse(null);
        return this;
    }

    String name() {
        return this.methodName;
    }

    List<MethodParam> params() {
        return this.params;
    }

    MetaData createMeta() {
        MetaData metaData = new MetaData(this.returnTypeRaw, this.name);
        metaData.setMethod(this.fullBuildMethod());
        ArrayList<String> dependsOn = new ArrayList<String>(this.params.size() + 1);
        dependsOn.add(this.factoryType);
        this.conditions.requireTypes.stream().map(t -> "con:" + t).forEach(dependsOn::add);
        this.conditions.missingTypes.stream().filter(t -> !t.equals(this.returnTypeRaw)).map(t -> "con:" + t).forEach(dependsOn::add);
        for (MethodParam param : this.params) {
            String dep = Util.addQualifierSuffix(param.named, Util.trimWildcard(param.paramType));
            dependsOn.add(dep);
        }
        metaData.setDependsOn(dependsOn);
        metaData.setProvides(this.typeReader == null ? Collections.emptyList() : Util.addQualifierSuffix(this.typeReader.provides(), this.name));
        metaData.setAutoProvides(this.typeReader == null ? List.of() : Util.addQualifierSuffix(this.typeReader.autoProvides(), this.name));
        metaData.setProvidesAspect(this.typeReader == null ? "" : this.typeReader.providesAspect());
        return metaData;
    }

    private String fullBuildMethod() {
        return this.factoryType + "$DI.build_" + this.element.getSimpleName().toString();
    }

    void builderGetFactory(Append writer, boolean factoryHasConditions) {
        if (factoryHasConditions) {
            writer.append("      var factory = builder.getNullable(%s.class);", this.factoryShortName).eol();
            writer.append("      if (factory == null) return;").eol();
        } else {
            writer.append("      var factory = builder.get(%s.class);", this.factoryShortName).eol();
        }
    }

    void builderBuildBean(Append writer) {
        writer.indent("      ");
        if (this.isVoid) {
            writer.append("factory.%s(", this.methodName);
        } else {
            String beanName = this.optionalType ? "optionalBean" : "bean";
            writer.append("var %s = factory.%s(", beanName, this.methodName);
        }
        for (int i = 0; i < this.params.size(); ++i) {
            if (i > 0) {
                writer.append(", ");
            }
            this.params.get(i).builderGetDependency(writer, "builder");
        }
        writer.append(");").eol();
    }

    void builderAddBeanProvider(Append writer) {
        if (this.isVoid) {
            APContext.logError(this.element, "Error - void @Prototype method ?", new Object[0]);
            return;
        }
        if (this.optionalType) {
            APContext.logError(this.element, "Error - Optional type with @Prototype method is not supported", new Object[0]);
            return;
        }
        if (this.multiRegister) {
            APContext.logError(this.element, "Error - List<Provider<>> type with @Prototype method is not supported", new Object[0]);
            return;
        }
        String indent = "    ";
        writer.indent(indent).append("  builder");
        if (this.prototype) {
            writer.append(".asPrototype()");
        } else if (this.secondary) {
            writer.append(".asSecondary()");
        }
        writer.indent(".registerProvider(() -> {").eol();
        this.startTry(writer, "  ");
        writer.indent(indent).append("  return ");
        writer.append("factory.%s(", this.methodName);
        for (int i = 0; i < this.params.size(); ++i) {
            if (i > 0) {
                writer.append(", ");
            }
            this.params.get(i).builderGetDependency(writer, "builder");
        }
        writer.append(");").eol();
        this.endTry(writer, "  ");
        writer.indent(indent).append("  });").eol();
        writer.indent(indent).append("}").eol();
    }

    void builderBuildAddBean(Append writer) {
        if (!this.isVoid) {
            String addPreDestroy;
            String lineEnd;
            boolean hasLifecycleMethods;
            if (this.optionalType) {
                writer.append("      if (optionalBean.isPresent()) {").eol();
                writer.append("        var bean = optionalBean.get();").eol();
            }
            String indent = this.optionalType ? "        " : "      ";
            writer.indent(indent);
            DestroyMethods.DestroyMethod matchedPreDestroyMethod = this.factory.matchPreDestroy(this.returnTypeRaw);
            boolean bl = hasLifecycleMethods = matchedPreDestroyMethod != null || this.hasLifecycleMethods();
            if (hasLifecycleMethods && this.multiRegister) {
                writer.append("bean.stream()").eol().indent(indent).append("    .map(");
            } else if (hasLifecycleMethods) {
                writer.append("var $bean = ");
            } else if (this.multiRegister) {
                writer.append("bean.forEach(");
            }
            writer.append("builder");
            if (this.primary) {
                writer.append(".asPrimary()");
            } else if (this.secondary) {
                writer.append(".asSecondary()");
            } else if (this.prototype) {
                writer.append(".asPrototype()");
            }
            String string = lineEnd = hasLifecycleMethods ? "" : ";";
            if (Util.isProvider(this.returnTypeRaw)) {
                Object providerRegister = this.multiRegister ? "::registerProvider)" + lineEnd : ".registerProvider(bean);";
                writer.append((String)providerRegister).eol();
            } else {
                Object beanRegister = this.multiRegister ? "::register)" + lineEnd : ".register(bean);";
                writer.append((String)beanRegister).eol();
            }
            boolean hasInitMethod = this.notEmpty(this.initMethod);
            if (hasInitMethod) {
                String addPostConstruct = this.multiRegister ? "    .peek($bean -> builder.addPostConstruct($bean::%s))" : "builder.addPostConstruct($bean::%s);";
                writer.indent(indent).append(addPostConstruct, this.initMethod).eol();
            }
            boolean isCloseable = this.typeReader != null && this.typeReader.isClosable();
            String priority = MethodReader.priority(this.destroyPriority);
            if (this.notEmpty(this.destroyMethod)) {
                addPreDestroy = this.multiRegister ? "    .forEach($bean -> builder.addPreDestroy(%s%s));" : "builder.addPreDestroy(%s%s);";
                writer.indent(indent).append(addPreDestroy, MethodReader.addPreDestroy(this.destroyMethod), priority).eol();
            } else if (isCloseable && !priority.isBlank()) {
                addPreDestroy = this.multiRegister ? "    .forEach($bean -> builder.addPreDestroy($bean::close%s));" : "builder.addPreDestroy($bean::close%s);";
                writer.indent(indent).append(addPreDestroy, priority).eol();
            } else if (isCloseable || this.beanCloseable) {
                String addAutoClosable = this.multiRegister ? "    .forEach(builder::addAutoClosable);" : "builder.addAutoClosable(bean);";
                writer.indent(indent).append(addAutoClosable).eol();
            } else if (this.multiRegister && hasInitMethod) {
                writer.indent(indent).append("    .forEach(x -> {});").eol();
            }
            if (matchedPreDestroyMethod != null) {
                addPreDestroy = this.multiRegister ? "    .forEach($bean -> builder.addPreDestroy(%s%s));" : "builder.addPreDestroy(%s%s);";
                String methodPriority = MethodReader.priority(matchedPreDestroyMethod.priority());
                String method = String.format("() -> factory.%s($bean)", matchedPreDestroyMethod.method());
                writer.indent(indent).append(addPreDestroy, method, methodPriority).eol();
            }
            if (this.optionalType) {
                writer.append("      }").eol();
            }
        }
    }

    static String priority(Integer priority) {
        return priority == null || priority == 1000 ? "" : ", " + priority;
    }

    static String addPreDestroy(String destroyMethod) {
        if (!destroyMethod.contains(".")) {
            return "$bean::" + destroyMethod;
        }
        return "() -> $bean." + destroyMethod;
    }

    private boolean hasLifecycleMethods() {
        return this.notEmpty(this.initMethod) || this.notEmpty(this.destroyMethod) || this.typeReader != null && this.typeReader.isClosable() || this.beanCloseable;
    }

    private boolean notEmpty(String value) {
        return value != null && !value.isEmpty();
    }

    void addImports(ImportTypeMap importTypes) {
        for (MethodParam param : this.params) {
            param.addImports(importTypes);
        }
        if (this.optionalType) {
            importTypes.add("java.util.Optional");
        }
        this.conditions.addImports(importTypes);
    }

    Set<UType> genericTypes() {
        return this.typeReader == null ? Collections.emptySet() : this.typeReader.genericTypes();
    }

    void buildConditional(Append writer) {
        new ConditionalWriter(writer, this.conditions).write();
    }

    void buildAddFor(Append writer) {
        writer.append("    if (builder.isBeanAbsent(");
        if (this.isVoid) {
            writer.append("Void.class");
        } else {
            if (this.name != null && !this.name.isEmpty()) {
                writer.append("\"%s\", ", this.name);
            }
            if (this.typeReader != null) {
                writer.append(this.typeReader.typesRegister());
            }
        }
        writer.append(")) {").eol();
    }

    boolean methodThrows() {
        return !this.element.getThrownTypes().isEmpty();
    }

    void startTry(Append writer) {
        this.startTry(writer, "");
    }

    void startTry(Append writer, String indent) {
        if (this.methodThrows()) {
            writer.append(indent).append("      try {").eol();
            writer.setExtraIndent("  " + indent);
        }
    }

    void endTry(Append writer) {
        this.endTry(writer, "");
    }

    void endTry(Append writer, String indent) {
        if (this.methodThrows()) {
            writer.setExtraIndent(null);
            writer.append(indent).append("      } catch (Throwable e) {").eol();
            writer.append(indent).append("        throw new RuntimeException(\"Error during wiring\", e);").eol();
            writer.append(indent).append("      }").eol();
        }
    }

    void checkRequest(BeanRequestParams requestParams) {
        for (MethodParam param : this.params) {
            param.checkRequest(requestParams);
        }
    }

    void writeRequestDependency(Append writer) {
        for (MethodParam param : this.params) {
            param.writeRequestDependency(writer);
        }
    }

    void writeRequestConstructor(Append writer) {
        for (MethodParam param : this.params) {
            param.writeRequestConstructor(writer);
        }
    }

    void commentBuildMethod(Append writer) {
        writer.append(CODE_COMMENT_BUILD_FACTORYBEAN, this.shortName, this.factoryShortName, this.methodName).eol();
    }

    boolean isProtoType() {
        return this.prototype && !Util.isProvider(this.returnTypeRaw);
    }

    boolean isLazy() {
        return this.lazy;
    }

    boolean isUseProviderForSecondary() {
        return this.secondary && !this.optionalType && !Util.isProvider(this.returnTypeRaw);
    }

    boolean isPublic() {
        return this.element.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    boolean isNotPrivate() {
        return !this.element.getModifiers().contains((Object)Modifier.PRIVATE);
    }

    void writeConstructorParams(Append writer) {
        for (MethodParam param : this.params) {
            writer.append(", ");
            param.writeMethodParam(writer);
        }
    }

    void writeConstructorInit(Append writer) {
        int size = this.params.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                writer.append(", ");
            }
            this.params.get(i).writeConstructorInit(writer);
        }
    }

    void removeFromProvides(List<UType> provides) {
        for (MethodParam param : this.params) {
            param.removeFromProvides(provides);
        }
    }

    ExecutableElement element() {
        return this.element;
    }

    MethodParam observeParam() {
        return this.observeParameter;
    }

    static class MethodParam {
        private final VariableElement element;
        private final String named;
        private final UtilType utilType;
        private final String paramType;
        private final UType genericType;
        private final UType fullUType;
        private final boolean nullable;
        private final String simpleName;
        private boolean requestParam;
        private String requestParamName;
        private final boolean isBeanMap;
        private final boolean isAssisted;
        private final boolean isObserveEvent;

        MethodParam(VariableElement param) {
            this.element = param;
            this.simpleName = param.getSimpleName().toString();
            this.named = Util.named(param);
            this.nullable = Util.isNullable(param);
            this.isBeanMap = QualifiedMapPrism.isPresent(param);
            this.utilType = Util.determineType(param.asType(), this.isBeanMap);
            this.paramType = this.utilType.rawType(this.isBeanMap);
            this.genericType = this.utilType.toUType();
            this.fullUType = UType.parse(param.asType());
            this.isAssisted = AssistedPrism.isPresent(param);
            this.isObserveEvent = ObservesPrism.isPresent(param);
            if (this.nullable || param.asType().toString().startsWith("java.util.Optional<")) {
                ProcessingContext.addOptionalType(this.paramType, this.named);
            }
            if (this.fullUType.fullWithoutAnnotations().startsWith("io.avaje.inject.events.Event")) {
                EventPublisherWriter.write(param);
            }
        }

        public String toString() {
            return "MethodParam{" + String.valueOf(this.fullUType) + "}";
        }

        void addDependsOnGeneric(Set<UType> set) {
            if (this.genericType.isGeneric() && !Util.isProvider(this.genericType.mainType())) {
                set.add(this.genericType);
            }
        }

        void builderGetDependency(Append writer, String builderName) {
            writer.append(builderName).append(".").append(this.utilType.getMethod(this.nullable, this.isBeanMap));
            if (!this.genericType.isGeneric() || this.genericType.param0().kind() == TypeKind.WILDCARD) {
                writer.append(Util.shortName(this.genericType.mainType())).append(".class");
            } else {
                writer.append("TYPE_").append(Util.shortName(this.genericType).replace(".", "_"));
            }
            if (this.named != null && !this.named.isEmpty()) {
                writer.append(",\"").append(this.named).append("\"");
            } else if (!this.isGenericParam() && this.utilType.allowsNamedQualifier()) {
                writer.append(",\"!");
                String shortName = Util.shortName(this.paramType);
                if (this.simpleName.endsWith(shortName)) {
                    writer.append(this.simpleName, 0, this.simpleName.length() - shortName.length());
                } else {
                    writer.append(this.simpleName);
                }
                writer.append("\"");
            }
            writer.append(")");
        }

        String simpleName() {
            return this.simpleName;
        }

        boolean isProvider() {
            return Util.isProvider(this.paramType);
        }

        boolean isGenericType() {
            return this.genericType.isGeneric();
        }

        boolean isGenericParam() {
            return this.isGenericType() && !this.isProvider();
        }

        Dependency dependsOn() {
            return new Dependency(this.paramType, this.named, this.utilType.isCollection());
        }

        void addImports(ImportTypeMap importTypes) {
            if (this.isObserveEvent) {
                importTypes.add("java.util.function.Consumer");
                importTypes.add("io.avaje.inject.events.Observer");
                importTypes.add("io.avaje.inject.events.ObserverManager");
            }
            importTypes.addAll(this.fullUType.importTypes());
            Util.nullableAnnotation(this.element).map(Object::toString).ifPresent(importTypes::add);
        }

        void checkRequest(BeanRequestParams requestParams) {
            this.requestParam = requestParams.check(this.paramType);
            if (this.requestParam) {
                this.requestParamName = requestParams.argumentName(this.paramType);
            }
        }

        void writeRequestDependency(Append writer) {
            if (!this.requestParam) {
                this.requestParamName = writer.nextName(Util.trimmedName(this.genericType));
                writer.append("  @Inject").eol();
                writer.append("  ");
                writer.append(this.genericType.shortWithoutAnnotations());
                writer.append(" %s;", this.requestParamName).eol().eol();
            }
        }

        void writeRequestConstructor(Append writer) {
            writer.commaAppend(this.requestParamName);
        }

        void writeMethodParam(Append writer) {
            if (this.nullable) {
                writer.append("@Nullable ");
            }
            if (this.genericType.isGeneric()) {
                writer.append(this.genericType.shortWithoutAnnotations());
            } else {
                writer.append(Util.shortName(this.genericType.mainType()));
            }
            writer.append(" ").append(this.simpleName);
        }

        void writeMethodParamAspect(Append writer) {
            if (this.fullUType.isGeneric()) {
                writer.append(this.fullUType.shortWithoutAnnotations());
            } else {
                writer.append(Util.shortName(this.fullUType.mainType()));
            }
            writer.append(" ").append(this.simpleName);
        }

        void writeMethodParamTypeAspect(Append writer) {
            writer.append(Util.shortName(this.fullUType.mainType()));
        }

        void writeConstructorInit(Append writer) {
            writer.append(this.simpleName);
        }

        void removeFromProvides(List<UType> provides) {
            provides.remove(this.genericType);
        }

        boolean assisted() {
            return this.isAssisted;
        }

        boolean observeEvent() {
            return this.isObserveEvent;
        }

        Element element() {
            return this.element;
        }

        UType getFullUType() {
            return this.fullUType;
        }

        String qualifier() {
            return this.named != null ? this.named : "";
        }
    }
}

