/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

final class PluginProvidesPrism {
    private final List<TypeMirror> _value;
    private final List<String> _providesStrings;
    private final List<TypeMirror> _providesAspects;
    public static final String PRISM_TYPE = "io.avaje.inject.spi.PluginProvides";
    final Values values;
    final boolean isValid;
    final AnnotationMirror mirror;
    private final Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
    private final Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
    private boolean valid = true;

    static boolean isInstance(AnnotationMirror mirror) {
        return PluginProvidesPrism.getInstance(mirror) != null;
    }

    static boolean isPresent(Element element) {
        return PluginProvidesPrism.getInstanceOn(element) != null;
    }

    static PluginProvidesPrism getInstanceOn(Element element) {
        AnnotationMirror mirror = PluginProvidesPrism.getMirror(element);
        if (mirror == null) {
            return null;
        }
        return PluginProvidesPrism.getInstance(mirror);
    }

    static Optional<PluginProvidesPrism> getOptionalOn(Element element) {
        AnnotationMirror mirror = PluginProvidesPrism.getMirror(element);
        if (mirror == null) {
            return Optional.empty();
        }
        return PluginProvidesPrism.getOptional(mirror);
    }

    static PluginProvidesPrism getInstance(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return null;
        }
        return new PluginProvidesPrism(mirror);
    }

    static Optional<PluginProvidesPrism> getOptional(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return Optional.empty();
        }
        return Optional.of(new PluginProvidesPrism(mirror));
    }

    private PluginProvidesPrism(AnnotationMirror mirror) {
        for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
            this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
            this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
        }
        this._value = this.getArrayValues("value", TypeMirror.class);
        this._providesStrings = this.getArrayValues("providesStrings", String.class);
        this._providesAspects = this.getArrayValues("providesAspects", TypeMirror.class);
        this.values = new Values(this.memberValues);
        this.mirror = mirror;
        this.isValid = this.valid;
    }

    public List<TypeMirror> value() {
        return this._value;
    }

    public List<String> providesStrings() {
        return this._providesStrings;
    }

    public List<TypeMirror> providesAspects() {
        return this._providesAspects;
    }

    private <T> T getValue(String name, Class<T> clazz) {
        T result = PluginProvidesPrism.getValue(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private <T> List<T> getArrayValues(String name, Class<T> clazz) {
        List<T> result = PluginProvidesPrism.getArrayValues(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private static AnnotationMirror getMirror(Element target) {
        for (AnnotationMirror annotationMirror : target.getAnnotationMirrors()) {
            Name mfqn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!PRISM_TYPE.contentEquals(mfqn)) continue;
            return annotationMirror;
        }
        return null;
    }

    private static <T> T getValue(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return null;
        }
        if (clazz.isInstance(av.getValue())) {
            return clazz.cast(av.getValue());
        }
        return null;
    }

    private static <T> List<T> getArrayValues(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return List.of();
        }
        if (av.getValue() instanceof List) {
            ArrayList<T> result = new ArrayList<T>();
            for (AnnotationValue v : PluginProvidesPrism.getValueAsList(av)) {
                if (clazz.isInstance(v.getValue())) {
                    result.add(clazz.cast(v.getValue()));
                    continue;
                }
                return List.of();
            }
            return result;
        }
        return List.of();
    }

    private static List<AnnotationValue> getValueAsList(AnnotationValue av) {
        return (List)av.getValue();
    }

    static final class Values {
        private final Map<String, AnnotationValue> values;

        private Values(Map<String, AnnotationValue> values) {
            this.values = values;
        }

        AnnotationValue value() {
            return this.values.get("value");
        }

        AnnotationValue providesStrings() {
            return this.values.get("providesStrings");
        }

        AnnotationValue providesAspects() {
            return this.values.get("providesAspects");
        }
    }
}

