/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.APContext;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import javax.lang.model.element.ModuleElement;

final class PomPluginWriter {
    private static final String plugin = "  <!-- generated by avaje inject -->\n      <plugin>\n        <groupId>io.avaje</groupId>\n        <artifactId>avaje-inject-maven-plugin</artifactId>\n        <version>%s</version>\n        <executions>\n          <execution>\n            <phase>process-sources</phase>\n            <goals>\n              <goal>provides</goal>\n            </goals>\n          </execution>\n        </executions>\n      </plugin>\n    ";

    PomPluginWriter() {
    }

    static void addPlugin2Pom() throws IOException {
        ModuleElement module = APContext.getProjectModuleElement();
        if (PomPluginWriter.disabledOrUsingModulePath(module)) {
            return;
        }
        Path pomPath = APContext.getBuildResource("").getParent().resolve("pom.xml");
        if (!pomPath.toFile().exists()) {
            return;
        }
        String pomContent = Files.readString(pomPath);
        if (pomContent.contains("avaje-inject-maven-plugin") || !pomContent.contains("<annotationProcessors>") && !pomContent.contains("<annotationProcessorPaths>")) {
            return;
        }
        APContext.logNote("Adding avaje-inject-maven-plugin Plugin to pom", new Object[0]);
        int pluginsIndex = pomContent.indexOf("</plugins>");
        StringBuilder builder = new StringBuilder(pomContent);
        if (pluginsIndex != -1) {
            builder.insert(pluginsIndex, String.format(plugin, PomPluginWriter.class.getPackage().getImplementationVersion()));
            Files.writeString(pomPath, (CharSequence)builder.toString(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        }
    }

    private static boolean disabledOrUsingModulePath(ModuleElement module) {
        return APContext.getOption("buildPlugin").map(Boolean::valueOf).orElse(true) == false || module != null && !module.isUnnamed();
    }
}

