/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.APContext;
import io.avaje.inject.generator.Append;
import io.avaje.inject.generator.AspectMethod;
import io.avaje.inject.generator.BeanAspects;
import io.avaje.inject.generator.BeanReader;
import io.avaje.inject.generator.ProcessorUtils;
import io.avaje.inject.generator.Util;
import java.io.IOException;
import java.io.Writer;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;

final class SimpleBeanProxyWriter {
    private final BeanReader beanReader;
    private final String originName;
    private final String suffix;
    private final String shortName;
    private final String packageName;
    private final BeanAspects aspects;
    private Append writer;

    SimpleBeanProxyWriter(BeanReader beanReader) {
        this.beanReader = beanReader;
        TypeElement origin = beanReader.beanType();
        this.originName = origin.getQualifiedName().toString();
        this.shortName = origin.getSimpleName().toString();
        this.packageName = ProcessorUtils.packageOf(this.originName);
        this.suffix = "$Proxy";
        this.aspects = beanReader.aspects();
    }

    void write() throws IOException {
        this.writer = new Append(this.createFileWriter());
        this.writePackage();
        this.writeImports();
        this.writeClassStart();
        this.writeFields();
        this.writeConstructor();
        this.writeMethods();
        this.writeClassEnd();
        this.writer.close();
    }

    private void writeMethods() {
        for (AspectMethod method : this.aspects.methods()) {
            method.writeMethod(this.writer);
        }
    }

    private void writeFields() {
        for (AspectMethod method : this.aspects.methods()) {
            method.writeSetupFields(this.writer);
        }
        this.writer.eol();
    }

    private void writeConstructor() {
        this.writer.append("  public %s%s(", this.shortName, this.suffix);
        int count = 0;
        for (String aspectName : this.aspects.aspectNames()) {
            if (count++ > 0) {
                this.writer.append(", ");
            }
            String type = "AspectProvider<" + aspectName + ">";
            String name = Util.initLower(aspectName);
            this.writer.append(type).append(" ").append(name);
        }
        this.beanReader.writeConstructorParams(this.writer);
        this.writer.append(") {").eol();
        this.beanReader.writeConstructorInit(this.writer);
        this.writeSetupForMethods();
        this.writer.append("  }").eol();
    }

    private void writeSetupForMethods() {
        this.writer.append("    try {").eol();
        this.writer.append("      var target$Class = %s.class;", this.shortName).eol();
        for (AspectMethod method : this.aspects.methods()) {
            method.writeSetupForMethods(this.writer);
        }
        this.writer.append("    } catch (Exception e) {").eol();
        this.writer.append("      throw new IllegalStateException(e);").eol();
        this.writer.append("    }").eol();
    }

    private void writePackage() {
        if (this.packageName != null) {
            this.writer.append("package %s;", this.packageName).eol().eol();
        }
    }

    private void writeImports() {
        this.writer.append("import %s;", "java.lang.reflect.Method").eol();
        this.writer.append("import %s;", "io.avaje.inject.aop.Invocation").eol();
        this.writer.append("import %s;", "io.avaje.inject.aop.InvocationException").eol();
        this.writer.append("import %s;", "io.avaje.inject.aop.MethodInterceptor").eol();
        this.writer.append("import %s;", "io.avaje.inject.spi.Proxy").eol();
        this.beanReader.writeImports(this.writer, this.packageName);
    }

    private void writeClassEnd() {
        this.writer.append("}").eol();
    }

    private void writeClassStart() {
        this.writer.append("@Proxy").eol();
        this.writer.append("@Generated(\"io.avaje.inject.generator\")").eol();
        this.writer.append("public final class %s%s extends %s {", this.shortName, this.suffix, this.shortName).eol().eol();
    }

    private Writer createFileWriter() throws IOException {
        JavaFileObject jfo = APContext.createSourceFile(this.originName + this.suffix, new Element[0]);
        return jfo.openWriter();
    }
}

