/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.APContext;
import io.avaje.inject.generator.Append;
import io.avaje.inject.generator.ProcessingContext;
import io.avaje.inject.generator.ScopeInfo;
import io.avaje.inject.generator.Util;
import java.io.IOException;
import java.util.Set;
import javax.lang.model.element.Element;

final class SimpleOrderWriter {
    private final String modulePackage;
    private final String shortName;
    private final String fullName;
    private final Set<String> ordering;
    private Append writer;

    SimpleOrderWriter(Set<String> orderedModules, ScopeInfo scopeInfo) {
        this.ordering = orderedModules;
        this.modulePackage = scopeInfo.modulePackage();
        this.shortName = "CompiledOrder";
        this.fullName = this.modulePackage + "." + this.shortName;
    }

    void write() throws IOException {
        this.writer = new Append(APContext.createSourceFile(this.fullName, new Element[0]).openWriter());
        this.writePackage();
        this.writeStartClass();
        this.writeBuildMethods();
        this.writer.close();
        this.writeServicesFile();
    }

    private void writeServicesFile() {
        ProcessingContext.addInjectSPI(this.fullName);
    }

    private void writePackage() {
        this.writer.append("package %s;", this.modulePackage).eol().eol();
        this.writer.append("import static java.util.Map.entry;\n\nimport java.util.List;\nimport java.util.Map;\nimport java.util.Set;\nimport io.avaje.inject.spi.Generated;\nimport io.avaje.inject.spi.ModuleOrdering;\nimport io.avaje.inject.spi.AvajeModule;").eol();
        this.writer.eol();
    }

    private void writeStartClass() {
        this.writer.append("/**\n * Ordering of modules based on module provides and requires dependencies.\n * Refer to target/avaje-module-dependencies.csv for details.\n */\n");
        this.writer.append("@Generated(\"io.avaje.inject.generator\")").eol();
        this.writer.append("public final %sclass %s implements ModuleOrdering {", Util.valhalla(), this.shortName).eol().eol();
        this.writer.append("  private final AvajeModule[] sortedModules = new AvajeModule[%s];", this.ordering.size()).eol();
        this.writer.append("  private static final Map<String, Integer> INDEXES = Map.ofEntries(").eol();
        int size = this.ordering.size();
        int count = 0;
        for (String moduleName : this.ordering) {
            this.writer.append("    entry(\"%s\", %s)", moduleName, count);
            if (++count < size) {
                this.writer.append(",").eol();
                continue;
            }
            this.writer.append(");").eol();
        }
    }

    private void writeBuildMethods() {
        this.writer.append("\n  @Override\n  public boolean supportsExpected(List<AvajeModule> modules) {\n    if (modules.size() != sortedModules.length) {\n      return false;\n    }\n    return modules.stream()\n            .map(m -> m.getClass().getTypeName())\n            .allMatch(k -> INDEXES.containsKey(k));\n  }\n\n  @Override\n  public List<AvajeModule> factories() {\n    return List.of(sortedModules);\n  }\n\n  @Override\n  public Set<String> orderModules() {\n    return INDEXES.keySet();\n  }\n\n  @Override\n  public void add(AvajeModule module) {\n    final var index = INDEXES.get(module.getClass().getTypeName());\n    if (index != null) {\n      sortedModules[index] = module;\n    }\n  }\n\n  @Override\n  public boolean isEmpty() {\n    return sortedModules.length == 0;\n  }\n}");
    }
}

