/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.ImportTypeMap;
import io.avaje.inject.generator.UType;
import io.avaje.inject.generator.Util;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.lang.model.type.TypeKind;

final class TypeAppender {
    private final ImportTypeMap importTypes;
    private final Set<String> types = new LinkedHashSet<String>();
    private final Set<UType> genericTypes = new LinkedHashSet<UType>();

    TypeAppender(ImportTypeMap importTypes) {
        this.importTypes = importTypes;
    }

    void add(UType utype) {
        UType type = Util.unwrapProvider(utype);
        if (TypeAppender.isAddGenericType(type)) {
            this.addUType(type);
        } else {
            this.addSimpleType(type.mainType());
        }
    }

    private static boolean isAddGenericType(UType type) {
        List<UType> components = type.componentTypes();
        return type.isGeneric() && type.kind() != TypeKind.TYPEVAR && (components.size() != 1 || components.get(0).kind() != TypeKind.WILDCARD) && components.stream().flatMap(TypeAppender::allComponentTypes).noneMatch(u -> u.kind() == TypeKind.TYPEVAR || u.kind() == TypeKind.WILDCARD);
    }

    private static Stream<UType> allComponentTypes(UType u) {
        List<UType> componentTypes = u.componentTypes();
        return componentTypes.isEmpty() ? Stream.of(u) : Stream.concat(Stream.of(u), componentTypes.stream().flatMap(TypeAppender::allComponentTypes));
    }

    void add(List<UType> sourceTypes) {
        sourceTypes.forEach(this::add);
    }

    void addSimpleType(String classType) {
        String shortName = this.importTypes.add(classType);
        this.types.add(shortName + ".class");
    }

    private void addUType(UType genericType) {
        this.genericTypes.add(genericType);
        this.types.add("TYPE_" + Util.shortName(genericType).replace(".", "_"));
    }

    Set<UType> genericTypes() {
        return this.genericTypes;
    }

    String asString() {
        int count = 0;
        StringBuilder sb = new StringBuilder();
        for (String type : this.types) {
            if (count++ > 0) {
                sb.append(", ");
            }
            sb.append(type);
        }
        return sb.toString();
    }
}

