/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.APContext;
import io.avaje.inject.generator.BeanAspects;
import io.avaje.inject.generator.ClientPrism;
import io.avaje.inject.generator.ControllerPrism;
import io.avaje.inject.generator.FactoryPrism;
import io.avaje.inject.generator.FieldReader;
import io.avaje.inject.generator.HttpGeneratedPrism;
import io.avaje.inject.generator.ImportTypeMap;
import io.avaje.inject.generator.MethodReader;
import io.avaje.inject.generator.ProcessingContext;
import io.avaje.inject.generator.ProxyPrism;
import io.avaje.inject.generator.TypeExtendsInjection;
import io.avaje.inject.generator.UType;
import io.avaje.inject.generator.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

final class TypeExtendsReader {
    private static final Set<String> ROUTE_TYPES = Set.of("io.avaje.http.api.AvajeJavalinPlugin", "io.helidon.webserver.http.HttpFeature");
    private final UType baseUType;
    private final TypeElement baseType;
    private final TypeExtendsInjection extendsInjection;
    private final List<UType> extendsTypes = new ArrayList<UType>();
    private final List<UType> interfaceTypes = new ArrayList<UType>();
    private final List<UType> providesTypes = new ArrayList<UType>();
    private final String beanSimpleName;
    private final boolean baseTypeIsInterface;
    private final boolean publicAccess;
    private final boolean autoProvide;
    private final boolean proxyBean;
    private final boolean controller;
    private boolean closeable;
    private String qualifierName;
    private String providesAspect = "";

    TypeExtendsReader(UType baseUType, TypeElement baseType, boolean factory, ImportTypeMap importTypes, boolean proxyBean) {
        this.baseUType = baseUType;
        this.baseType = baseType;
        this.extendsInjection = new TypeExtendsInjection(baseType, factory, importTypes);
        this.beanSimpleName = baseType.getSimpleName().toString();
        this.baseTypeIsInterface = baseType.getKind() == ElementKind.INTERFACE;
        this.publicAccess = baseType.getModifiers().contains((Object)Modifier.PUBLIC);
        this.proxyBean = proxyBean;
        this.controller = ControllerPrism.isPresent(baseType);
        this.closeable = this.closeableClient(baseType);
        this.autoProvide = this.autoProvide();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean closeableClient(TypeElement baseType) {
        if (!ClientPrism.isPresent(baseType)) return false;
        if (!Optional.ofNullable(APContext.typeElement("io.avaje.http.client.HttpClient")).map(TypeElement::getInterfaces).stream().flatMap(Collection::stream).map(Object::toString).anyMatch(AutoCloseable.class.getCanonicalName()::equals)) return false;
        return true;
    }

    private boolean autoProvide() {
        return this.publicAccess && !this.controller && !FactoryPrism.isPresent(this.baseType) && !ProxyPrism.isPresent(this.baseType);
    }

    UType baseType() {
        return this.baseUType;
    }

    String qualifierName() {
        return this.qualifierName;
    }

    BeanAspects hasAspects() {
        return this.extendsInjection.hasAspects();
    }

    List<FieldReader> injectFields() {
        return this.extendsInjection.injectFields();
    }

    List<MethodReader> injectMethods() {
        return this.extendsInjection.injectMethods();
    }

    List<MethodReader> factoryMethods() {
        return this.extendsInjection.factoryMethods();
    }

    List<MethodReader> observerMethods() {
        return this.extendsInjection.observerMethods();
    }

    Optional<MethodReader> postConstructMethod() {
        return this.extendsInjection.postConstructMethod();
    }

    Element preDestroyMethod() {
        return this.extendsInjection.preDestroyMethod();
    }

    Integer preDestroyPriority() {
        return this.extendsInjection.preDestroyPriority();
    }

    MethodReader constructor() {
        return this.extendsInjection.constructor();
    }

    String providesAspect() {
        return this.providesAspect;
    }

    List<UType> autoProvides() {
        if (this.controller || this.implementsBeanFactory()) {
            return List.of();
        }
        if (HttpGeneratedPrism.isPresent(this.baseType)) {
            return this.providesTypes.stream().filter(ut -> ROUTE_TYPES.contains(ut.mainType())).collect(Collectors.toList());
        }
        if (this.baseTypeIsInterface) {
            return List.of(Util.unwrapProvider(this.baseUType));
        }
        ArrayList<UType> autoProvides = new ArrayList<UType>(this.interfaceTypes);
        autoProvides.addAll(this.extendsTypes);
        if (!this.autoProvide || !this.providesAspect.isEmpty()) {
            autoProvides.remove(this.baseUType);
        } else {
            autoProvides.add(Util.unwrapProvider(this.baseUType));
        }
        return autoProvides;
    }

    private boolean implementsBeanFactory() {
        for (UType interfaceType : this.interfaceTypes) {
            if (!"io.avaje.inject.spi.BeanFactory".equals(interfaceType.mainType())) continue;
            return true;
        }
        return false;
    }

    List<UType> provides() {
        return this.providesTypes;
    }

    boolean isCloseable() {
        return this.closeable;
    }

    void process(boolean forBean) {
        this.extendsTypes.add(this.baseUType);
        if (forBean) {
            this.extendsInjection.read(this.baseType);
        }
        this.readInterfaces(this.baseType);
        TypeMirror superMirror = this.baseType.getSuperclass();
        TypeElement superElement = ProcessingContext.asElement(superMirror);
        if (superElement != null) {
            String superName;
            String baseName;
            if (this.qualifierName == null && (baseName = this.baseType.getSimpleName().toString()).endsWith(superName = superElement.getSimpleName().toString())) {
                this.qualifierName = baseName.substring(0, baseName.length() - superName.length());
            }
            this.addSuperType(superElement, superMirror, this.proxyBean);
        }
        this.providesTypes.addAll(this.extendsTypes);
        this.providesTypes.addAll(this.interfaceTypes);
        this.providesTypes.remove(this.baseUType);
        this.extendsInjection.removeFromProvides(this.providesTypes);
        this.providesAspect = this.initProvidesAspect();
    }

    private String initProvidesAspect() {
        for (UType type : this.providesTypes) {
            String providesType = type.full();
            if (!Util.isAspectProvider(providesType)) continue;
            return Util.extractAspectType(providesType);
        }
        return "";
    }

    private void addSuperType(TypeElement element, TypeMirror mirror, boolean proxyBean) {
        this.readInterfaces(element);
        String fullName = mirror.toString();
        if (Util.notJavaLang(fullName)) {
            TypeMirror superMirror;
            TypeElement superElement;
            String type = Util.unwrapProvider(fullName);
            if (proxyBean || this.isPublic(element)) {
                UType genericType = !Objects.equals(fullName, type) ? UType.parse(mirror).param0() : UType.parse(mirror);
                boolean knownType = genericType.componentTypes().stream().flatMap(g -> Stream.concat(Stream.of(g), g.componentTypes().stream())).noneMatch(g -> g.kind() == TypeKind.TYPEVAR);
                this.extendsTypes.add(knownType ? Util.unwrapProvider(mirror) : genericType);
                this.extendsInjection.read(element);
            }
            if ((superElement = ProcessingContext.asElement(superMirror = element.getSuperclass())) != null) {
                this.addSuperType(superElement, superMirror, false);
            }
        }
    }

    private void readInterfaces(TypeElement type) {
        if (Util.notJavaLang(type.getQualifiedName().toString())) {
            for (TypeMirror typeMirror : type.getInterfaces()) {
                if (!this.isPublic(ProcessingContext.asElement(typeMirror))) continue;
                this.readInterfacesOf(typeMirror);
            }
        }
    }

    private void readInterfacesOf(TypeMirror anInterface) {
        String rawType = Util.unwrapProvider(anInterface.toString());
        UType rawUType = Util.unwrapProvider(anInterface);
        if ("java.lang.AutoCloseable".equals(rawType) || "java.io.Closeable".equals(rawType)) {
            this.closeable = true;
        } else if (Util.notJavaLang(rawType)) {
            if (rawType.indexOf(46) == -1) {
                APContext.logWarn("skip when no package on interface %s", rawType);
            } else {
                String mainType;
                String string;
                if (this.qualifierName == null && this.beanSimpleName.endsWith(string = Util.shortName(mainType = rawUType.mainType()))) {
                    this.qualifierName = this.beanSimpleName.substring(0, this.beanSimpleName.length() - string.length());
                }
                this.interfaceTypes.add(rawUType);
                for (TypeMirror typeMirror : APContext.types().directSupertypes(anInterface)) {
                    this.readInterfacesOf(typeMirror);
                }
            }
        }
    }

    private boolean isPublic(Element element) {
        return element != null && element.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    void validate() {
        this.extendsInjection.validate();
    }
}

