/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.APContext;
import java.util.Objects;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;

final class AnnotationUtil {
    AnnotationUtil() {
    }

    static boolean hasAnnotationWithName(Element element, String matchShortName) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!matchShortName.equals(AnnotationUtil.shortName(annotationMirror.getAnnotationType().asElement()))) continue;
            return true;
        }
        if (element instanceof ExecutableElement) {
            return AnnotationUtil.annotatedSuperMethod((ExecutableElement)element, matchShortName);
        }
        return false;
    }

    private static String shortName(Element element) {
        return element.getSimpleName().toString();
    }

    private static boolean annotatedSuperMethod(ExecutableElement element, Object matchShortName) {
        Name methodName = element.getSimpleName();
        Types types = APContext.types();
        return types.directSupertypes(element.getEnclosingElement().asType()).stream().filter(type -> !type.toString().contains("java.lang.Object")).map(superType -> {
            TypeElement superClass = (TypeElement)types.asElement((TypeMirror)superType);
            for (ExecutableElement method : ElementFilter.methodsIn(superClass.getEnclosedElements())) {
                if (!AnnotationUtil.matchNameAndParams(element, method, methodName)) continue;
                return method;
            }
            return null;
        }).filter(Objects::nonNull).flatMap(m -> APContext.elements().getAllAnnotationMirrors((Element)m).stream()).anyMatch(m -> matchShortName.equals(AnnotationUtil.shortName(m.getAnnotationType().asElement())));
    }

    private static boolean matchNameAndParams(ExecutableElement element, ExecutableElement method, Name methodName) {
        return method.getSimpleName().contentEquals(methodName) && method.getParameters().size() == element.getParameters().size();
    }
}

