/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.APContext;
import io.avaje.inject.generator.Append;
import io.avaje.inject.generator.BeanAspects;
import io.avaje.inject.generator.BeanConditions;
import io.avaje.inject.generator.BeanRequestParams;
import io.avaje.inject.generator.BeanTypesPrism;
import io.avaje.inject.generator.ConditionalWriter;
import io.avaje.inject.generator.Dependency;
import io.avaje.inject.generator.FactoryPrism;
import io.avaje.inject.generator.FieldReader;
import io.avaje.inject.generator.ImportTypeMap;
import io.avaje.inject.generator.LazyPrism;
import io.avaje.inject.generator.MetaData;
import io.avaje.inject.generator.MethodReader;
import io.avaje.inject.generator.PrimaryPrism;
import io.avaje.inject.generator.ProcessingContext;
import io.avaje.inject.generator.ProcessorUtils;
import io.avaje.inject.generator.PrototypePrism;
import io.avaje.inject.generator.ProxyPrism;
import io.avaje.inject.generator.SecondaryPrism;
import io.avaje.inject.generator.SimpleBeanLazyWriter;
import io.avaje.inject.generator.TypeReader;
import io.avaje.inject.generator.UType;
import io.avaje.inject.generator.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

final class BeanReader {
    private final TypeElement beanType;
    private final String shortName;
    private final String type;
    private final String name;
    private final MethodReader constructor;
    private final List<FieldReader> injectFields;
    private final List<MethodReader> injectMethods;
    private final List<MethodReader> factoryMethods;
    private final List<MethodReader> observerMethods;
    private final Optional<MethodReader> postConstructMethod;
    private final Element preDestroyMethod;
    private final ImportTypeMap importTypes = new ImportTypeMap();
    private final BeanRequestParams requestParams;
    private final TypeReader typeReader;
    private final boolean prototype;
    private final boolean primary;
    private final boolean secondary;
    private final boolean lazy;
    private final boolean proxy;
    private final boolean proxyLazy;
    private final TypeElement lazyProxyType;
    private final BeanAspects aspects;
    private final BeanConditions conditions = new BeanConditions();
    private final boolean importedComponent;
    private final Integer preDestroyPriority;
    private boolean writtenToFile;
    private boolean suppressBuilderImport;
    private boolean suppressGeneratedImport;
    private Set<UType> allUTypes;
    private final boolean delayed;
    private final Integer priority;

    BeanReader(TypeElement beanType, boolean factory, boolean importedComponent) {
        this.beanType = beanType;
        this.type = beanType.getQualifiedName().toString();
        this.shortName = this.shortName(beanType);
        this.proxy = ProxyPrism.isPresent(beanType);
        TypeElement actualType = this.proxy ? APContext.asTypeElement(beanType.getSuperclass()) : beanType;
        this.prototype = PrototypePrism.isPresent(actualType) || importedComponent && ProcessingContext.isImportedPrototype(actualType);
        this.primary = PrimaryPrism.isPresent(actualType);
        this.secondary = !this.primary && SecondaryPrism.isPresent(actualType);
        this.priority = Util.priority(actualType);
        Optional<List> beanTypes = BeanTypesPrism.getOptionalOn(actualType).map(BeanTypesPrism::value).or(() -> this.proxy ? Optional.of(List.of(actualType.asType())) : Optional.empty());
        beanTypes.ifPresent(t -> Util.validateBeanTypes(actualType, t));
        this.typeReader = new TypeReader(beanTypes.orElse(List.of()), UType.parse(beanType.asType()), beanType, this.importTypes, factory);
        this.typeReader.process();
        this.lazy = !FactoryPrism.isPresent(actualType) && (LazyPrism.isPresent(actualType) || importedComponent && ProcessingContext.isImportedLazy(actualType));
        this.requestParams = new BeanRequestParams(this.type);
        this.name = this.typeReader.name();
        this.aspects = this.typeReader.hasAspects();
        this.injectMethods = this.typeReader.injectMethods();
        this.injectFields = this.typeReader.injectFields();
        this.factoryMethods = this.typeReader.factoryMethods();
        this.postConstructMethod = this.typeReader.postConstructMethod();
        this.preDestroyMethod = this.typeReader.preDestroyMethod();
        this.preDestroyPriority = this.typeReader.preDestroyPriority();
        this.constructor = this.typeReader.constructor();
        this.observerMethods = this.typeReader.observerMethods();
        this.importedComponent = importedComponent && this.constructor != null && this.constructor.isPublic();
        this.delayed = this.shouldDelay();
        this.lazyProxyType = !this.lazy || this.delayed ? null : Util.lazyProxy(actualType);
        this.proxyLazy = this.lazy && this.lazyProxyType != null;
        this.conditions.readAll(actualType);
    }

    private boolean shouldDelay() {
        Stream<TypeMirror> constructors = Optional.ofNullable(this.constructor).map(MethodReader::params).stream().flatMap(Collection::stream).map(MethodReader.MethodParam::element).map(Element::asType);
        Stream<TypeMirror> fields = this.injectFields.stream().map(FieldReader::element).map(Element::asType);
        Stream<TypeMirror> methods = this.injectMethods.stream().map(MethodReader::params).flatMap(Collection::stream).map(MethodReader.MethodParam::element).map(Element::asType);
        Stream interfaces = this.beanType.getInterfaces().stream();
        Stream<TypeMirror> superClass = Stream.of(this.beanType.getSuperclass());
        Stream beanTypes = BeanTypesPrism.getOptionalOn(this.beanType).map(BeanTypesPrism::value).stream().flatMap(Collection::stream);
        return Stream.of(constructors, fields, methods, interfaces, superClass, beanTypes).flatMap(s -> s).map(TypeMirror::getKind).anyMatch(TypeKind.ERROR::equals);
    }

    public String toString() {
        return this.beanType.toString();
    }

    TypeElement beanType() {
        return this.beanType;
    }

    BeanAspects aspects() {
        return this.aspects;
    }

    boolean registerProvider() {
        return this.prototype || this.lazy;
    }

    boolean lazy() {
        return this.lazy;
    }

    boolean proxyLazy() {
        return this.proxyLazy;
    }

    boolean importedComponent() {
        return this.importedComponent;
    }

    BeanReader read() {
        if (this.constructor != null) {
            this.constructor.addImports(this.importTypes);
            this.constructor.checkRequest(this.requestParams);
        }
        for (FieldReader field : this.injectFields) {
            field.addImports(this.importTypes);
            field.checkRequest(this.requestParams);
        }
        for (MethodReader method : this.injectMethods) {
            method.addImports(this.importTypes);
            method.checkRequest(this.requestParams);
        }
        for (MethodReader method : this.observerMethods) {
            method.addImports(this.importTypes);
        }
        for (MethodReader factoryMethod : this.factoryMethods) {
            factoryMethod.addImports(this.importTypes);
        }
        this.postConstructMethod.ifPresent(m -> m.addImports(this.importTypes));
        this.conditions.addImports(this.importTypes);
        if (this.proxyLazy) {
            SimpleBeanLazyWriter.write(APContext.elements().getPackageOf(this.beanType), this.lazyProxyType);
        } else if (this.lazy) {
            APContext.logWarn(this.beanType, "Lazy beans should have a no-arg constructor", new Object[0]);
        }
        return this;
    }

    List<Dependency> dependsOn() {
        ArrayList<Dependency> list = new ArrayList<Dependency>();
        if (this.constructor != null) {
            for (MethodReader.MethodParam param2 : this.constructor.params()) {
                Dependency dependsOn = param2.dependsOn();
                if ("io.avaje.inject.BeanScope".equals(dependsOn.dependsOn())) continue;
                list.add(dependsOn);
            }
        }
        this.observerMethods.stream().flatMap(m -> m.params().stream().skip(1L)).forEach(param -> {
            Dependency dependsOn = param.dependsOn();
            if (!"io.avaje.inject.BeanScope".equals(dependsOn.dependsOn())) {
                list.add(dependsOn);
            }
        });
        this.conditions.requireTypes.stream().map(t -> new Dependency("con:" + t)).forEach(list::add);
        this.conditions.missingTypes.stream().filter(t -> !t.equals(this.type)).map(t -> new Dependency("con:" + t)).forEach(list::add);
        return list;
    }

    List<MethodReader> factoryMethods() {
        return this.factoryMethods;
    }

    List<String> provides() {
        return Util.addQualifierSuffix(this.typeReader.provides(), this.name);
    }

    List<String> autoProvides() {
        return Util.addQualifierSuffix(this.typeReader.autoProvides(), this.name);
    }

    String providesAspect() {
        return this.typeReader.providesAspect();
    }

    Set<UType> allGenericTypes() {
        if (this.allUTypes != null) {
            return this.allUTypes;
        }
        this.allUTypes = new LinkedHashSet<UType>(this.typeReader.genericTypes());
        for (FieldReader field : this.injectFields) {
            field.addDependsOnGeneric(this.allUTypes);
        }
        for (MethodReader method : this.injectMethods) {
            method.addDependsOnGeneric(this.allUTypes);
        }
        for (MethodReader method : this.observerMethods) {
            UType utype = method.observeParam().getFullUType();
            if (utype.isGeneric()) {
                this.allUTypes.add(utype);
            }
            method.params().stream().filter(p -> !p.observeEvent()).map(MethodReader.MethodParam::getFullUType).forEach(u -> {
                if (u.isGeneric()) {
                    this.allUTypes.add((UType)u);
                }
            });
        }
        if (this.constructor != null) {
            this.constructor.addDependsOnGeneric(this.allUTypes);
        }
        for (MethodReader factoryMethod : this.factoryMethods()) {
            factoryMethod.addDependsOnGeneric(this.allUTypes);
        }
        this.postConstructMethod.ifPresent(m -> m.params().stream().filter(MethodReader.MethodParam::isGenericParam).map(MethodReader.MethodParam::getFullUType).forEach(this.allUTypes::add));
        return this.allUTypes;
    }

    private String shortName(Element element) {
        return element.getSimpleName().toString();
    }

    String metaKey() {
        if (this.name != null) {
            return this.type + ":" + this.name;
        }
        return this.type;
    }

    boolean hasLifecycleMethods() {
        return this.postConstructMethod.isPresent() || this.preDestroyMethod != null || this.typeReader.isClosable();
    }

    List<MetaData> createFactoryMethodMeta() {
        if (this.factoryMethods.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MetaData> metaList = new ArrayList<MetaData>(this.factoryMethods.size());
        for (MethodReader factoryMethod : this.factoryMethods) {
            metaList.add(factoryMethod.createMeta());
        }
        return metaList;
    }

    MetaData createMeta() {
        Object metaType = this.beanType.getNestingKind().isNested() ? this.beanType.getEnclosingElement().toString() + "$" + String.valueOf(this.beanType.getSimpleName()) : this.beanQualifiedName();
        MetaData metaData = new MetaData((String)metaType, this.name);
        metaData.update(this);
        return metaData;
    }

    boolean isExtraInjectionRequired() {
        return !this.injectFields.isEmpty() || !this.injectMethods.isEmpty();
    }

    void buildConditional(Append writer) {
        new ConditionalWriter(writer, this.conditions).write();
    }

    void buildBeanAbsent(Append writer) {
        writer.append("    if (builder.isBeanAbsent(");
        if (this.name != null && !this.name.isEmpty()) {
            writer.append("\"%s\", ", this.name);
        }
        writer.append(this.typeReader.typesRegister());
        writer.append(")) {").eol();
    }

    void buildRegister(Append writer) {
        if (this.prototype || this.lazy) {
            return;
        }
        writer.indent("      ");
        if (this.isExtraInjectionRequired() || this.hasLifecycleMethods()) {
            writer.append("var $bean = ");
        }
        writer.append("builder.");
        if (this.primary) {
            writer.append("asPrimary().");
        } else if (this.secondary) {
            writer.append("asSecondary().");
        } else if (this.priority != null) {
            writer.append("asPriority(%s).", this.priority);
        }
        writer.append("register(bean);").eol();
    }

    void addLifecycleCallbacks(Append writer, String indent) {
        if (this.postConstructMethod.isPresent() && !this.registerProvider()) {
            this.writePostConstruct(writer, indent, this.postConstructMethod.get());
        }
        if (this.preDestroyMethod != null) {
            this.lifeCycleNotSupported("@PreDestroy");
            String priority = this.preDestroyPriority == null || this.preDestroyPriority == 1000 ? "" : ", " + this.preDestroyPriority;
            writer.indent(indent).append(" builder.addPreDestroy($bean::%s%s);", this.preDestroyMethod.getSimpleName(), priority).eol();
        } else if (this.typeReader.isClosable() && !this.prototype) {
            writer.indent(indent).append(" builder.addAutoClosable($bean);").eol();
        }
    }

    private void writePostConstruct(Append writer, String indent, MethodReader postConstruct) {
        writer.indent(indent).append(" builder.addPostConstruct(");
        String methodName = postConstruct.name();
        List<MethodReader.MethodParam> params = postConstruct.params();
        if (params.isEmpty() || "io.avaje.inject.BeanScope".equals(params.get(0).getFullUType().shortType())) {
            writer.append("$bean::%s);", methodName).eol();
        } else {
            writer.append("beanScope -> $bean.%s(", methodName);
            this.writeLifeCycleGet(writer, params, "beanScope", "beanScope");
            writer.append(");").eol();
        }
    }

    void prototypePostConstruct(Append writer, String indent) {
        this.postConstructMethod.ifPresent(m -> {
            writer.indent(indent).append(" bean.%s(", m.name());
            if (m.params().isEmpty()) {
                writer.append(");").eol();
            } else {
                this.writeLifeCycleGet(writer, m.params(), "builder", "builder.get(io.avaje.inject.BeanScope.class)");
                writer.append(";").eol();
            }
            writer.eol();
        });
    }

    private void writeLifeCycleGet(Append writer, List<MethodReader.MethodParam> params, String builderName, String beanScopeString) {
        int size = params.size();
        for (int i = 0; i < size; ++i) {
            MethodReader.MethodParam param;
            if (i > 0) {
                writer.append(", ");
            }
            if ("io.avaje.inject.BeanScope".equals((param = params.get(i)).getFullUType().fullWithoutAnnotations())) {
                writer.append(beanScopeString);
                continue;
            }
            param.builderGetDependency(writer, builderName);
        }
        writer.append(")");
    }

    private void lifeCycleNotSupported(String lifecycle) {
        if (this.registerProvider()) {
            APContext.logError(this.beanType, "%s scoped bean does not support the %s lifecycle method", this.prototype ? "@Prototype" : "@Lazy", lifecycle);
        }
    }

    private Set<String> importTypes() {
        this.importTypes.add(this.type);
        this.typeReader.extraImports(this.importTypes);
        this.requestParams.addImports(this.importTypes);
        this.aspects.extraImports(this.importTypes);
        for (MethodReader factoryMethod : this.factoryMethods) {
            Set<UType> utypes = factoryMethod.genericTypes();
            if (utypes.isEmpty()) continue;
            this.importTypes.add("java.lang.reflect.Type");
            this.importTypes.add("io.avaje.inject.spi.GenericType");
            utypes.forEach(t -> this.importTypes.addAll(t.importTypes()));
        }
        this.checkImports();
        if (!this.suppressGeneratedImport) {
            this.importTypes.add("io.avaje.inject.spi.Generated");
        }
        if (!this.suppressBuilderImport && !this.isGenerateProxy()) {
            this.importTypes.add("io.avaje.inject.spi.Builder");
        }
        return this.importTypes.forImport();
    }

    private void checkImports() {
        this.suppressBuilderImport = this.importTypes.containsShortName("Builder");
        this.suppressGeneratedImport = this.importTypes.containsShortName("Generated");
    }

    String builderType() {
        return this.suppressBuilderImport ? "io.avaje.inject.spi.Builder" : "Builder";
    }

    String generatedType() {
        return this.suppressGeneratedImport ? "@io.avaje.inject.spi.Generated" : "@Generated";
    }

    void writeImports(Append writer, String pkgName) {
        if (!this.allGenericTypes().isEmpty()) {
            this.importTypes.add("java.lang.reflect.Type");
            this.importTypes.add("io.avaje.inject.spi.GenericType");
        }
        for (String importType : this.importTypes()) {
            if (!Util.validImportType(importType, pkgName)) continue;
            writer.append("import %s;", Util.sanitizeImports(importType)).eol();
        }
        writer.eol();
    }

    MethodReader constructor() {
        return this.constructor;
    }

    boolean isWrittenToFile() {
        return this.writtenToFile;
    }

    void setWrittenToFile() {
        this.writtenToFile = true;
    }

    boolean isRequestScopedController() {
        return this.requestParams.isRequestScopedController();
    }

    String suffix() {
        return this.isRequestScopedController() ? "$Factory" : "$DI";
    }

    void factoryInterface(Append writer) {
        this.requestParams.factoryInterface(writer);
    }

    void writeRequestCreate(Append writer) {
        if (this.constructor != null) {
            this.constructor.writeRequestDependency(writer);
        }
        for (FieldReader field : this.injectFields) {
            field.writeRequestDependency(writer);
        }
        for (MethodReader method : this.injectMethods) {
            method.writeRequestDependency(writer);
        }
        this.requestParams.writeRequestCreate(writer);
        writer.resetNextName();
        writer.append("    var bean = new %s(", this.shortName);
        if (this.constructor != null) {
            this.constructor.writeRequestConstructor(writer);
        }
        writer.append(");").eol();
        for (FieldReader field : this.injectFields) {
            field.writeRequestInject(writer);
        }
        for (MethodReader method : this.injectMethods) {
            writer.append("    bean.%s(", method.name());
            method.writeRequestConstructor(writer);
            writer.append(");").eol();
        }
        writer.append("    return bean;").eol();
        writer.append("  }").eol();
    }

    List<FieldReader> injectFields() {
        return this.typeReader.injectFields();
    }

    List<MethodReader> injectMethods() {
        return this.typeReader.injectMethods();
    }

    List<MethodReader> observerMethods() {
        return this.observerMethods;
    }

    boolean isGenerateProxy() {
        return this.aspects.hasAspects() && !this.proxy;
    }

    void writeConstructorParams(Append writer) {
        if (this.constructor != null) {
            this.constructor.writeConstructorParams(writer);
        }
    }

    void writeConstructorInit(Append writer) {
        if (this.constructor != null) {
            writer.append("    super(");
            this.constructor.writeConstructorInit(writer);
            writer.append(");").eol();
        }
    }

    boolean hasConditions() {
        return !this.conditions.isEmpty();
    }

    String shortName() {
        return Util.shortName(this.beanQualifiedName());
    }

    String packageName() {
        if (this.importedComponent) {
            return this.beanPackageName() + ".di";
        }
        return this.beanPackageName();
    }

    private String beanPackageName() {
        if (this.beanType.getNestingKind().isNested()) {
            return Util.nestedPackageOf(this.beanQualifiedName());
        }
        return ProcessorUtils.packageOf(this.beanQualifiedName());
    }

    private String beanQualifiedName() {
        return this.beanType.getQualifiedName().toString();
    }

    boolean needsTryForMethodInjection() {
        for (MethodReader injectMethod : this.injectMethods) {
            if (!injectMethod.methodThrows()) continue;
            return true;
        }
        return false;
    }

    boolean isDelayed() {
        return this.delayed;
    }

    void validate() {
        this.typeReader.validate();
    }

    TypeElement lazyProxyType() {
        return this.lazyProxyType;
    }
}

