/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

final class ImportTypeMap {
    private final Map<String, String> mapByShortName = new HashMap<String, String>();

    ImportTypeMap() {
    }

    Set<String> forImport() {
        return new TreeSet<String>(this.mapByShortName.values());
    }

    boolean containsShortName(String suffix) {
        return this.mapByShortName.containsKey(suffix);
    }

    void addAll(Iterable<String> types) {
        types.forEach(this::add);
    }

    String add(String fullType) {
        String shortName = Util.shortName(fullType);
        int index = shortName.lastIndexOf(46);
        String fullTypeActual = index != -1 ? fullType.replace(shortName, shortName.substring(0, index)) : fullType;
        String existingFull = this.mapByShortName.get(shortName);
        if (existingFull == null) {
            this.mapByShortName.put(shortName, fullTypeActual);
            return shortName;
        }
        if (existingFull.equals(fullTypeActual)) {
            return shortName;
        }
        return fullType;
    }
}

