/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.APContext;
import io.avaje.inject.generator.AllScopes;
import io.avaje.inject.generator.AspectImportPrism;
import io.avaje.inject.generator.AssistBeanReader;
import io.avaje.inject.generator.ExternalProvider;
import io.avaje.inject.generator.FactoryOrder;
import io.avaje.inject.generator.GeneratedPrism;
import io.avaje.inject.generator.ImportPrism;
import io.avaje.inject.generator.InjectModulePrism;
import io.avaje.inject.generator.ModuleData;
import io.avaje.inject.generator.PluginProvidesPrism;
import io.avaje.inject.generator.PomPluginWriter;
import io.avaje.inject.generator.ProcessingContext;
import io.avaje.inject.generator.ScopeInfo;
import io.avaje.inject.generator.ScopePrism;
import io.avaje.inject.generator.ServiceProviderPrism;
import io.avaje.inject.generator.SimpleAssistWriter;
import io.avaje.inject.generator.SimpleOrderWriter;
import io.avaje.inject.generator.UType;
import io.avaje.inject.generator.Util;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;

@SupportedOptions(value={"mergeServices", "buildPlugin"})
@SupportedAnnotationTypes(value={"io.avaje.inject.aop.Aspect.Import", "io.avaje.inject.AssistFactory", "io.avaje.inject.Component", "io.avaje.inject.test.TestScope", "io.avaje.http.api.Controller", "io.avaje.inject.External", "io.avaje.inject.Factory", "io.avaje.inject.Component.Import", "io.avaje.inject.InjectModule", "io.avaje.inject.spi.PluginProvides", "io.avaje.inject.Prototype", "jakarta.inject.Qualifier", "jakarta.inject.Scope", "jakarta.inject.Singleton", "io.avaje.spi.ServiceProvider"})
public final class InjectProcessor
extends AbstractProcessor {
    private Elements elementUtils;
    private ScopeInfo defaultScope;
    private AllScopes allScopes;
    private boolean readModuleInfo;
    private final Set<String> pluginFileProvided = new HashSet<String>();
    private final Set<String> moduleFileProvided = new HashSet<String>();
    private final List<ModuleData> moduleData = new ArrayList<ModuleData>();

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        APContext.init(processingEnv);
        this.loadProvidedFiles();
        ProcessingContext.registerProvidedTypes(this.moduleFileProvided);
        this.moduleData.forEach(ProcessingContext::addModule);
        this.elementUtils = processingEnv.getElementUtils();
        this.allScopes = ProcessingContext.allScopes();
        this.defaultScope = this.allScopes.defaultScope();
        ExternalProvider.registerPluginProvidedTypes(this.defaultScope);
        this.pluginFileProvided.forEach(this.defaultScope::pluginProvided);
        try {
            Path file = APContext.getBuildResource("avaje-processors.txt");
            StringBuilder addition = new StringBuilder();
            if (file.toFile().exists()) {
                String result = Stream.concat(Files.lines(file), Stream.of("avaje-inject-generator")).distinct().collect(Collectors.joining("\n"));
                addition.append(result);
            } else {
                addition.append("avaje-inject-generator");
            }
            Files.writeString(file, (CharSequence)addition.toString(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
            PomPluginWriter.addPlugin2Pom();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void loadProvidedFiles() {
        this.lines("avaje-module-dependencies.csv").stream().filter(s -> s.contains("|") && !s.startsWith("External Module Type")).distinct().map(l -> l.split("\\|")).map(ModuleData::of).flatMap(Optional::stream).forEach(m -> {
            ExternalProvider.registerExternalMetaData(m.name());
            ExternalProvider.readMetaDataProvides(this.moduleFileProvided);
            this.moduleData.add((ModuleData)m);
        });
        this.lines("avaje-plugins.csv").stream().filter(s -> s.contains("|") && !s.startsWith("External Plugin Type")).distinct().map(l -> l.split("\\|")[1]).forEach(this.pluginFileProvided::add);
    }

    private List<String> lines(String relativeName) {
        try {
            return Files.readAllLines(APContext.getBuildResource(relativeName));
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.errorRaised()) {
            return false;
        }
        APContext.setProjectModuleElement(annotations, roundEnv);
        this.readModule(roundEnv);
        boolean processingOver = roundEnv.processingOver();
        ProcessingContext.processingOver(processingOver);
        this.readBeans(ProcessingContext.delayedElements());
        ProcessingContext.addImportedAspects(InjectProcessor.importedAspects(roundEnv));
        InjectProcessor.maybeElements(roundEnv, "jakarta.inject.Qualifier").stream().flatMap(Collection::stream).flatMap(e -> ElementFilter.methodsIn(e.getEnclosedElements()).stream()).forEach(this::validateQualifier);
        InjectProcessor.maybeElements(roundEnv, "jakarta.inject.Scope").ifPresent(this::readScopes);
        InjectProcessor.maybeElements(roundEnv, "io.avaje.inject.Factory").ifPresent(this::readFactories);
        if (this.defaultScope.includeSingleton()) {
            InjectProcessor.maybeElements(roundEnv, "jakarta.inject.Singleton").ifPresent(this::readBeans);
        }
        InjectProcessor.maybeElements(roundEnv, "io.avaje.inject.Component").ifPresent(this::readBeans);
        InjectProcessor.maybeElements(roundEnv, "io.avaje.inject.Prototype").ifPresent(this::readBeans);
        this.readImported(this.importedElements(roundEnv));
        InjectProcessor.maybeElements(roundEnv, "io.avaje.http.api.Controller").ifPresent(this::readBeans);
        InjectProcessor.maybeElements(roundEnv, "io.avaje.inject.AssistFactory").ifPresent(this::readAssisted);
        InjectProcessor.maybeElements(roundEnv, "io.avaje.inject.External").stream().flatMap(Collection::stream).forEach(e -> {
            if (e instanceof ExecutableElement) {
                ExecutableElement method = (ExecutableElement)e;
                method.getParameters().forEach(p -> {
                    UType type = UType.parse(p.asType());
                    this.addExternalType((Element)p, type);
                });
            } else {
                UType type = UType.parse(e.asType());
                this.addExternalType((Element)e, type);
            }
        });
        InjectProcessor.maybeElements(roundEnv, "io.avaje.spi.ServiceProvider").ifPresent(this::registerSPI);
        InjectProcessor.maybeElements(roundEnv, "io.avaje.inject.spi.PluginProvides").ifPresent(this::registerSPI);
        this.allScopes.readBeans(roundEnv);
        this.defaultScope.write(processingOver);
        this.allScopes.write(processingOver);
        if (processingOver) {
            Set<String> order = new FactoryOrder(ProcessingContext.modules(), this.defaultScope.pluginProvided()).orderModules();
            if (ProcessingContext.strictWiring()) {
                try {
                    new SimpleOrderWriter(order, this.defaultScope).write();
                }
                catch (IOException e2) {
                    APContext.logError("FilerException trying to write wiring order class %s", e2.getMessage());
                }
            }
            ProcessingContext.writeSPIServicesFile();
            ProcessingContext.validateModule();
            ProcessingContext.clear();
        }
        return false;
    }

    private void addExternalType(Element e, UType type) {
        type = "java.util.List".equals(type.mainType()) ? type.param0() : type;
        ProcessingContext.addOptionalType(type.fullWithoutAnnotations(), Util.named(e));
        ProcessingContext.addOptionalType(type.fullWithoutAnnotations(), null);
    }

    private void validateQualifier(ExecutableElement method) {
        TypeElement type = APContext.asTypeElement(method.getReturnType());
        if (type == null || type.getKind() != ElementKind.ANNOTATION_TYPE) {
            return;
        }
        List<ExecutableElement> enclosedMethods = ElementFilter.methodsIn(type.getEnclosedElements());
        if (enclosedMethods.size() > 1) {
            APContext.logError(method, "Qualifier annotation members can only have a single attribute", new Object[0]);
        }
        enclosedMethods.forEach(this::validateQualifier);
    }

    private static Optional<? extends Set<? extends Element>> maybeElements(RoundEnvironment round, String name) {
        return Optional.ofNullable(APContext.typeElement(name)).map(round::getElementsAnnotatedWith);
    }

    private Set<TypeElement> importedElements(RoundEnvironment roundEnv) {
        return InjectProcessor.maybeElements(roundEnv, "io.avaje.inject.Component.Import").stream().flatMap(Collection::stream).map(ImportPrism::getInstanceOn).flatMap(p -> {
            String kind = p.kind();
            return p.value().stream().map(ProcessingContext::asElement).filter(this::notAlreadyProvided).map(e -> InjectProcessor.registerImportedKind(e, kind));
        }).collect(Collectors.toSet());
    }

    private static TypeElement registerImportedKind(TypeElement e, String kind) {
        if (!"SINGLETON".equals(kind)) {
            ProcessingContext.addImportedKind(e, kind);
        }
        return e;
    }

    private boolean notAlreadyProvided(TypeElement e) {
        String type = e.getQualifiedName().toString();
        return !this.moduleFileProvided.contains(type) && !this.pluginFileProvided.contains(type);
    }

    private static Map<String, AspectImportPrism> importedAspects(RoundEnvironment roundEnv) {
        return InjectProcessor.maybeElements(roundEnv, "io.avaje.inject.aop.Aspect.Import").stream().flatMap(Collection::stream).map(AspectImportPrism::getAllInstancesOn).flatMap(Collection::stream).collect(Collectors.toMap(p -> p.value().toString(), p -> p));
    }

    private void readScopes(Set<? extends Element> scopes) {
        for (Element element : scopes) {
            if (element.getKind() != ElementKind.ANNOTATION_TYPE || !(element instanceof TypeElement)) continue;
            TypeElement type = (TypeElement)element;
            this.allScopes.addScopeAnnotation(type);
        }
        this.addTestScope();
    }

    private void addTestScope() {
        TypeElement testScopeType = this.elementUtils.getTypeElement("io.avaje.inject.test.TestScope");
        if (testScopeType != null) {
            this.allScopes.addScopeAnnotation(testScopeType);
        }
    }

    private void readFactories(Set<? extends Element> beans) {
        this.readChangedBeans(ElementFilter.typesIn(beans), true, false);
    }

    private void readAssisted(Set<? extends Element> beans) {
        ElementFilter.typesIn(beans).forEach(t -> {
            AssistBeanReader reader = new AssistBeanReader((TypeElement)t);
            try {
                new SimpleAssistWriter(reader).write();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    private void readBeans(Set<? extends Element> beans) {
        this.readChangedBeans(ElementFilter.typesIn(beans), false, false);
    }

    private void readImported(Set<? extends Element> beans) {
        this.readChangedBeans(ElementFilter.typesIn(beans), false, true);
    }

    private void readChangedBeans(Set<TypeElement> beans, boolean factory, boolean importedComponent) {
        for (TypeElement typeElement : beans) {
            if (typeElement.getKind() == ElementKind.INTERFACE) continue;
            ScopeInfo scope = this.findScope(typeElement);
            if (!factory) {
                if (scope != null) continue;
                this.defaultScope.read(typeElement, false, importedComponent);
                continue;
            }
            if (scope != null) {
                scope.read(typeElement, true, false);
                continue;
            }
            this.defaultScope.read(typeElement, true, false);
        }
    }

    private ScopeInfo findScope(Element element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            ScopeInfo scopeInfo = this.allScopes.get(annotationMirror.getAnnotationType().toString());
            if (scopeInfo == null) continue;
            return scopeInfo;
        }
        return null;
    }

    private void readModule(RoundEnvironment roundEnv) {
        TypeElement moduleType;
        List moduleList = InjectProcessor.maybeElements(roundEnv, "io.avaje.inject.InjectModule").stream().flatMap(Collection::stream).filter(e -> !ScopePrism.isPresent(e)).filter(e -> !GeneratedPrism.isPresent(e)).collect(Collectors.toList());
        if (moduleList.size() > 1) {
            for (Element element : moduleList) {
                APContext.logError(element, "There should only be one default scope @InjectModule annotation in a module", new Object[0]);
            }
        }
        if (this.readModuleInfo) {
            return;
        }
        this.readModuleInfo = true;
        String factory = ProcessingContext.loadMetaInfServices();
        if (factory != null && (moduleType = this.elementUtils.getTypeElement(factory)) != null) {
            this.defaultScope.readModuleMetaData(moduleType);
        }
        this.allScopes.readModules(ProcessingContext.loadMetaInfCustom());
        this.readInjectModule(roundEnv);
    }

    private void readInjectModule(RoundEnvironment roundEnv) {
        InjectProcessor.maybeElements(roundEnv, "io.avaje.inject.InjectModule").stream().flatMap(Collection::stream).forEach(element -> {
            InjectModulePrism annotation;
            ScopePrism scope = ScopePrism.getInstanceOn(element);
            if (scope == null && (annotation = InjectModulePrism.getInstanceOn(element)) != null) {
                this.defaultScope.details(annotation.name(), (Element)element);
                ProcessingContext.strictWiring(annotation.strictWiring());
            }
        });
    }

    private void registerSPI(Set<? extends Element> beans) {
        ElementFilter.typesIn(beans).stream().filter(this::isExtension).map(TypeElement::getQualifiedName).map(Object::toString).forEach(ProcessingContext::addInjectSPI);
    }

    private boolean isExtension(TypeElement te) {
        PluginProvidesPrism.getOptionalOn(te).ifPresent(t -> {
            if (!APContext.isAssignable(te, "io.avaje.inject.spi.InjectPlugin")) {
                APContext.logError(te, "PluginProvides can only be placed on io.avaje.inject.spi.InjectPlugin", new Object[0]);
            }
        });
        ServiceProviderPrism.getOptionalOn(te).ifPresent(t -> {
            if (APContext.isAssignable(te, "io.avaje.inject.spi.InjectPlugin")) {
                APContext.logWarn(te, "PluginProvides should be used to auto register InjectPlugins", new Object[0]);
            }
        });
        return APContext.isAssignable(te, "io.avaje.inject.spi.InjectExtension");
    }
}

