/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.APContext;
import io.avaje.inject.generator.ProcessingContext;
import java.io.IOException;
import java.io.Writer;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

@SupportedAnnotationTypes(value={"io.avaje.inject.test.InjectTest"})
public final class InjectTestProcessor
extends AbstractProcessor {
    private boolean wroteLookup;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!this.wroteLookup) {
            if (!Optional.ofNullable(APContext.typeElement("io.avaje.inject.test.InjectTest")).map(roundEnv::getElementsAnnotatedWith).orElse(Set.of()).isEmpty()) {
                this.wroteLookup = true;
                this.writeLookup();
            }
        }
        return false;
    }

    private void writeLookup() {
        String template = "package io.avaje.inject.test.lookup;\n\nimport java.lang.invoke.MethodHandles;\nimport java.lang.invoke.MethodHandles.Lookup;\n\nimport io.avaje.inject.test.LookupProvider;\n\npublic class TestLookup implements LookupProvider {\n\n  @Override\n  public Lookup provideLookup() {\n    return MethodHandles.lookup();\n  }\n}";
        try (Writer writer = APContext.createSourceFile("io.avaje.inject.test.lookup.TestLookup", new Element[0]).openWriter();
             Writer services = ProcessingContext.createMetaInfWriterFor("META-INF/services/io.avaje.inject.test.LookupProvider").openWriter();){
            writer.append(template);
            services.append("io.avaje.inject.test.lookup.TestLookup");
        }
        catch (IOException e) {
            APContext.logWarn("failed to write lookup", new Object[0]);
        }
    }
}

