/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.APContext;
import io.avaje.inject.generator.Append;
import io.avaje.inject.generator.BeanReader;
import io.avaje.inject.generator.Dependency;
import io.avaje.inject.generator.DependencyMetaPrism;
import io.avaje.inject.generator.ProcessorUtils;
import io.avaje.inject.generator.Util;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

final class MetaData
implements Comparable<MetaData> {
    private static final Comparator<MetaData> COMPARATOR = Comparator.comparing(MetaData::type).thenComparing(MetaData::name, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(MetaData::compareProvides);
    private static final Map<String, Integer> FACTORY_FREQUENCY = new HashMap<String, Integer>();
    private static final String INDENT = "      ";
    private static final String NEWLINE = "\n";
    private final String type;
    private final String shortType;
    private final String name;
    private final String buildName;
    private final String method;
    private final String key;
    private boolean wired;
    private String providesAspect;
    private List<String> provides;
    private List<Dependency> dependsOn;
    private List<String> autoProvides;
    private boolean generateProxy;
    private boolean usesExternalDependency;
    private final Set<String> externalDependencies = new HashSet<String>();
    private boolean importedComponent;

    MetaData(DependencyMetaPrism meta) {
        this.type = meta.type();
        this.name = this.trimName(meta.name());
        this.shortType = Util.shortName(this.type);
        this.method = meta.method();
        this.providesAspect = meta.providesAspect();
        this.dependsOn = meta.dependsOn().stream().map(Dependency::new).collect(Collectors.toList());
        this.provides = Util.addQualifierSuffix(meta.provides(), this.name);
        this.autoProvides = Util.addQualifierSuffix(meta.autoProvides(), this.name);
        this.importedComponent = meta.importedComponent();
        this.key = this.createKey();
        this.buildName = this.createBuildName();
    }

    MetaData(String type, String name) {
        this(type, name, null);
    }

    MetaData(String type, String name, String method) {
        this.type = type;
        this.name = this.trimName(name);
        this.shortType = Util.shortName(type);
        this.provides = new ArrayList<String>();
        this.dependsOn = new ArrayList<Dependency>();
        this.method = method;
        this.key = this.createKey();
        this.buildName = this.createBuildName();
    }

    public String toString() {
        return this.name == null ? this.type : this.type + ":" + this.name;
    }

    boolean importedComponent() {
        return this.importedComponent;
    }

    boolean isGenerateProxy() {
        return this.generateProxy;
    }

    private String trimName(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        return name.replace("\\\"", "'");
    }

    String buildName() {
        return this.buildName;
    }

    private String createBuildName() {
        if (Util.isVoid(this.type)) {
            return "void_" + Util.trimMethod(this.method);
        }
        String trimType = Util.trimMethod(Util.unwrapProvider(this.type));
        if (this.name != null) {
            return trimType + "_" + this.name.replaceAll("[^a-zA-Z0-9_$]+", "_");
        }
        if (this.buildNameIncludeMethod() || this.hasMethod() && FACTORY_FREQUENCY.get(this.type) > 0) {
            return trimType + "__" + Util.trimMethod(this.method);
        }
        return trimType;
    }

    private boolean buildNameIncludeMethod() {
        return this.type.contains("<") && this.hasMethod();
    }

    String key() {
        return this.key;
    }

    private String createKey() {
        Object keyString;
        if (Util.isVoid(this.type)) {
            return "method:" + this.method;
        }
        Object object = keyString = this.name != null ? this.type + ":" + this.name : this.type;
        if (this.hasMethod() && FACTORY_FREQUENCY.compute(this.type, (k, v) -> {
            int n;
            if (v == null) {
                n = 0;
            } else {
                v = v + 1;
                n = v;
            }
            return n;
        }) > 0) {
            keyString = (String)keyString + String.valueOf(FACTORY_FREQUENCY.get(this.type));
        }
        return keyString;
    }

    boolean noDepends() {
        return this.dependsOn == null || this.dependsOn.isEmpty();
    }

    boolean isWired() {
        return this.wired;
    }

    void setWired() {
        this.wired = true;
    }

    void update(BeanReader beanReader) {
        this.provides = beanReader.provides();
        this.dependsOn = beanReader.dependsOn();
        this.providesAspect = beanReader.providesAspect();
        this.autoProvides = beanReader.autoProvides();
        this.generateProxy = beanReader.isGenerateProxy();
        this.importedComponent = beanReader.importedComponent();
    }

    String name() {
        return this.name;
    }

    String type() {
        return this.type;
    }

    List<String> provides() {
        return this.provides;
    }

    List<Dependency> dependsOn() {
        return this.dependsOn;
    }

    List<String> autoProvides() {
        return this.autoProvides;
    }

    String providesAspect() {
        return this.providesAspect;
    }

    String topPackage() {
        if (this.method == null || this.method.isEmpty()) {
            return ProcessorUtils.packageOf(this.type);
        }
        return null;
    }

    void addImportTypes(Set<String> importTypes) {
        if (this.hasMethod()) {
            importTypes.add(Util.classOfMethod(this.method));
        } else if (!this.generateProxy) {
            if (this.importedComponent) {
                String packageName = APContext.typeElement(this.type).getNestingKind().isNested() ? Util.nestedPackageOf(this.type) : ProcessorUtils.packageOf(this.type);
                importTypes.add(packageName + ".di." + this.shortType + "$DI");
            } else {
                importTypes.add(this.type + "$DI");
            }
        }
    }

    void buildMethod(Append append, boolean fullyQualify) {
        if (this.generateProxy) {
            return;
        }
        if (this.usesExternalDependency) {
            append.append("  // uses external dependency " + String.valueOf(this.externalDependencies) + NEWLINE);
        }
        boolean hasName = this.name != null;
        boolean hasMethod = this.hasMethod();
        boolean hasProvidesAspect = !this.providesAspect.isEmpty();
        boolean hasDependsOn = !this.dependsOn.isEmpty();
        boolean hasProvides = !this.provides.isEmpty();
        boolean hasAutoProvides = this.autoProvides != null && !this.autoProvides.isEmpty();
        append.append("  @DependencyMeta(");
        if (hasName || hasMethod || hasProvidesAspect || hasDependsOn || hasProvides || hasAutoProvides) {
            append.eol().append(INDENT);
        }
        append.append("type = \"").append(this.type).append("\"");
        if (hasName) {
            append.append(",").eol().append("      name = \"").append(this.name).append("\"");
        }
        if (this.importedComponent) {
            append.append(",").eol().append("      importedComponent = true");
        }
        if (hasMethod) {
            append.append(",").eol().append("      method = \"").append(this.method).append("\"");
        }
        if (hasProvidesAspect) {
            append.append(",").eol().append("      providesAspect = \"").append(this.providesAspect).append("\"");
        } else if (hasProvides) {
            this.appendProvides(append, "provides", this.provides);
        }
        if (hasDependsOn) {
            this.appendProvides(append, "dependsOn", this.dependsOn.stream().map(Dependency::dependsOn).collect(Collectors.toList()));
        }
        if (hasAutoProvides) {
            this.appendProvides(append, "autoProvides", this.autoProvides);
        }
        append.append(")").append(NEWLINE);
        append.append("  private void build_").append(this.buildName()).append("(Builder builder) {").append(NEWLINE);
        if (this.hasMethod()) {
            append.append("    ").append(Util.shortMethod(this.method)).append("(builder");
        } else {
            append.append("    ").append(fullyQualify ? this.type : this.shortType).append("$DI").append(".build(builder");
        }
        append.append(");").append(NEWLINE);
        append.append("  }").append(NEWLINE);
        append.eol();
    }

    private boolean hasMethod() {
        return this.method != null && !this.method.isEmpty();
    }

    private void appendProvides(Append sb, String attribute, List<String> types) {
        if (!"dependsOn".equals(attribute)) {
            types.removeIf(s -> s.contains(":"));
        }
        sb.append(",").eol().append(INDENT).append(attribute).append(" = {");
        int size = types.size();
        if (size > 1) {
            sb.eol().append("        ");
        }
        HashSet<String> seen = new HashSet<String>();
        for (int i = 0; i < types.size(); ++i) {
            String depType = types.get(i);
            if (!seen.add(depType)) continue;
            if (i > 0) {
                sb.append(",").eol().append("        ");
            }
            sb.append("\"");
            sb.append(depType);
            sb.append("\"");
        }
        if (size > 1) {
            sb.eol().append(INDENT);
        }
        sb.append("}");
    }

    void setProvides(List<String> provides) {
        this.provides = provides;
    }

    void setDependsOn(List<String> dependsOn) {
        this.dependsOn = dependsOn.stream().map(Dependency::new).collect(Collectors.toList());
    }

    void setAutoProvides(List<String> autoProvides) {
        this.autoProvides = autoProvides;
    }

    void setProvidesAspect(String providesAspect) {
        this.providesAspect = providesAspect;
    }

    void markWithExternalDependency(String name) {
        this.usesExternalDependency = true;
        this.externalDependencies.add(name);
        for (Dependency dependency : this.dependsOn) {
            if (!name.equals(dependency.name())) continue;
            dependency.markExternal();
        }
    }

    private String compareProvides() {
        return this.provides.toString();
    }

    @Override
    public int compareTo(MetaData meta) {
        return COMPARATOR.compare(this, meta);
    }
}

