/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.Append;
import io.avaje.inject.generator.ImportTypeMap;
import java.util.HashMap;
import java.util.Map;

final class RequestScope {
    private static final String JEX_CONTEXT = "io.avaje.jex.http.Context";
    private static final String JAVALIN_CONTEXT = "io.javalin.http.Context";
    private static final String HELIDON_REQ = "io.helidon.webserver.ServerRequest";
    private static final String HELIDON_RES = "io.helidon.webserver.ServerResponse";
    private static final String NIMA_REQ = "io.helidon.webserver.http.ServerRequest";
    private static final String NIMA_RES = "io.helidon.webserver.http.ServerResponse";
    private static final String HELIDON_REACTIVE_REQ = "io.helidon.reactive.webserver.ServerRequest";
    private static final String HELIDON_REACTIVE_RES = "io.helidon.reactive.webserver.ServerResponse";
    private static final Map<String, Handler> TYPES = new HashMap<String, Handler>();

    RequestScope() {
    }

    static boolean check(String type) {
        return TYPES.containsKey(type);
    }

    static Handler handler(String type) {
        return TYPES.get(type);
    }

    static {
        TYPES.put(JEX_CONTEXT, new JexHandler());
        TYPES.put(JAVALIN_CONTEXT, new JavalinHandler());
        Helidon helidon = new Helidon();
        TYPES.put(HELIDON_REQ, helidon);
        TYPES.put(HELIDON_RES, helidon);
        HelidonReactive helidonReactive = new HelidonReactive();
        TYPES.put(HELIDON_REACTIVE_REQ, helidonReactive);
        TYPES.put(HELIDON_REACTIVE_RES, helidonReactive);
        HelidonNima helidonNima = new HelidonNima();
        TYPES.put(NIMA_REQ, helidonNima);
        TYPES.put(NIMA_RES, helidonNima);
    }

    static interface Handler {
        public void factoryInterface(Append var1, String var2);

        public void addImports(ImportTypeMap var1);

        public void writeCreateMethod(Append var1, String var2);

        public String argumentName(String var1);
    }

    private static final class JexHandler
    extends ContextHandler {
        private JexHandler() {
            super(RequestScope.JEX_CONTEXT);
        }
    }

    private static final class JavalinHandler
    extends ContextHandler {
        private JavalinHandler() {
            super(RequestScope.JAVALIN_CONTEXT);
        }
    }

    private static final class Helidon
    extends RequestResponseHandler {
        Helidon() {
            super(RequestScope.HELIDON_REQ, RequestScope.HELIDON_RES);
        }
    }

    private static final class HelidonReactive
    extends RequestResponseHandler {
        HelidonReactive() {
            super(RequestScope.HELIDON_REACTIVE_REQ, RequestScope.HELIDON_REACTIVE_RES);
        }
    }

    private static final class HelidonNima
    extends RequestResponseHandler {
        HelidonNima() {
            super(RequestScope.NIMA_REQ, RequestScope.NIMA_RES);
        }
    }

    private static abstract class RequestResponseHandler
    implements Handler {
        final String reqType;
        final String resType;

        RequestResponseHandler(String reqType, String resType) {
            this.reqType = reqType;
            this.resType = resType;
        }

        @Override
        public void factoryInterface(Append writer, String parentType) {
            writer.append("BeanFactory2<%s, %s, %s>", parentType, "ServerRequest", "ServerResponse");
        }

        @Override
        public void addImports(ImportTypeMap importTypes) {
            importTypes.add("io.avaje.inject.spi.BeanFactory2");
            importTypes.add(this.reqType);
            importTypes.add(this.resType);
        }

        @Override
        public void writeCreateMethod(Append writer, String parentType) {
            writer.append("  public %s create(ServerRequest request, ServerResponse response) {", parentType).eol();
        }

        @Override
        public String argumentName(String paramType) {
            if (paramType.equals(this.resType)) {
                return "response";
            }
            return "request";
        }
    }

    private static abstract class ContextHandler
    implements Handler {
        final String contextType;

        private ContextHandler(String contextType) {
            this.contextType = contextType;
        }

        @Override
        public void factoryInterface(Append writer, String parentType) {
            writer.append("BeanFactory<%s, %s>", parentType, "Context");
        }

        @Override
        public void addImports(ImportTypeMap importTypes) {
            importTypes.add("io.avaje.inject.spi.BeanFactory");
            importTypes.add(this.contextType);
        }

        @Override
        public void writeCreateMethod(Append writer, String parentType) {
            writer.append("  public %s create(Context context) {", parentType).eol();
        }

        @Override
        public String argumentName(String paramType) {
            return "context";
        }
    }
}

