/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.APContext;
import io.avaje.inject.generator.Append;
import io.avaje.inject.generator.ImportTypeMap;
import io.avaje.inject.generator.UType;
import io.avaje.inject.generator.Util;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

final class SimpleBeanLazyWriter {
    private static final Set<String> GENERATED_PUBLISHERS = new HashSet<String>();
    private static final String TEMPLATE = "package {0};\n\n{1}@Proxy\n@Generated(\"avaje-inject-generator\")\npublic final class {2}$Lazy{3} {4} {2}{3} '{'\n\n  private final Provider<{2}{3}> onceProvider;\n\n  public {2}$Lazy(Provider<{2}{3}> onceProvider) '{'\n    this.onceProvider = onceProvider;\n  '}'\n\n{5}'}'\n";
    private final String originName;
    private final ImportTypeMap importTypes = new ImportTypeMap();
    private final String packageName;
    private final String shortName;
    private final boolean isInterface;
    private final TypeElement element;

    static void write(PackageElement pkg, TypeElement element) {
        new SimpleBeanLazyWriter(pkg, element);
    }

    SimpleBeanLazyWriter(PackageElement pkg, TypeElement element) {
        this.element = element;
        this.isInterface = element.getKind().isInterface();
        this.shortName = Util.shortName(element.getQualifiedName().toString()).replace(".", "_");
        this.packageName = pkg.getQualifiedName().toString();
        this.originName = this.packageName + "." + this.shortName + "$Lazy";
        if (GENERATED_PUBLISHERS.contains(this.originName)) {
            return;
        }
        this.importTypes.addAll(UType.parse(element.asType()).importTypes());
        this.write();
        GENERATED_PUBLISHERS.add(this.originName);
    }

    void write() {
        try {
            Append writer = new Append(APContext.createSourceFile(this.originName, this.element).openWriter());
            String inheritance = this.isInterface ? "implements" : "extends";
            String methodString = this.methods();
            List<? extends TypeParameterElement> typeParameters = this.element.getTypeParameters();
            String typeParametersDecl = this.buildTypeParametersDeclaration(typeParameters);
            writer.append(MessageFormat.format(TEMPLATE, this.packageName, this.imports(), this.shortName, typeParametersDecl, inheritance, methodString));
            writer.close();
        }
        catch (Exception e) {
            APContext.logError("Failed to write Proxy class %s", e);
        }
    }

    String imports() {
        this.importTypes.add("io.avaje.inject.spi.Proxy");
        this.importTypes.add("io.avaje.inject.spi.Generated");
        this.importTypes.add("jakarta.inject.Provider");
        StringBuilder writer = new StringBuilder();
        for (String importType : this.importTypes.forImport()) {
            if (!Util.validImportType(importType, this.packageName)) continue;
            writer.append(String.format("import %s;\n", Util.sanitizeImports(importType)));
        }
        return writer.append("\n").toString();
    }

    private String methods() {
        StringBuilder sb = new StringBuilder();
        for (ExecutableElement methodElement : ElementFilter.methodsIn(APContext.elements().getAllMembers(this.element))) {
            Set<Modifier> modifiers = methodElement.getModifiers();
            if (modifiers.contains((Object)Modifier.PRIVATE) || modifiers.contains((Object)Modifier.STATIC) || methodElement.getEnclosingElement().getSimpleName().contentEquals("Object")) continue;
            sb.append("  @Override\n");
            if (modifiers.contains((Object)Modifier.PUBLIC)) {
                sb.append("  public ");
            } else if (modifiers.contains((Object)Modifier.PROTECTED)) {
                sb.append("  protected ");
            } else {
                sb.append("  ");
            }
            List<? extends TypeParameterElement> typeParameters = methodElement.getTypeParameters();
            if (!typeParameters.isEmpty()) {
                sb.append("<");
                sb.append(typeParameters.stream().map(tp -> tp.getSimpleName().toString()).collect(Collectors.joining(", ")));
                sb.append("> ");
            }
            UType returnType = UType.parse(methodElement.getReturnType());
            this.importTypes.addAll(returnType.importTypes());
            sb.append(returnType.shortType()).append(" ");
            String methodName = methodElement.getSimpleName().toString();
            sb.append(methodName);
            sb.append("(");
            List<? extends VariableElement> parameters = methodElement.getParameters();
            for (int i = 0; i < parameters.size(); ++i) {
                VariableElement param = parameters.get(i);
                UType type = UType.parse(param.asType());
                this.importTypes.addAll(type.importTypes());
                sb.append(type.shortType());
                sb.append(" ");
                sb.append(param.getSimpleName().toString());
                if (i >= parameters.size() - 1) continue;
                sb.append(", ");
            }
            sb.append(")");
            List<? extends TypeMirror> thrownTypes = methodElement.getThrownTypes();
            if (!thrownTypes.isEmpty()) {
                sb.append(" throws ");
                sb.append(thrownTypes.stream().map(t -> UType.parse(t).shortType()).collect(Collectors.joining(", ")));
            }
            sb.append(" {\n    ");
            if (!"void".equals(returnType.full())) {
                sb.append("return ");
            }
            sb.append("onceProvider.get().").append(methodName);
            sb.append("(");
            for (int i = 0; i < parameters.size(); ++i) {
                sb.append(parameters.get(i).getSimpleName().toString());
                if (i >= parameters.size() - 1) continue;
                sb.append(", ");
            }
            sb.append(");\n");
            sb.append("  }\n\n");
        }
        return sb.toString();
    }

    private String buildTypeParametersDeclaration(List<? extends TypeParameterElement> typeParameters) {
        if (typeParameters.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder("<");
        for (int i = 0; i < typeParameters.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            TypeParameterElement param = typeParameters.get(i);
            sb.append(param.getSimpleName());
            List<? extends TypeMirror> bounds = param.getBounds();
            if (bounds.isEmpty() || "java.lang.Object".equals(bounds.get(0).toString())) continue;
            sb.append(" extends ");
            for (int j = 0; j < bounds.size(); ++j) {
                if (j > 0) {
                    sb.append(" & ");
                }
                sb.append(bounds.get(j).toString());
            }
        }
        sb.append(">");
        return sb.toString();
    }
}

