/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.APContext;
import io.avaje.inject.generator.Append;
import io.avaje.inject.generator.MetaData;
import io.avaje.inject.generator.MetaDataOrdering;
import io.avaje.inject.generator.ModuleData;
import io.avaje.inject.generator.ProcessingContext;
import io.avaje.inject.generator.ProcessorUtils;
import io.avaje.inject.generator.ScopeInfo;
import io.avaje.inject.generator.ScopePrism;
import io.avaje.inject.generator.Util;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;

final class SimpleModuleWriter {
    private static final String CODE_COMMENT_FACTORY = "/**\n * Avaje Inject module for %s.\n * \n * When using the Java module system, this generated class should be explicitly\n * registered in module-info via a <code>provides</code> clause like:\n * \n * <pre>{@code\n * \n *   module example {\n *     requires io.avaje.inject;\n *     \n *     provides io.avaje.inject.spi.InjectExtension with %s.%s;\n *     \n *   }\n * \n * }</pre>\n */";
    private static final String CODE_COMMENT_CREATE_CONTEXT = "  /**\n   * Creates all the beans in order based on constructor dependencies.\n   * The beans are registered into the builder along with callbacks for\n   * field/method injection, and lifecycle support.\n   */";
    private final String modulePackage;
    private final String shortName;
    private final String fullName;
    private final ScopeInfo scopeInfo;
    private final MetaDataOrdering ordering;
    private final ScopeInfo.Type scopeType;
    private final Set<String> duplicateTypes;
    private Append writer;

    SimpleModuleWriter(MetaDataOrdering ordering, ScopeInfo scopeInfo) {
        this.ordering = ordering;
        this.scopeInfo = scopeInfo;
        this.modulePackage = scopeInfo.modulePackage();
        this.shortName = scopeInfo.moduleShortName();
        this.fullName = scopeInfo.moduleFullName();
        this.scopeType = scopeInfo.type();
        HashSet seen = new HashSet();
        this.duplicateTypes = ordering.ordered().stream().map(MetaData::type).filter(t -> !seen.add(ProcessorUtils.shortType(t))).flatMap(t -> Stream.of(t, t + "$DI")).collect(Collectors.toSet());
    }

    void write() throws IOException {
        this.writer = new Append(this.createFileWriter());
        this.writePackage();
        this.writeStartClass();
        if (this.scopeType != ScopeInfo.Type.CUSTOM) {
            this.writeServicesFile(this.scopeType);
        } else {
            this.writeRequiredModules();
        }
        this.writeBuildMethod();
        this.writeProvides();
        this.writeClassesMethod();
        this.writeBuildMethods();
        this.writeEndClass();
        this.writer.close();
    }

    private void writeRequiredModules() {
        List<ScopeInfo> dependentScopes;
        List<ScopeInfo> directScopes = this.scopeInfo.requires().stream().map(APContext::typeElement).filter(ScopePrism::isPresent).filter(e -> e.getKind() == ElementKind.ANNOTATION_TYPE).map(TypeElement::getQualifiedName).map(Object::toString).map(ProcessingContext.allScopes()::get).collect(Collectors.toList());
        if (this.hasExternalDependency(directScopes, dependentScopes = directScopes.stream().filter(Objects::nonNull).flatMap(scope -> scope.dependentScopes().stream()).collect(Collectors.toList()))) {
            return;
        }
        LinkedHashSet requiredModules = new LinkedHashSet();
        dependentScopes.stream().map(ScopeInfo::moduleFullName).filter(Objects::nonNull).filter(Predicate.not(String::isBlank)).forEach(requiredModules::add);
        LinkedHashMap<String, String> dependencies = new LinkedHashMap<String, String>(this.scopeInfo.constructorDependencies());
        this.writer.append("  public static AvajeModule[] allRequiredModules(");
        boolean comma = false;
        for (Map.Entry entry : dependencies.entrySet()) {
            if (!comma) {
                comma = true;
            } else {
                this.writer.append(", ");
            }
            this.writer.append((String)entry.getKey()).append(" ").append((String)entry.getValue());
        }
        this.writer.append(") {").eol();
        this.writer.append("    return new AvajeModule[] {").eol();
        for (String rawType : requiredModules) {
            this.writer.append("      new %s(),", rawType).eol();
        }
        this.writer.append("      new %s(", this.shortName);
        this.writer.append(String.join((CharSequence)", ", this.scopeInfo.constructorDependencies().values()));
        this.writer.append(")").eol();
        this.writer.append("    };").eol();
        this.writer.append("  }").eol().eol();
    }

    private boolean hasExternalDependency(List<ScopeInfo> directScopes, List<ScopeInfo> dependentScopes) {
        if (directScopes.contains(null)) {
            return true;
        }
        for (ScopeInfo scope : dependentScopes) {
            if (!scope.requires().stream().map(ProcessingContext.allScopes()::get).anyMatch(Objects::isNull)) continue;
            return true;
        }
        return false;
    }

    private void writeServicesFile(ScopeInfo.Type scopeType) {
        try {
            if (scopeType == ScopeInfo.Type.DEFAULT) {
                ProcessingContext.addInjectSPI(this.fullName);
                return;
            }
            FileObject jfo = ProcessingContext.createMetaInfWriterFor("META-INF/services/io.avaje.inject.test.TestModule");
            if (jfo != null) {
                Writer writer = jfo.openWriter();
                writer.write(this.fullName);
                writer.close();
            }
        }
        catch (IOException e) {
            APContext.logError("Failed to write services file %s", e.getMessage());
        }
    }

    private void writeProvides() {
        TreeSet<String> scopeProvides = new TreeSet<String>(this.scopeInfo.provides());
        if (this.scopeType == ScopeInfo.Type.CUSTOM) {
            scopeProvides.add(this.scopeInfo.scopeAnnotationFQN());
            scopeProvides.add(this.shortName);
        }
        for (MetaData metaData : this.ordering.ordered()) {
            List<String> forExternal;
            String aspect = metaData.providesAspect();
            if (aspect != null && !aspect.isEmpty()) {
                scopeProvides.add(Util.wrapAspect(aspect));
            }
            if ((forExternal = metaData.autoProvides()) == null || forExternal.isEmpty()) continue;
            scopeProvides.addAll(forExternal);
        }
        TreeSet<String> scopeRequires = new TreeSet<String>(this.scopeInfo.requires());
        scopeRequires.addAll(this.ordering.autoRequires());
        this.scopeInfo.buildProvides(this.writer, scopeProvides, scopeRequires);
        ArrayList<String> requires = new ArrayList<String>(scopeRequires);
        ArrayList<String> provides = new ArrayList<String>(scopeProvides);
        ProcessingContext.addModule(new ModuleData(this.fullName, provides, requires));
    }

    private void writeClassesMethod() {
        Set<String> allClasses = this.distinctPublicClasses();
        this.writer.append("  @Override").eol();
        this.writer.append("  public Class<?>[] classes() {").eol();
        this.writer.append("    return new Class<?>[] {").eol();
        for (String rawType : new TreeSet<String>(allClasses)) {
            this.writer.append("      %s.class,", rawType).eol();
        }
        this.writer.append("    };").eol();
        this.writer.append("  }").eol().eol();
    }

    private Set<String> distinctPublicClasses() {
        LinkedHashSet<String> publicClasses = new LinkedHashSet<String>();
        for (MetaData metaData : this.ordering.ordered()) {
            String type;
            TypeElement element;
            String rawType = metaData.type();
            if ("void".equals(rawType) || ProcessorUtils.isPrimitive(rawType) || (element = APContext.typeElement(type = Util.trimGenerics(rawType))) == null || !element.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            publicClasses.add(type);
        }
        return publicClasses;
    }

    private void writeBuildMethod() {
        this.writer.append(CODE_COMMENT_CREATE_CONTEXT).eol();
        this.writer.append("  @Override").eol();
        this.writer.append("  public void build(Builder builder) {").eol();
        if (this.scopeInfo.addWithBeans()) {
            this.writeWithBeans();
        }
        this.writer.append("    // create beans in order based on constructor dependencies").eol();
        this.writer.append("    // i.e. \"provides\" followed by \"dependsOn\"").eol();
        for (MetaData metaData : this.ordering.ordered()) {
            if (metaData.isGenerateProxy()) continue;
            this.writer.append("    build_%s(builder);", metaData.buildName()).eol();
        }
        this.writer.append("  }").eol();
        this.writer.eol();
    }

    private void writeBuildMethods() {
        for (MetaData metaData : this.ordering.ordered()) {
            metaData.buildMethod(this.writer, this.duplicateTypes.contains(metaData.type()));
        }
    }

    private void writePackage() {
        this.writer.append("package %s;", this.modulePackage).eol().eol();
        for (String type : this.factoryImportTypes()) {
            this.writer.append("import %s;", type).eol();
        }
        for (String type : this.scopeInfo.initModuleDependencies(this.ordering.importTypes())) {
            if (this.duplicateTypes.contains(type) || !Util.validImportType(type, this.modulePackage)) continue;
            this.writer.append("import %s;", type).eol();
        }
        this.writer.eol();
    }

    private Set<String> factoryImportTypes() {
        TreeSet<String> importTypes = new TreeSet<String>();
        importTypes.add("io.avaje.inject.spi.Generated");
        importTypes.add("io.avaje.inject.spi.GenericType");
        importTypes.add("java.lang.reflect.Type");
        importTypes.add("io.avaje.inject.BeanScope");
        importTypes.add("io.avaje.inject.InjectModule");
        importTypes.add("io.avaje.inject.spi.DependencyMeta");
        importTypes.add("io.avaje.inject.spi.AvajeModule");
        importTypes.add("io.avaje.inject.spi.Builder");
        return importTypes;
    }

    private void writeStartClass() {
        this.writer.append(CODE_COMMENT_FACTORY, this.scopeInfo.name(), this.modulePackage, this.shortName).eol();
        this.scopeInfo.buildAtInjectModule(this.writer);
        String interfaceType = this.scopeInfo.type().type();
        this.writer.append("public final %sclass %s implements %s {", Util.valhalla(), this.shortName, interfaceType).eol().eol();
        if (this.scopeInfo.addModuleConstructor()) {
            this.writeConstructor();
        }
    }

    private void writeWithBeans() {
        this.writer.append("    // register external dependencies").eol();
        Map<String, String> dependencies = this.scopeInfo.constructorDependencies();
        for (Map.Entry<String, String> entry : dependencies.entrySet()) {
            this.writer.append("    builder.withBean(%s.class, %s);", entry.getKey(), entry.getValue()).eol();
        }
    }

    private void writeConstructor() {
        Map<String, String> dependencies = this.scopeInfo.constructorDependencies();
        for (Map.Entry<String, String> entry : dependencies.entrySet()) {
            this.writer.append("  private %s %s;", entry.getKey(), entry.getValue()).eol();
        }
        this.writer.eol();
        this.writer.append("  /**").eol();
        this.writer.append("   * Create providing the external dependencies.").eol();
        this.writer.append("   */").eol();
        this.writer.append("  public %s(", this.shortName);
        boolean comma = false;
        for (Map.Entry<String, String> entry : dependencies.entrySet()) {
            if (!comma) {
                comma = true;
            } else {
                this.writer.append(", ");
            }
            this.writer.append(entry.getKey()).append(" ").append(entry.getValue());
        }
        this.writer.append(") {", this.shortName).eol();
        for (Map.Entry<String, String> entry : dependencies.entrySet()) {
            this.writer.append("    this.%s = %s;", entry.getValue(), entry.getValue()).eol();
        }
        this.writer.append("  }").eol().eol();
    }

    private void writeEndClass() {
        this.writer.append("}").eol();
    }

    private Writer createFileWriter() throws IOException {
        return this.scopeInfo.moduleFile().openWriter();
    }
}

