/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.UType;
import io.avaje.inject.generator.Util;
import javax.lang.model.type.TypeMirror;

final class UtilType {
    private final Type type;
    private final String rawType;
    private final UType uType;

    private UtilType(Type type, String rawType, UType uType) {
        this.type = type;
        this.rawType = rawType;
        this.uType = uType;
    }

    static UtilType of(boolean beanMap, TypeMirror mirror) {
        UType uType = UType.parse(mirror);
        String rawType = uType.fullWithoutAnnotations().replace(" ", "");
        if (rawType.startsWith("java.util.List<")) {
            return new UtilType(Type.LIST, rawType, uType.param0());
        }
        if (rawType.startsWith("java.util.Set<")) {
            return new UtilType(Type.SET, rawType, uType.param0());
        }
        if (rawType.startsWith("java.util.Map<java.lang.String,")) {
            return new UtilType(Type.MAP, rawType, beanMap ? uType.param1() : uType);
        }
        if (rawType.startsWith("java.util.Optional<")) {
            return new UtilType(Type.OPTIONAL, rawType, uType.param0());
        }
        if (Util.isProvider(rawType)) {
            return new UtilType(Type.PROVIDER, rawType, uType.param0());
        }
        return new UtilType(Type.OTHER, rawType, uType);
    }

    boolean allowsNamedQualifier() {
        return this.type == Type.OPTIONAL || this.type == Type.OTHER;
    }

    boolean isCollection() {
        return this.type == Type.LIST || this.type == Type.SET;
    }

    String full() {
        return this.rawType;
    }

    String rawType(boolean beanMap) {
        switch (this.type.ordinal()) {
            case 1: {
                return Util.extractSet(this.rawType);
            }
            case 0: {
                return Util.extractList(this.rawType);
            }
            case 2: {
                if (beanMap) {
                    return Util.extractMap(this.rawType);
                }
                return this.rawType;
            }
            case 3: {
                return Util.extractOptionalType(this.rawType);
            }
        }
        return this.rawType;
    }

    UType toUType() {
        return this.uType;
    }

    String getMethod(boolean nullable, boolean beanMap) {
        switch (this.type.ordinal()) {
            case 1: {
                return "set(";
            }
            case 0: {
                return "list(";
            }
            case 2: {
                if (!beanMap) break;
                return "map(";
            }
            case 3: {
                return "getOptional(";
            }
            case 4: {
                return "getProvider(";
            }
        }
        return nullable ? "getNullable(" : "get(";
    }

    private static enum Type {
        LIST,
        SET,
        MAP,
        OPTIONAL,
        PROVIDER,
        OTHER;

    }
}

