/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.InjectModule;
import io.avaje.inject.generator.ProcessingContext;
import io.avaje.inject.generator.ScopeInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

class AllScopes {
    private final Map<String, Data> scopeAnnotations = new HashMap<String, Data>();
    private final ProcessingContext context;
    private final ScopeInfo defaultScope;

    AllScopes(ProcessingContext context) {
        this.context = context;
        this.defaultScope = new ScopeInfo(context);
    }

    ScopeInfo defaultScope() {
        return this.defaultScope;
    }

    ScopeInfo addScopeAnnotation(TypeElement type) {
        String key = type.getQualifiedName().toString();
        Data existing = this.scopeAnnotations.get(key);
        if (existing != null) {
            return existing.scopeInfo;
        }
        Data data = new Data(type, this.context, this);
        this.scopeAnnotations.put(key, data);
        return data.scopeInfo;
    }

    boolean providedByDefaultModule(String dependency) {
        return this.defaultScope.providesDependencyLocally(dependency);
    }

    void readBeans(RoundEnvironment roundEnv) {
        for (Data data : this.scopeAnnotations.values()) {
            for (Element element : roundEnv.getElementsAnnotatedWith(data.type)) {
                if (!(element instanceof TypeElement)) continue;
                data.scopeInfo.read((TypeElement)element, false);
            }
        }
    }

    void write(boolean processingOver) {
        for (Data value : this.scopeAnnotations.values()) {
            value.write(processingOver);
        }
    }

    void readModules(List<String> customScopeModules) {
        for (String customScopeModule : customScopeModules) {
            InjectModule injectModule;
            TypeElement module = this.context.element(customScopeModule);
            if (module == null || (injectModule = module.getAnnotation(InjectModule.class)) == null) continue;
            String customScopeType = injectModule.customScopeType();
            TypeElement scopeType = this.context.element(customScopeType);
            if (scopeType == null) {
                this.context.logError(module, "customScopeType [" + customScopeType + "] is invalid? on " + module, new Object[0]);
                continue;
            }
            ScopeInfo scopeInfo = this.addScopeAnnotation(scopeType);
            scopeInfo.readModuleMetaData(module);
        }
    }

    ScopeInfo get(String fullType) {
        Data data = this.scopeAnnotations.get(fullType);
        return data == null ? null : data.scopeInfo;
    }

    static class Data {
        final TypeElement type;
        final ScopeInfo scopeInfo;

        Data(TypeElement type, ProcessingContext context, AllScopes allScopes) {
            this.type = type;
            this.scopeInfo = new ScopeInfo(context, type, allScopes);
            this.scopeInfo.details(null, type);
        }

        void write(boolean processingOver) {
            this.scopeInfo.write(processingOver);
        }
    }
}

