/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.Util;
import java.util.Set;
import javax.lang.model.element.Element;

class AspectPair
implements Comparable<AspectPair> {
    private final String target;
    private final int ordering;
    private final String annotationFullName;
    private final String annotationShortName;

    AspectPair(Element anElement, String target, int ordering) {
        this.target = target;
        this.ordering = ordering;
        this.annotationFullName = anElement.asType().toString();
        this.annotationShortName = Util.shortName(this.annotationFullName);
    }

    String target() {
        return this.target;
    }

    void addImports(Set<String> importTypes) {
        importTypes.add(this.target);
        importTypes.add(this.annotationFullName);
    }

    String annotationShortName() {
        return this.annotationShortName;
    }

    @Override
    public int compareTo(AspectPair o) {
        return Integer.compare(this.ordering, o.ordering);
    }
}

