/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.Primary;
import io.avaje.inject.Prototype;
import io.avaje.inject.Secondary;
import io.avaje.inject.generator.Append;
import io.avaje.inject.generator.BeanAspects;
import io.avaje.inject.generator.BeanRequestParams;
import io.avaje.inject.generator.Dependency;
import io.avaje.inject.generator.FieldReader;
import io.avaje.inject.generator.GenericType;
import io.avaje.inject.generator.MetaData;
import io.avaje.inject.generator.MethodReader;
import io.avaje.inject.generator.ProcessingContext;
import io.avaje.inject.generator.TypeReader;
import io.avaje.inject.generator.Util;
import io.avaje.inject.spi.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

class BeanReader {
    private final TypeElement beanType;
    private final String shortName;
    private final String type;
    private final String name;
    private final MethodReader constructor;
    private final List<FieldReader> injectFields;
    private final List<MethodReader> injectMethods;
    private final List<MethodReader> factoryMethods;
    private final Element postConstructMethod;
    private final Element preDestroyMethod;
    private final Set<String> importTypes = new TreeSet<String>();
    private final BeanRequestParams requestParams;
    private final TypeReader typeReader;
    private final boolean prototype;
    private final boolean primary;
    private final boolean secondary;
    private final boolean proxy;
    private final BeanAspects aspects;
    private boolean writtenToFile;
    private boolean suppressBuilderImport;
    private boolean suppressGeneratedImport;
    private Set<GenericType> allGenericTypes;

    BeanReader(TypeElement beanType, ProcessingContext context, boolean factory) {
        this.beanType = beanType;
        this.type = beanType.getQualifiedName().toString();
        this.shortName = this.shortName(beanType);
        this.prototype = beanType.getAnnotation(Prototype.class) != null;
        this.primary = beanType.getAnnotation(Primary.class) != null;
        this.secondary = !this.primary && beanType.getAnnotation(Secondary.class) != null;
        this.proxy = beanType.getAnnotation(Proxy.class) != null;
        this.typeReader = new TypeReader(GenericType.parse(this.type), beanType, context, this.importTypes, factory);
        this.typeReader.process();
        this.requestParams = new BeanRequestParams(this.type);
        this.name = this.typeReader.getName();
        this.aspects = this.typeReader.hasAspects();
        this.injectMethods = this.typeReader.getInjectMethods();
        this.injectFields = this.typeReader.getInjectFields();
        this.factoryMethods = this.typeReader.getFactoryMethods();
        this.postConstructMethod = this.typeReader.getPostConstructMethod();
        this.preDestroyMethod = this.typeReader.getPreDestroyMethod();
        this.constructor = this.typeReader.getConstructor();
    }

    public String toString() {
        return this.beanType.toString();
    }

    TypeElement getBeanType() {
        return this.beanType;
    }

    BeanAspects aspects() {
        return this.aspects;
    }

    boolean prototype() {
        return this.prototype;
    }

    BeanReader read() {
        if (this.constructor != null) {
            this.constructor.addImports(this.importTypes);
            this.constructor.checkRequest(this.requestParams);
        }
        for (FieldReader field : this.injectFields) {
            field.addImports(this.importTypes);
            field.checkRequest(this.requestParams);
        }
        for (MethodReader method : this.injectMethods) {
            method.addImports(this.importTypes);
            method.checkRequest(this.requestParams);
        }
        for (MethodReader factoryMethod : this.factoryMethods) {
            factoryMethod.addImports(this.importTypes);
        }
        return this;
    }

    List<Dependency> getDependsOn() {
        ArrayList<Dependency> list = new ArrayList<Dependency>();
        if (this.constructor != null) {
            for (MethodReader.MethodParam param : this.constructor.getParams()) {
                Dependency dependsOn = param.getDependsOn();
                if (dependsOn.dependsOn().equals("io.avaje.inject.BeanScope")) continue;
                list.add(dependsOn);
            }
        }
        return list;
    }

    List<MethodReader> getFactoryMethods() {
        return this.factoryMethods;
    }

    List<String> getProvides() {
        return this.typeReader.getProvides();
    }

    Set<GenericType> getGenericTypes() {
        return this.typeReader.getGenericTypes();
    }

    Set<GenericType> allGenericTypes() {
        if (this.allGenericTypes != null) {
            return this.allGenericTypes;
        }
        this.allGenericTypes = new LinkedHashSet<GenericType>(this.typeReader.getGenericTypes());
        for (FieldReader field : this.injectFields) {
            field.addDependsOnGeneric(this.allGenericTypes);
        }
        for (MethodReader method : this.injectMethods) {
            method.addDependsOnGeneric(this.allGenericTypes);
        }
        if (this.constructor != null) {
            this.constructor.addDependsOnGeneric(this.allGenericTypes);
        }
        for (MethodReader factoryMethod : this.getFactoryMethods()) {
            factoryMethod.addDependsOnGeneric(this.allGenericTypes);
        }
        return this.allGenericTypes;
    }

    private String shortName(Element element) {
        return element.getSimpleName().toString();
    }

    String getMetaKey() {
        if (this.name != null) {
            return this.type + ":" + this.name;
        }
        return this.type;
    }

    boolean hasLifecycleMethods() {
        return this.postConstructMethod != null || this.preDestroyMethod != null || this.typeReader.isClosable();
    }

    List<MetaData> createFactoryMethodMeta() {
        if (this.factoryMethods.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MetaData> metaList = new ArrayList<MetaData>(this.factoryMethods.size());
        for (MethodReader factoryMethod : this.factoryMethods) {
            metaList.add(factoryMethod.createMeta());
        }
        return metaList;
    }

    MetaData createMeta() {
        Object type = this.beanType.getNestingKind().isNested() ? this.beanType.getEnclosingElement().toString() + "$" + this.beanType.getSimpleName() : this.beanType.getQualifiedName().toString();
        MetaData metaData = new MetaData((String)type, this.name);
        metaData.update(this);
        return metaData;
    }

    boolean isExtraInjectionRequired() {
        return !this.injectFields.isEmpty() || !this.injectMethods.isEmpty();
    }

    void buildAddFor(Append writer) {
        writer.append("    if (builder.isAddBeanFor(");
        if (this.name != null && !this.name.isEmpty()) {
            writer.append("\"%s\", ", this.name);
        }
        writer.append(this.typeReader.getTypesRegister());
        writer.append(")) {").eol();
    }

    void buildRegister(Append writer) {
        if (this.prototype) {
            return;
        }
        writer.append("      ");
        if (this.isExtraInjectionRequired() || this.hasLifecycleMethods()) {
            writer.append("%s $bean = ", this.shortName);
        }
        String flags = this.primary ? "Primary" : (this.secondary ? "Secondary" : "");
        writer.append("builder.register%s(bean);", flags).eol();
    }

    void addLifecycleCallbacks(Append writer, String indent) {
        if (this.postConstructMethod != null && !this.prototype) {
            writer.append("%s builder.addPostConstruct($bean::%s);", indent, this.postConstructMethod.getSimpleName()).eol();
        }
        if (this.preDestroyMethod != null) {
            this.prototypeNotSupported(writer, "@PreDestroy");
            writer.append("%s builder.addPreDestroy($bean::%s);", indent, this.preDestroyMethod.getSimpleName()).eol();
        } else if (this.typeReader.isClosable() && !this.prototype) {
            writer.append("%s builder.addPreDestroy($bean);", indent).eol();
        }
    }

    void prototypePostConstruct(Append writer, String indent) {
        if (this.postConstructMethod != null) {
            writer.append("%s bean.%s();", indent, this.postConstructMethod.getSimpleName()).eol();
        }
    }

    private void prototypeNotSupported(Append writer, String lifecycle) {
        if (this.prototype) {
            writer.append("        // @Prototype scoped bean does not support %s lifecycle method", lifecycle).eol();
        }
    }

    private Set<String> importTypes() {
        if (Util.validImportType(this.type)) {
            this.importTypes.add(this.type);
        }
        this.typeReader.extraImports(this.importTypes);
        this.requestParams.addImports(this.importTypes);
        this.aspects.extraImports(this.importTypes);
        for (MethodReader factoryMethod : this.factoryMethods) {
            Set<GenericType> genericTypes = factoryMethod.getGenericTypes();
            if (genericTypes.isEmpty()) continue;
            this.importTypes.add("java.lang.reflect.Type");
            this.importTypes.add("io.avaje.inject.spi.GenericType");
            this.importTypes.add("jakarta.inject.Provider");
            for (GenericType genericType : genericTypes) {
                genericType.addImports(this.importTypes);
            }
        }
        this.checkImports();
        if (!this.suppressGeneratedImport) {
            this.importTypes.add("io.avaje.inject.spi.Generated");
        }
        if (!this.suppressBuilderImport) {
            this.importTypes.add("io.avaje.inject.spi.Builder");
        }
        return this.importTypes;
    }

    private void checkImports() {
        for (String type : this.importTypes) {
            if (type.endsWith(".Builder")) {
                this.suppressBuilderImport = true;
                continue;
            }
            if (!type.endsWith(".Generated")) continue;
            this.suppressGeneratedImport = true;
        }
    }

    String builderType() {
        return this.suppressBuilderImport ? "io.avaje.inject.spi.Builder" : "Builder";
    }

    String generatedType() {
        return this.suppressGeneratedImport ? "@io.avaje.inject.spi.Generated" : "@Generated";
    }

    void writeImports(Append writer) {
        if (!this.allGenericTypes().isEmpty()) {
            this.importTypes.add("java.lang.reflect.Type");
            this.importTypes.add("io.avaje.inject.spi.GenericType");
        }
        for (String importType : this.importTypes()) {
            if (!Util.validImportType(importType)) continue;
            writer.append("import %s;", importType).eol();
        }
        writer.eol();
    }

    MethodReader getConstructor() {
        return this.constructor;
    }

    boolean isWrittenToFile() {
        return this.writtenToFile;
    }

    void setWrittenToFile() {
        this.writtenToFile = true;
    }

    boolean isRequestScopedController() {
        return this.requestParams.isRequestScopedController();
    }

    String suffix() {
        return this.isRequestScopedController() ? "$Factory" : "$DI";
    }

    void factoryInterface(Append writer) {
        this.requestParams.factoryInterface(writer);
    }

    void writeRequestCreate(Append writer) {
        if (this.constructor != null) {
            this.constructor.writeRequestDependency(writer);
        }
        for (FieldReader field : this.injectFields) {
            field.writeRequestDependency(writer);
        }
        for (MethodReader method : this.injectMethods) {
            method.writeRequestDependency(writer);
        }
        this.requestParams.writeRequestCreate(writer);
        writer.resetNextName();
        writer.append("    %s bean = new %s(", this.shortName, this.shortName);
        if (this.constructor != null) {
            this.constructor.writeRequestConstructor(writer);
        }
        writer.append(");").eol();
        for (FieldReader field : this.injectFields) {
            field.writeRequestInject(writer);
        }
        for (MethodReader method : this.injectMethods) {
            writer.append("    bean.%s(", method.getName());
            method.writeRequestConstructor(writer);
            writer.append(");").eol();
        }
        writer.append("    return bean;").eol();
        writer.append("  }").eol();
    }

    List<FieldReader> getInjectFields() {
        return this.typeReader.getInjectFields();
    }

    List<MethodReader> getInjectMethods() {
        return this.typeReader.getInjectMethods();
    }

    boolean isGenerateProxy() {
        return this.aspects.hasAspects() && !this.proxy;
    }

    void writeConstructorParams(Append writer) {
        if (this.constructor != null) {
            this.constructor.writeConstructorParams(writer);
        }
    }

    void writeConstructorInit(Append writer) {
        if (this.constructor != null) {
            writer.append("    super(");
            this.constructor.writeConstructorInit(writer);
            writer.append(");").eol();
        }
    }
}

