/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.Append;
import io.avaje.inject.generator.BeanRequestParams;
import io.avaje.inject.generator.GenericType;
import io.avaje.inject.generator.Util;
import io.avaje.inject.generator.UtilType;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;

class FieldReader {
    private final Element element;
    private final String name;
    private final UtilType utype;
    private final boolean nullable;
    private final String fieldType;
    private final GenericType type;
    private boolean requestParam;
    private String requestParamName;

    FieldReader(Element element) {
        this.element = element;
        this.name = Util.getNamed(element);
        this.nullable = Util.isNullable(element);
        this.utype = Util.determineType(element.asType());
        this.fieldType = Util.unwrapProvider(this.utype.rawType());
        this.type = GenericType.parse(this.utype.rawType());
    }

    boolean isGenericParam() {
        return this.type.isGenericType() && !this.type.isProviderType();
    }

    void addDependsOnGeneric(Set<GenericType> set) {
        if (this.isGenericParam()) {
            set.add(this.type);
        }
    }

    String getFieldName() {
        return this.element.getSimpleName().toString();
    }

    void addImports(Set<String> importTypes) {
        this.type.addImports(importTypes);
    }

    String builderGetDependency(String builder) {
        StringBuilder sb = new StringBuilder();
        sb.append(builder).append(".").append(this.utype.getMethod(this.nullable));
        if (this.isGenericParam()) {
            sb.append("TYPE_").append(this.type.shortName());
        } else {
            sb.append(Util.shortName(this.fieldType)).append(".class");
        }
        if (this.name != null) {
            sb.append(",\"").append(this.name).append("\"");
        }
        sb.append(")");
        return sb.toString();
    }

    void removeFromProvides(List<String> provides) {
        provides.remove(this.type.toString());
    }

    void checkRequest(BeanRequestParams requestParams) {
        this.requestParam = requestParams.check(this.utype.rawType());
        if (this.requestParam) {
            this.requestParamName = requestParams.argumentName(this.utype.rawType());
        }
    }

    void writeRequestDependency(Append writer) {
        if (!this.requestParam) {
            this.requestParamName = writer.nextName(this.getFieldName().toLowerCase());
            writer.append("  @Inject").eol().append("  ");
            this.type.writeShort(writer);
            writer.append(" %s;", this.requestParamName).eol().eol();
        }
    }

    void writeRequestInject(Append writer) {
        writer.append("    bean.%s = %s;", this.getFieldName(), this.requestParamName).eol();
    }
}

