/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.Bean;
import io.avaje.inject.generator.Append;
import io.avaje.inject.generator.BeanRequestParams;
import io.avaje.inject.generator.Dependency;
import io.avaje.inject.generator.GenericType;
import io.avaje.inject.generator.MetaData;
import io.avaje.inject.generator.MethodLifecycleReader;
import io.avaje.inject.generator.ProcessingContext;
import io.avaje.inject.generator.TypeReader;
import io.avaje.inject.generator.Util;
import io.avaje.inject.generator.UtilType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

class MethodReader {
    private static final String CODE_COMMENT_BUILD_FACTORYBEAN = "  /**\n   * Create and register %s via factory bean method %s#%s().\n   */";
    private final ExecutableElement element;
    private final String factoryType;
    private final String methodName;
    private final boolean prototype;
    private final String returnTypeRaw;
    private final GenericType genericType;
    private final String shortName;
    private final boolean isVoid;
    private final List<MethodParam> params = new ArrayList<MethodParam>();
    private final String factoryShortName;
    private final boolean isFactory;
    private final String initMethod;
    private final String destroyMethod;
    private final String name;
    private final TypeReader typeReader;
    private final boolean optionalType;

    MethodReader(ProcessingContext context, ExecutableElement element, TypeElement beanType) {
        this(context, element, beanType, null, null, false);
    }

    MethodReader(ProcessingContext context, ExecutableElement element, TypeElement beanType, Bean bean, String qualifierName, boolean prototype) {
        this.isFactory = bean != null;
        this.prototype = prototype;
        this.element = element;
        this.methodName = element.getSimpleName().toString();
        TypeMirror returnMirror = element.getReturnType();
        String raw = returnMirror.toString();
        if (Util.isOptional(raw)) {
            this.optionalType = true;
            this.returnTypeRaw = GenericType.trimWildcard(Util.extractOptionalType(raw));
        } else {
            this.optionalType = false;
            this.returnTypeRaw = GenericType.trimWildcard(raw);
        }
        this.genericType = GenericType.parse(this.returnTypeRaw);
        String topType = this.genericType.topType();
        this.shortName = Util.shortName(topType);
        this.factoryType = beanType.getQualifiedName().toString();
        this.factoryShortName = Util.shortName(this.factoryType);
        this.isVoid = Util.isVoid(topType);
        String initMethod = bean == null ? null : bean.initMethod();
        String destroyMethod = bean == null ? null : bean.destroyMethod();
        this.name = qualifierName;
        TypeElement returnElement = (TypeElement)context.asElement(returnMirror);
        if (returnElement == null) {
            this.typeReader = null;
            this.initMethod = initMethod;
            this.destroyMethod = destroyMethod;
        } else {
            this.typeReader = new TypeReader(this.genericType, returnElement, context);
            this.typeReader.process();
            MethodLifecycleReader lifecycleReader = new MethodLifecycleReader(returnElement, initMethod, destroyMethod);
            this.initMethod = lifecycleReader.initMethod();
            this.destroyMethod = lifecycleReader.destroyMethod();
        }
    }

    public String toString() {
        return "MethodReader{element=" + this.element + ", params=" + this.params + "}";
    }

    void addDependsOnGeneric(Set<GenericType> set) {
        for (MethodParam param : this.params) {
            param.addDependsOnGeneric(set);
        }
        if (this.genericType.isGenericType()) {
            set.add(this.genericType);
        }
        if (this.typeReader != null) {
            set.addAll(this.typeReader.getGenericTypes());
        }
    }

    MethodReader read() {
        List<? extends VariableElement> ps = this.element.getParameters();
        for (VariableElement variableElement : ps) {
            this.params.add(new MethodParam(variableElement));
        }
        return this;
    }

    String getName() {
        return this.methodName;
    }

    List<MethodParam> getParams() {
        return this.params;
    }

    MetaData createMeta() {
        MetaData metaData = new MetaData(this.returnTypeRaw, this.name);
        metaData.setMethod(this.fullBuildMethod());
        ArrayList<String> dependsOn = new ArrayList<String>(this.params.size() + 1);
        dependsOn.add(this.factoryType);
        for (MethodParam param : this.params) {
            dependsOn.add(GenericType.trimWildcard(param.paramType));
        }
        metaData.setDependsOn(dependsOn);
        metaData.setProvides(this.typeReader == null ? Collections.emptyList() : this.typeReader.getProvides());
        return metaData;
    }

    private String fullBuildMethod() {
        return this.factoryType + "$DI.build_" + this.element.getSimpleName().toString();
    }

    String builderGetFactory() {
        return String.format("      %s factory = builder.get(%s.class);", this.factoryShortName, this.factoryShortName);
    }

    void builderBuildBean(Append writer) {
        writer.append("      ");
        if (this.isVoid) {
            writer.append(String.format("factory.%s(", this.methodName));
        } else {
            String beanType = this.optionalType ? String.format("Optional<%s>", this.shortName) : this.shortName;
            String beanName = this.optionalType ? "optionalBean" : "bean";
            writer.append(beanType);
            writer.append(String.format(" %s = factory.%s(", beanName, this.methodName));
        }
        for (int i = 0; i < this.params.size(); ++i) {
            if (i > 0) {
                writer.append(", ");
            }
            this.params.get(i).builderGetDependency(writer, "builder", true);
        }
        writer.append(");").eol();
    }

    public void builderAddProtoBean(Append writer) {
        if (this.isVoid) {
            writer.append("Error - void @Prototype method ?").eol();
            return;
        }
        if (this.optionalType) {
            writer.append("Error - Optional type with @Prototype method is not supported").eol();
            return;
        }
        String indent = "    ";
        writer.append(indent).append("  // prototype scope bean method").eol();
        writer.append(indent).append("  builder.registerProvider(() -> {").eol();
        writer.append("%s    return ", indent);
        writer.append(String.format("factory.%s(", this.methodName));
        for (int i = 0; i < this.params.size(); ++i) {
            if (i > 0) {
                writer.append(", ");
            }
            this.params.get(i).builderGetDependency(writer, "builder", true);
        }
        writer.append(");").eol();
        writer.append(indent).append("  });").eol();
        writer.append(indent).append("}").eol();
    }

    void builderBuildAddBean(Append writer) {
        if (!this.isVoid) {
            String indent;
            String string = indent = this.optionalType ? "        " : "      ";
            if (this.optionalType) {
                writer.append("      if (optionalBean.isPresent()) {").eol();
                writer.append("        %s bean = optionalBean.get();", this.shortName).eol();
            }
            writer.append(indent);
            if (this.hasLifecycleMethods()) {
                writer.append("%s $bean = ", this.shortName);
            }
            writer.append("builder.register(bean);").eol();
            if (this.notEmpty(this.initMethod)) {
                writer.append(indent).append("builder.addPostConstruct($bean::%s);", this.initMethod).eol();
            }
            if (this.notEmpty(this.destroyMethod)) {
                writer.append(indent).append("builder.addPreDestroy($bean::%s);", this.destroyMethod).eol();
            } else if (this.typeReader != null && this.typeReader.isClosable()) {
                writer.append(indent).append("builder.addPreDestroy($bean::close);", this.destroyMethod).eol();
            }
            if (this.optionalType) {
                writer.append("      }").eol();
            }
        }
    }

    private boolean hasLifecycleMethods() {
        return this.notEmpty(this.initMethod) || this.notEmpty(this.destroyMethod) || this.typeReader != null && this.typeReader.isClosable();
    }

    private boolean notEmpty(String value) {
        return value != null && !value.isEmpty();
    }

    void addImports(Set<String> importTypes) {
        for (MethodParam param : this.params) {
            param.addImports(importTypes);
        }
        if (this.isFactory) {
            this.genericType.addImports(importTypes);
        }
        if (this.optionalType) {
            importTypes.add("java.util.Optional");
        }
        if (this.typeReader != null) {
            this.typeReader.addImports(importTypes);
        }
    }

    Set<GenericType> getGenericTypes() {
        return this.typeReader == null ? Collections.emptySet() : this.typeReader.getGenericTypes();
    }

    void buildAddFor(Append writer) {
        writer.append("    if (builder.isAddBeanFor(");
        if (this.isVoid) {
            writer.append("Void.class");
        } else {
            if (this.name != null && !this.name.isEmpty()) {
                writer.append("\"%s\", ", this.name);
            }
            if (this.typeReader != null) {
                writer.append(this.typeReader.getTypesRegister());
            }
        }
        writer.append(")) {").eol();
    }

    void checkRequest(BeanRequestParams requestParams) {
        for (MethodParam param : this.params) {
            param.checkRequest(requestParams);
        }
    }

    void writeRequestDependency(Append writer) {
        for (MethodParam param : this.params) {
            param.writeRequestDependency(writer);
        }
    }

    void writeRequestConstructor(Append writer) {
        for (MethodParam param : this.params) {
            param.writeRequestConstructor(writer);
        }
    }

    public void commentBuildMethod(Append writer) {
        writer.append(CODE_COMMENT_BUILD_FACTORYBEAN, this.shortName, this.factoryShortName, this.methodName).eol();
    }

    boolean isProtoType() {
        return this.prototype;
    }

    boolean isPublic() {
        return this.element.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    boolean isNotPrivate() {
        return !this.element.getModifiers().contains((Object)Modifier.PRIVATE);
    }

    void writeConstructorParams(Append writer) {
        for (MethodParam param : this.params) {
            writer.append(", ");
            param.writeMethodParam(writer);
        }
    }

    void writeConstructorInit(Append writer) {
        int size = this.params.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                writer.append(", ");
            }
            this.params.get(i).writeConstructorInit(writer);
        }
    }

    void removeFromProvides(List<String> provides) {
        for (MethodParam param : this.params) {
            param.removeFromProvides(provides);
        }
    }

    static class MethodParam {
        private final String named;
        private final UtilType utilType;
        private final String paramType;
        private final GenericType genericType;
        private final boolean nullable;
        private final String simpleName;
        private boolean requestParam;
        private String requestParamName;

        MethodParam(VariableElement param) {
            this.simpleName = param.getSimpleName().toString();
            this.named = Util.getNamed(param);
            this.nullable = Util.isNullable(param);
            this.utilType = Util.determineType(param.asType());
            this.paramType = this.utilType.rawType();
            this.genericType = GenericType.parse(this.paramType);
        }

        public String toString() {
            return "MethodParam{genericType=" + this.genericType + "}";
        }

        void addDependsOnGeneric(Set<GenericType> set) {
            if (this.genericType.isGenericType() && !this.genericType.isProviderType()) {
                set.add(this.genericType);
            }
        }

        void builderGetDependency(Append writer, String builderName, boolean forFactory) {
            writer.append(builderName).append(".").append(this.utilType.getMethod(this.nullable));
            if (!this.genericType.isGenericType()) {
                writer.append(Util.shortName(this.genericType.topType())).append(".class");
            } else if (this.isProvider()) {
                writer.append(this.providerParam()).append(".class");
            } else {
                writer.append("TYPE_").append(this.genericType.shortName());
            }
            if (this.named != null && !this.named.isEmpty()) {
                writer.append(",\"").append(this.named).append("\"");
            } else if (!this.isGenericParam() && this.utilType.allowsNamedQualifier()) {
                writer.append(",\"!");
                String shortName = Util.shortName(this.paramType);
                if (this.simpleName.endsWith(shortName)) {
                    writer.append(this.simpleName, 0, this.simpleName.length() - shortName.length());
                } else {
                    writer.append(this.simpleName);
                }
                writer.append("\"");
            }
            writer.append(")");
        }

        private String providerParam() {
            return Util.shortName(Util.unwrapProvider(this.paramType));
        }

        String simpleName() {
            return this.simpleName;
        }

        boolean isProvider() {
            return Util.isProvider(this.paramType);
        }

        boolean isGenericType() {
            return this.genericType.isGenericType();
        }

        boolean isGenericParam() {
            return this.isGenericType() && !this.isProvider();
        }

        Dependency getDependsOn() {
            return new Dependency(this.paramType, this.utilType.isCollection());
        }

        void addImports(Set<String> importTypes) {
            if (this.genericType.isGenericType()) {
                importTypes.add("jakarta.inject.Provider");
                this.genericType.addImports(importTypes);
            } else {
                this.genericType.addImports(importTypes);
            }
        }

        void checkRequest(BeanRequestParams requestParams) {
            this.requestParam = requestParams.check(this.paramType);
            if (this.requestParam) {
                this.requestParamName = requestParams.argumentName(this.paramType);
            }
        }

        void writeRequestDependency(Append writer) {
            if (!this.requestParam) {
                this.requestParamName = writer.nextName(Util.trimmedName(this.genericType));
                writer.append("  @Inject").eol();
                writer.append("  ");
                this.genericType.writeShort(writer);
                writer.append(" %s;", this.requestParamName).eol().eol();
            }
        }

        void writeRequestConstructor(Append writer) {
            writer.commaAppend(this.requestParamName);
        }

        void writeMethodParam(Append writer) {
            if (this.genericType.isGenericType()) {
                this.genericType.writeShort(writer);
            } else {
                writer.append(Util.shortName(this.genericType.topType()));
            }
            writer.append(" ").append(this.simpleName);
        }

        void writeMethodParamType(Append writer) {
            writer.append(Util.shortName(this.genericType.topType()));
        }

        void writeConstructorInit(Append writer) {
            writer.append(this.simpleName);
        }

        void removeFromProvides(List<String> provides) {
            provides.remove(this.genericType.toString());
        }
    }
}

