/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.ScopeInfo;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

class ProcessingContext {
    private final ProcessingEnvironment processingEnv;
    private final Messager messager;
    private final Filer filer;
    private final Elements elementUtils;
    private final Types typeUtils;
    private final Set<String> uniqueModuleNames = new HashSet<String>();

    ProcessingContext(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
        this.messager = processingEnv.getMessager();
        this.filer = processingEnv.getFiler();
        this.elementUtils = processingEnv.getElementUtils();
        this.typeUtils = processingEnv.getTypeUtils();
    }

    void logError(Element e, String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args), e);
    }

    void logError(String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args));
    }

    void logWarn(String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.WARNING, String.format(msg, args));
    }

    void logDebug(String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, String.format(msg, args));
    }

    String loadMetaInfServices() {
        List<String> lines = this.loadMetaInf("META-INF/services/io.avaje.inject.spi.Module");
        return lines.isEmpty() ? null : lines.get(0);
    }

    List<String> loadMetaInfCustom() {
        return this.loadMetaInf("META-INF/services/io.avaje.inject.spi.Module.Custom");
    }

    private List<String> loadMetaInf(String fullName) {
        try {
            FileObject fileObject = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", fullName);
            if (fileObject != null) {
                String line;
                ArrayList<String> lines = new ArrayList<String>();
                Reader reader = fileObject.openReader(true);
                LineNumberReader lineReader = new LineNumberReader(reader);
                while ((line = lineReader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty()) continue;
                    lines.add(line);
                }
                return lines;
            }
        }
        catch (FileNotFoundException | NoSuchFileException fileObject) {
        }
        catch (FilerException e) {
            this.logDebug("FilerException reading services file", new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logWarn("Error reading services file: " + e.getMessage(), new Object[0]);
        }
        return Collections.emptyList();
    }

    JavaFileObject createWriter(String cls) throws IOException {
        return this.filer.createSourceFile(cls, new Element[0]);
    }

    FileObject createMetaInfWriter(ScopeInfo.Type scopeType) throws IOException {
        String serviceName = scopeType == ScopeInfo.Type.DEFAULT ? "META-INF/services/io.avaje.inject.spi.Module" : "META-INF/services/io.avaje.inject.test.TestModule";
        return this.createMetaInfWriterFor(serviceName);
    }

    private FileObject createMetaInfWriterFor(String interfaceType) throws IOException {
        return this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", interfaceType, new Element[0]);
    }

    TypeElement element(String rawType) {
        return this.elementUtils.getTypeElement(rawType);
    }

    Types types() {
        return this.typeUtils;
    }

    TypeElement elementMaybe(String rawType) {
        if (rawType == null) {
            return null;
        }
        return this.elementUtils.getTypeElement(rawType);
    }

    Element asElement(TypeMirror returnType) {
        return this.typeUtils.asElement(returnType);
    }

    void addModule(String moduleFullName) {
        if (moduleFullName != null) {
            this.uniqueModuleNames.add(moduleFullName);
        }
    }

    boolean isDuplicateModule(String moduleFullName) {
        return this.uniqueModuleNames.contains(moduleFullName);
    }
}

