/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.Append;
import io.avaje.inject.generator.BeanReader;
import io.avaje.inject.generator.FieldReader;
import io.avaje.inject.generator.GenericType;
import io.avaje.inject.generator.MethodReader;
import io.avaje.inject.generator.ProcessingContext;
import io.avaje.inject.generator.Util;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;

class SimpleBeanWriter {
    private static final String CODE_COMMENT = "/**\n * Generated source - dependency injection builder for %s.\n */";
    private static final String CODE_COMMENT_FACTORY = "/**\n * Generated source - dependency injection factory for request scoped %s.\n */";
    private static final String CODE_COMMENT_BUILD = "  /**\n   * Create and register %s.\n   */";
    private static final String CODE_COMMENT_BUILD_PROVIDER = "  /**\n   * Register %s provider.\n   */";
    private final BeanReader beanReader;
    private final ProcessingContext context;
    private final String originName;
    private final String shortName;
    private final String packageName;
    private final String suffix;
    private final boolean proxied;
    private Append writer;
    String indent = "     ";

    SimpleBeanWriter(BeanReader beanReader, ProcessingContext context) {
        this.beanReader = beanReader;
        this.context = context;
        TypeElement origin = beanReader.getBeanType();
        this.originName = origin.getQualifiedName().toString();
        if (origin.getNestingKind().isNested()) {
            this.packageName = Util.nestedPackageOf(this.originName);
            this.shortName = Util.nestedShortName(this.originName);
        } else {
            this.packageName = Util.packageOf(this.originName);
            this.shortName = Util.shortName(this.originName);
        }
        this.suffix = beanReader.suffix();
        this.proxied = beanReader.isGenerateProxy();
    }

    private Writer createFileWriter() throws IOException {
        String originName = this.originName;
        if (this.beanReader.getBeanType().getNestingKind().isNested()) {
            originName = originName.replace(this.shortName, this.shortName.replace(".", "$"));
        }
        JavaFileObject jfo = this.context.createWriter(originName + this.suffix);
        return jfo.openWriter();
    }

    void write() throws IOException {
        this.writer = new Append(this.createFileWriter());
        this.writePackage();
        this.writeImports();
        this.writeClassStart();
        if (this.isRequestScopedController()) {
            this.writeRequestCreate();
        } else {
            this.writeGenericTypeFields();
            this.writeStaticFactoryMethod();
            this.writeStaticFactoryBeanMethods();
        }
        this.writeClassEnd();
        this.writer.close();
    }

    private void writeGenericTypeFields() {
        Set<GenericType> genericTypes = this.beanReader.allGenericTypes();
        if (!genericTypes.isEmpty()) {
            for (GenericType type : genericTypes) {
                this.writer.append("  public static final Type TYPE_%s = new GenericType<", type.shortName());
                type.writeShort(this.writer);
                this.writer.append(">(){}.type();").eol();
            }
            this.writer.eol();
        }
    }

    private void writeRequestCreate() {
        this.beanReader.writeRequestCreate(this.writer);
    }

    private boolean isRequestScopedController() {
        return this.beanReader.isRequestScopedController();
    }

    private void writeStaticFactoryBeanMethods() {
        for (MethodReader factoryMethod : this.beanReader.getFactoryMethods()) {
            this.writeFactoryBeanMethod(factoryMethod);
        }
    }

    private void writeFactoryBeanMethod(MethodReader method) {
        method.commentBuildMethod(this.writer);
        this.writer.append("  public static void build_%s(%s builder) {", method.getName(), this.beanReader.builderType()).eol();
        method.buildAddFor(this.writer);
        this.writer.append(method.builderGetFactory()).eol();
        if (method.isProtoType()) {
            method.builderAddProtoBean(this.writer);
        } else {
            method.builderBuildBean(this.writer);
            method.builderBuildAddBean(this.writer);
            this.writer.append("    }").eol();
        }
        this.writer.append("  }").eol().eol();
    }

    private void writeStaticFactoryMethod() {
        MethodReader constructor = this.beanReader.getConstructor();
        if (constructor == null) {
            this.context.logError(this.beanReader.getBeanType(), "Unable to determine constructor to use for %s? Add explicit @Inject to one of the constructors.", this.beanReader.getBeanType());
            return;
        }
        this.writeBuildMethodStart();
        if (this.proxied) {
            this.writer.append("    // this bean is proxied, see %s$Proxy$DI instead", this.shortName).eol();
        } else {
            this.writeAddFor(constructor);
        }
        this.writer.append("  }").eol().eol();
    }

    private void writeAddFor(MethodReader constructor) {
        this.beanReader.buildAddFor(this.writer);
        if (this.beanReader.prototype()) {
            this.indent = this.indent + "  ";
            this.writer.append("      // prototype scope so register provider").eol();
            this.writer.append("      builder.registerProvider(() -> {", this.shortName, this.shortName).eol();
        }
        this.writeCreateBean(constructor);
        this.beanReader.buildRegister(this.writer);
        this.beanReader.addLifecycleCallbacks(this.writer, this.indent);
        if (this.beanReader.isExtraInjectionRequired()) {
            this.writeExtraInjection();
        }
        if (this.beanReader.prototype()) {
            this.beanReader.prototypePostConstruct(this.writer, this.indent);
            this.writer.append("        return bean;").eol();
            this.writer.append("      });", this.shortName, this.shortName).eol();
        }
        this.writer.append("    }").eol();
    }

    private void writeBuildMethodStart() {
        if (this.beanReader.prototype()) {
            this.writer.append(CODE_COMMENT_BUILD_PROVIDER, this.shortName).eol();
        } else {
            this.writer.append(CODE_COMMENT_BUILD, this.shortName).eol();
        }
        this.writer.append("  public static void build(%s builder) {", this.beanReader.builderType()).eol();
    }

    private void writeCreateBean(MethodReader constructor) {
        this.writer.append("%s %s bean = new %s(", this.indent, this.shortName, this.shortName);
        this.writeMethodParams("builder", constructor);
    }

    private void writeExtraInjection() {
        if (!this.beanReader.prototype()) {
            this.writer.append("      builder.addInjector(b -> {").eol();
            this.writer.append("        // field and method injection").eol();
        }
        this.injectFields();
        this.injectMethods();
        if (!this.beanReader.prototype()) {
            this.writer.append("      });").eol();
        }
    }

    private void injectFields() {
        String bean = this.beanReader.prototype() ? "bean" : "$bean";
        String builder = this.beanReader.prototype() ? "builder" : "b";
        for (FieldReader fieldReader : this.beanReader.getInjectFields()) {
            String fieldName = fieldReader.getFieldName();
            String getDependency = fieldReader.builderGetDependency(builder);
            this.writer.append("        %s.%s = %s;", bean, fieldName, getDependency).eol();
        }
    }

    private void injectMethods() {
        String bean = this.beanReader.prototype() ? "bean" : "$bean";
        String builder = this.beanReader.prototype() ? "builder" : "b";
        for (MethodReader methodReader : this.beanReader.getInjectMethods()) {
            this.writer.append("        %s.%s(", bean, methodReader.getName());
            this.writeMethodParams(builder, methodReader);
        }
    }

    private void writeMethodParams(String builderRef, MethodReader methodReader) {
        List<MethodReader.MethodParam> methodParams = methodReader.getParams();
        for (int i = 0; i < methodParams.size(); ++i) {
            if (i > 0) {
                this.writer.append(", ");
            }
            methodParams.get(i).builderGetDependency(this.writer, builderRef, false);
        }
        this.writer.append(");").eol();
    }

    private void writeImports() {
        this.beanReader.writeImports(this.writer);
    }

    private void writeClassEnd() {
        this.writer.append("}").eol();
    }

    private void writeClassStart() {
        if (this.beanReader.isRequestScopedController()) {
            this.writer.append(CODE_COMMENT_FACTORY, this.shortName).eol();
        } else {
            this.writer.append(CODE_COMMENT, this.shortName).eol();
        }
        this.writer.append(this.beanReader.generatedType()).append("(\"io.avaje.inject.generator\")").eol();
        if (this.beanReader.isRequestScopedController()) {
            this.writer.append("@Singleton").eol();
        }
        String shortName = this.shortName;
        if (this.beanReader.getBeanType().getNestingKind().isNested()) {
            shortName = shortName.replace(".", "$");
        }
        this.writer.append("public class ").append(shortName).append(this.suffix).append(" ");
        if (this.beanReader.isRequestScopedController()) {
            this.writer.append("implements ");
            this.beanReader.factoryInterface(this.writer);
        }
        this.writer.append(" {").eol().eol();
    }

    private void writePackage() {
        if (this.packageName != null) {
            this.writer.append("package %s;", this.packageName).eol().eol();
        }
    }
}

